/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImplUtil {
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element -> element.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element -> element.getName();
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    private static final Map<String, SqlType> ourTypeCache = new ConcurrentWeakFactoryMap<String, SqlType>(){

        protected SqlType create(final String name) {
            return new SqlType(){

                public boolean isPrimitive() {
                    return false;
                }

                public String getDisplayName() {
                    return name;
                }
            };
        }
    };

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlTraverser"));
        }
        return syntaxTraverser;
    }

    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/sql/psi/impl/SqlImplUtil", "byElementType"));
        }
        return element -> {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/sql/psi/impl/SqlImplUtil", "lambda$byElementType$2"));
            }
            return ArrayUtil.contains((Object)element.getNode().getElementType(), (Object[])types);
        };
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlElement> sqlElements(@NotNull PsiElement root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlElements"));
        }
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root2).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlElement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlElements"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlParents"));
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "sqlParents"));
        }
        return jBIterable;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/sql/psi/impl/SqlImplUtil", "getBlockContentElement"));
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        ASTNode node = element == null ? null : element.getNode();
        return node == null ? null : node.getElementType();
    }

    @NotNull
    public static ResolveState setQualified(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlImplUtil", "setQualified"));
        }
        PsiElement qual = (PsiElement)state.get(CURRENT_QUALIFIER);
        if (qual != null || qualifier == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "setQualified"));
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(CURRENT_QUALIFIER, (Object)qualifier);
        if (resolveState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "setQualified"));
        }
        return resolveState;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifier"));
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results;
        ResolveResult[] resolveResultArray = results = ref == null ? null : ref.multiResolve(false);
        if (results == null || results.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "resolveQualified"));
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayList();
        for (ResolveResult result2 : results) {
            SqlResolveResult item = (SqlResolveResult)ObjectUtils.tryCast((Object)result2, SqlResolveResult.class);
            res.add(Pair.create((Object)(item == null ? null : item.getQualifier()), (Object)result2.getElement()));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "resolveQualified"));
        }
        return arrayList;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<ObjectKind> result2) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getParentTypes"));
        }
        if (ignored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/sql/psi/impl/SqlImplUtil", "getParentTypes"));
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add(type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = ContainerUtil.newLinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = result2.add(cur);
            if (--curSize == 0 && minLevel > 0 && ++curLevel == minLevel - 1) {
                result2.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<DbDataSource> dataSources) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasingProvider"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasingProvider"));
        }
        DbDataSource dataSource = (DbDataSource)Iterables.getFirst(dataSources, null);
        DasModel model = dataSource == null ? DasUtil.emptyModel() : dataSource.getModel();
        SqlLanguageDialectEx sqlLanguageDialectEx = model == DasUtil.emptyModel() ? dialect : model;
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasingProvider"));
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static String getActualName(Object o, @Nullable String name, boolean isPlain, @NotNull CasingProvider casing) {
        ObjectKind kind;
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/sql/psi/impl/SqlImplUtil", "getActualName"));
        }
        if (name == null || name == NULL_STRING) {
            return null;
        }
        ObjectKind objectKind = o instanceof DasObject ? ((DasObject)o).getKind() : (kind = o instanceof SqlReferenceExpression ? ((SqlReferenceExpression)o).getReferenceElementType().getTargetKind() : ObjectKind.TABLE);
        if (kind == ObjectKind.SCHEMA && StringUtil.isEmpty((String)name) && o instanceof DbElement) {
            return QNameUtil.getQualifiedName((DbElement)o);
        }
        Casing casing1 = casing.getCasing(kind, o instanceof DasObject ? (DasObject)o : null);
        return casing1.choose(isPlain).apply(name);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/sql/psi/impl/SqlImplUtil", "getSiblingToTheLeftOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/sql/psi/impl/SqlImplUtil", "getSiblingToTheRightOfType"));
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, @Nullable Condition<PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/sql/psi/impl/SqlImplUtil", "getSiblingToTheRightOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.FakeDefinition mirror;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlImplUtil", "getReferencedElements"));
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        Couple<SqlFileImpl.FakeDefinition> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.FakeDefinition fakeDefinition = mirrorPair.second != null ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.second) : (mirror = o.getKind() == ObjectKind.BODY ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.first) : null);
        if (mirror != null) {
            result2.add(mirror);
            mirror.delegates().addAllTo((Collection)result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult resolveResult : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = resolveResult.getElement();
                    result2.add(element);
                }
            } else {
                PsiElement element = reference.resolve();
                result2.add(element);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/psi/impl/SqlImplUtil", "getMirror"));
        }
        PsiFile file = o.getContainingFile();
        if (file instanceof SqlFileImpl) {
            Couple<SqlFileImpl.FakeDefinition> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getMirror"));
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getMirror"));
        }
        return couple;
    }

    public static boolean processObjectParents(PsiElement object, PsiScopeProcessor processor, ResolveState resolveState) {
        while (object != null) {
            if (!processor.execute(object, resolveState)) {
                return false;
            }
            if (!(object instanceof DasObject)) break;
            object = (PsiElement)ObjectUtils.tryCast((Object)((DasObject)object).getDbParent(), PsiElement.class);
        }
        return true;
    }

    public static boolean processQualifier(SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            return true;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/psi/impl/SqlImplUtil", "processQualifierImpl"));
        }
        ResolveResult[] results = reference.multiResolve(false);
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        SqlType type = reference.getSqlType();
        if (type instanceof SqlTableType) {
            SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, resolveState);
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected((PsiScopeProcessor)sqlProcessor);
        for (ResolveResult result2 : results) {
            DbNamespaceImpl schemaElement;
            PsiElement qualifier = result2.getElement();
            ResolveState qualifiedState = SqlImplUtil.setQualified(resolveState, qualifier);
            if (qualifier == null || !qualifier.isValid() || qualifier instanceof DasSynonym && ((qualifier = (PsiElement)DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)qualifier))) == null || !qualifier.isValid())) continue;
            if (qualifier != reference && !qualifier.processDeclarations(processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifier instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, qualifier)) {
                    return false;
                }
                PsiFile qualFile = qualifier.getContainingFile();
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, qualFile)) {
                    return false;
                }
                if (qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespaceImpl)((Object)ObjectUtils.tryCast((Object)qualifier, DbNamespaceImpl.class))) == null || schemaElement.getKind() != ObjectKind.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(sqlProcessor, schemaElement.createDeclarationProcessor(processor, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable PsiScopeProcessor processor) {
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        if (sqlProcessor == null) {
            return false;
        }
        Set<ObjectKind> expectedTypes = sqlProcessor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!sqlProcessor.dialect.isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((PsiElement)statement, resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement place, PsiElement qualifier) {
        return SqlImplUtil.processAlterStatements(qualifier.getContainingFile(), qualifier, (Processor<SqlAlterTableInstruction>)((Processor)instruction -> instruction.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement qualifierTarget, Processor<SqlAlterTableInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        PsiFile original = file.getOriginalFile();
        if (!(original instanceof SqlFile)) {
            return true;
        }
        return ContainerUtil.process((List)((SqlFile)original).getDdl(), statement -> {
            SqlAlterTableStatement o;
            SqlReferenceExpression target;
            return !(statement instanceof SqlAlterTableStatement) || (target = (o = (SqlAlterTableStatement)statement).getAlterTargetReference()) == null || !target.getReference().isReferenceTo(qualifierTarget) || ContainerUtil.process((Object[])o.getAlterTableInstructions(), (Processor)processor);
        });
    }

    public static List<PsiColumn> createColumnInfos(DasTable tableInfo, SqlTableType tableType) {
        assert (tableInfo instanceof PsiElement);
        int count = tableType.getColumnCount();
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)count);
        for (int i2 = 0; i2 < count; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType));
        }
        return result2;
    }

    public static boolean isParentKind(@NotNull SqlElement e, ObjectKind child, ObjectKind parent) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/psi/impl/SqlImplUtil", "isParentKind"));
        }
        if (child instanceof SqlDbElementType && ((SqlDbElementType)child).parentType == parent) {
            return true;
        }
        for (Couple couple : SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDatabaseDialect().getMetaModel().getKindCouples()) {
            if (couple.first != parent || couple.second != child) continue;
            return true;
        }
        return false;
    }

    public static boolean processFromReferences(PsiScopeProcessor processor, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        JBIterable iterable = fromExpression == null ? JBIterable.empty() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)fromExpression).expand(DasUtil.byClass(SqlJoinExpression.class))).filter(SqlReferenceExpression.class).filter(Conditions.notEqualTo((Object)lastParent));
        for (SqlReferenceExpression ref : iterable) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ref.multiResolve(false)) {
                PsiElement element = result2.getElement();
                if (!(element instanceof DasTable)) continue;
                if (!processor.execute(element, state)) {
                    return false;
                }
                if (SqlImplUtil.processAlterStatements(processor, state, place, element)) continue;
                return false;
            }
        }
        SqlType type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        return !(type instanceof SqlTableType) || SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state);
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/psi/impl/SqlImplUtil", "getTypeLateralAware"));
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getSqlType(end) : (end != null && PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType());
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getTypeLateralAware"));
        }
        return object;
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil", "createType"));
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, result2, qualifier);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "createType"));
        }
        return sqlTableType;
    }

    @NotNull
    public static SqlTableType createType(final String name, final @NotNull List<Column> result2, final @Nullable PsiElement qualifier) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil", "createType"));
        }
        Object object = result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @Override
            @Nullable
            public String getTypeName() {
                return name;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public SqlType getColumnType(int i2) {
                return ((Column)result2.get((int)i2)).type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            public DataType getDataType(int i2) {
                return DataType.UNKNOWN;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$1", "getColumnElement"));
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "createType"));
        }
        return object;
    }

    @NotNull
    public static SqlTableType getSelectType(@NotNull List<SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/psi/impl/SqlImplUtil", "getSelectType"));
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression e : list) {
            String name;
            SqlType type = e.getSqlType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)e, SqlTypeCastExpression.class);
            if (cast != null) {
                e = cast.getExpression();
            }
            String string = e instanceof SqlNameElement ? e.getName() : (name = e instanceof SqlDefinition ? e.getName() : null);
            if ("*".equals(name)) {
                name = null;
            }
            SqlType asType = name != null ? SqlTableTypeBase.createType((SqlElement)e, type, name, qualifier) : type;
            result2 = result2.add(SqlTableTypeBase.ensureTableType(asType, (SqlElement)e, qualifier));
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSelectType"));
        }
        return sqlTableType;
    }

    public static boolean processDeclarationsInType(SqlTableType tableType, PsiScopeProcessor processor, ResolveState state) {
        for (int i2 = 0; i2 < tableType.getColumnCount(); ++i2) {
            ResolveResult[] results;
            PsiElement columnQualifier = tableType.getColumnQualifier(i2);
            ResolveState qualifiedState = columnQualifier == null ? state : SqlImplUtil.setQualified(state, columnQualifier);
            PsiElement element = tableType.getColumnElement(i2);
            PsiElement sourceElement = tableType.getSourceColumnElement(i2);
            PsiElement source = element instanceof SqlDefinition || sourceElement == null ? element : sourceElement;
            ResolveResult[] resolveResultArray = results = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results.length > 0) {
                for (ResolveResult result2 : results) {
                    PsiElement target = result2.getElement();
                    if (target == null || processor.execute(target, qualifiedState)) continue;
                    return false;
                }
                continue;
            }
            if (processor.execute(source, qualifiedState)) continue;
            return false;
        }
        return true;
    }

    public static void acceptChildren(SqlElement parent, SqlVisitor visitor) {
        for (PsiElement element : parent.getChildren()) {
            if (!(element instanceof SqlElement)) continue;
            ((SqlElement)element).accept(visitor);
        }
    }

    public static boolean isAssignable(SqlType target, SqlType candidate) {
        if (target == candidate) {
            return true;
        }
        if (target == SqlType.REAL && candidate == SqlType.INTEGER) {
            return true;
        }
        return target == SqlType.DATE_TIME && (candidate == SqlType.DATE || candidate == SqlType.TIME || candidate == SqlType.TIMESTAMP);
    }

    @NotNull
    public static SqlType getSqlType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        SqlType type = definition.getSqlType();
        if (type == SqlType.UNKNOWN || type == SqlType.RECORD) {
            SqlType res = dialect.getDefinitionType(definition, place);
            SqlType sqlType = res == SqlType.UNKNOWN ? type : res;
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
            }
            return sqlType;
        }
        SqlType sqlType = type;
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        DasUserDefinedType type = object.getCustomType();
        if (type == null) {
            SqlType sqlType = SqlImplUtil.getSqlType(object.getDataType().typeName, dialect);
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
            }
            return sqlType;
        }
        SqlType sqlType = SqlImplUtil.getSqlType(type, (PsiElement)ObjectUtils.tryCast((Object)object, PsiElement.class), dialect);
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasUserDefinedType type, @Nullable PsiElement element, @NotNull SqlLanguageDialectEx dialect) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        JBIterable children = type.getDbChildren(DasTypedObject.class, ObjectKind.NONE);
        List columns2 = children.filter(PsiObject.class).transform(e -> {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "lambda$getSqlType$5"));
            }
            return new Column(e.getName(), SqlImplUtil.getSqlType((DasTypedObject)e, dialect), (PsiElement)e, (PsiElement)e);
        }).toList();
        Object object = columns2.isEmpty() ? SqlImplUtil.getSqlType(type.getName(), dialect) : SqlImplUtil.createType(columns2, element);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        return object;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull Project project, @NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        SqlFile file = SqlReaderImpl.asPsi(new SqlReaderImpl(project).parseSql((SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT, dataType.getSpecification()), PsiManager.getInstance((Project)project), context);
        SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)file, (Object)true);
        SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)file, SqlTypeElement.class);
        Object object = type == null ? SqlType.UNKNOWN : type.findSqlType();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        return object;
    }

    public static SqlType getSqlType(@Nullable String typeName, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlType"));
        }
        if (typeName == null) {
            return SqlType.UNKNOWN;
        }
        SqlType res = dialect.getSqlType(typeName);
        return res == SqlType.UNKNOWN ? ourTypeCache.get(typeName) : res;
    }

    public static boolean processDeclarationsDefault(SqlElement element, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element, SqlImplUtil.childrenTreeIt((PsiElement)element), processChildrenDeclarations, processor, state, lastParent, place, !(element instanceof SqlExpression) && !(element instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element instanceof DasObject ? ((DasObject)element).getKind() : ObjectKind.NONE;
        boolean checkLastParent = kind != ObjectKind.PACKAGE && kind != ObjectKind.OBJECT_TYPE && kind != ObjectKind.BODY;
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof PsiNamedElement ? !processor.execute(psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && !psiElement.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state, lastParent, place);
        }
        if (element instanceof SqlImplicitDeclarationsProvider && lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element, (PsiElement)lastParent, (boolean)true)) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element;
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)element);
            SqlScopeProcessor proc = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
            boolean stopIfFound = proc != null && proc.resolve && proc.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
            boolean resume = provider.processImplicitContextDeclarations(processor, state, lastParent, place);
            return resume &= !stopIfFound || proc.isResultEmpty();
        }
        return true;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<? extends T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/psi/impl/SqlImplUtil", "toArray"));
        }
        Object[] objectArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "toArray"));
        }
        return objectArray;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getReferenceList"));
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        List<SqlReferenceExpression> list2 = list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getReferenceList"));
        }
        return list2;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "getDataSources"));
        }
        PsiFile containingFile = element.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(containingFile.getProject()).getDataSources(containingFile);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getDataSources"));
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element) {
        SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect(element), (Object)SqlDialectMappings.getDefaultSqlDialect());
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getSqlDialectSafe"));
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj) {
        if (obj instanceof SqlSynonymDefinition) {
            ObjectKind synonymTargetType;
            SqlReferenceExpression ref = ((SqlSynonymDefinition)obj).getTargetReference();
            ObjectKind objectKind = synonymTargetType = ref != null ? ref.getReferenceElementType().getTargetKind() : null;
            if (synonymTargetType != null && synonymTargetType != SqlDbElementType.ANY) {
                ObjectKind objectKind2 = synonymTargetType;
                if (objectKind2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getKindSynonymAware"));
                }
                return objectKind2;
            }
        } else if (obj instanceof SqlAsExpression) {
            SqlType type = ((SqlAsExpression)obj).getSqlType();
            boolean isTable = type instanceof SqlTableType;
            if (type == SqlType.UNKNOWN) {
                PsiElement parent = ((SqlAsExpression)obj).getParent();
                isTable = parent instanceof SqlJoinExpression || parent instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? ObjectKind.TABLE : ObjectKind.COLUMN;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getKindSynonymAware"));
            }
            return objectKind;
        }
        DasObject target = obj instanceof DasSynonym ? DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)obj)) : obj;
        ObjectKind objectKind = target == null ? SqlDbElementType.ANY : target.getKind();
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getKindSynonymAware"));
        }
        return objectKind;
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element) {
        return JBIterable.from((Iterable)element.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element) {
        return SqlImplUtil.sqlChildren(element).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element) {
        StubElement stub;
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element);
    }

    public static boolean hasPlainIdentifier(Object t, DatabaseDialect dialect) {
        SqlNameElement nameElement;
        Object object = t instanceof BuiltinFunction ? null : (t instanceof SqlNameElement ? (SqlNameElement)t : (t instanceof SqlDefinition ? ((SqlDefinition)t).getNameElement() : (nameElement = t instanceof DbElement && ((DbElement)t).getDelegate() instanceof SqlDefinition ? ((SqlDefinition)((DbElement)t).getDelegate()).getNameElement() : null)));
        if (nameElement == null && t instanceof SqlFunctionDefinition) {
            return true;
        }
        if (nameElement instanceof RenameableFakePsiElement || nameElement == null && t instanceof DbElement) {
            String name = nameElement != null ? nameElement.getName() : ((DbElement)t).getName();
            return dialect.quoteIdentifier(name, false, false) == name;
        }
        if (nameElement != null) {
            return nameElement.isPlainIdentifier();
        }
        return false;
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "getLabels"));
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "lambda$getLabels$6"));
            }
            return CachedValueProvider.Result.create((Object)SqlImplUtil.sqlTraverser(element).filter(SqlLabelDefinitionImpl.class).toList(), (Object[])new Object[]{element});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getLabels"));
        }
        return list;
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<DbElement> wrapper, DbElement schemaElement) {
        Condition majorChildCondition = element -> processor.dialect.isMajorChild(element.getKind());
        for (DbTable child : schemaElement.getDbChildren(DbTable.class, ObjectKind.TABLE)) {
            if (ContainerUtil.process((Iterable)child.getDbChildren(DbElement.class, ObjectKind.NONE).filter(majorChildCondition), wrapper)) continue;
            return false;
        }
        return true;
    }

    public static void quoteIdentifier(Project project, final SqlIdentifier identifier, final SqlLanguageDialect dialect) {
        new WriteCommandAction(project, new PsiFile[]{identifier.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil$3", "run"));
                }
                identifier.setName(dialect.getDatabaseDialect().quoteIdentifier(identifier.getName(), true, false));
            }
        }.execute();
    }

    public static void unquoteIdentifier(final Project project, final SqlIdentifier identifier, final SqlLanguageDialect dialect) {
        new WriteCommandAction(project, new PsiFile[]{identifier.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil$4", "run"));
                }
                SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
                if (newId != null) {
                    identifier.replace((PsiElement)newId);
                }
            }
        }.execute();
    }

    public static boolean canUnquote(@NotNull String newText, @NotNull DatabaseDialect dialect) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/sql/psi/impl/SqlImplUtil", "canUnquote"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlImplUtil", "canUnquote"));
        }
        return StringUtil.equals((CharSequence)dialect.quoteIdentifier(newText, false, false), (CharSequence)newText);
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tmpFile", "com/intellij/sql/psi/impl/SqlImplUtil", "getTopLevelSqlFile"));
        }
        if (tmpFile instanceof DummyHolder) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/sql/psi/impl/SqlImplUtil", "isSameSqlFileDialect"));
        }
        SqlLanguageDialect fileDialect = parent instanceof SqlFile ? ((SqlFile)parent).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/impl/SqlImplUtil", "getTopLevelFile"));
        }
        PsiFile tmpFile = file;
        if (tmpFile instanceof DummyHolder) {
            PsiElement context = tmpFile.getContext();
            if (context != null) {
                tmpFile = context.getContainingFile();
            }
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            if (topLevelFile != null) {
                tmpFile = topLevelFile;
            }
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    public static PsiFile getContainingFile(@NotNull SqlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "getContainingFile"));
        }
        return SqlImplUtil.getTopLevelSqlFile(element.getContainingFile());
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasedPart"));
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasedPart"));
            }
            return string;
        }
        ArrayList parts = ContainerUtil.newArrayList();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), casingProvider, null, tableRef, (List<Object>)parts);
        int len = parts.size();
        for (int i2 = 0; i2 < len; i2 += 3) {
            if (parts.get(i2) != kind) continue;
            String string = (String)parts.get(i2 + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasedPart"));
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getCasedPart"));
        }
        return string;
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element) {
        PsiElement target;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifierKind"));
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        PsiElement psiElement = target = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryClause.class) != null) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifierKind"));
            }
            return objectKind;
        }
        ObjectKind objectKind = target instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target) : ObjectKind.NONE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifierKind"));
        }
        return objectKind;
    }

    @NotNull
    public static SqlType getQualifierType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifierType"));
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        Object object = qualifier != null ? qualifier.getSqlType() : SqlType.UNKNOWN;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getQualifierType"));
        }
        return object;
    }

    @NotNull
    public static SqlType getConcreteType(@NotNull SqlType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlImplUtil", "getConcreteType"));
        }
        SqlType sqlType = type instanceof SqlTableType ? (SqlType)ObjectUtils.chooseNotNull((Object)((SqlTableType)type).getConcreteType(), (Object)type) : type;
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getConcreteType"));
        }
        return sqlType;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/sql/psi/impl/SqlImplUtil", "isAutoVal"));
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterarateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/impl/SqlImplUtil", "iterarateStatementsBackward"));
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element -> element.getTextRange().getStartOffset() < offset && (!(element instanceof SqlStatement) || element.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "iterarateStatementsBackward"));
        }
        return jBIterable;
    }

    @NotNull
    public static List<PsiColumn> mergeColumnListInto(@NotNull List<PsiColumn> a, @NotNull List<? extends PsiColumn> b, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> mergeCheck) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/sql/psi/impl/SqlImplUtil", "mergeColumnListInto"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/sql/psi/impl/SqlImplUtil", "mergeColumnListInto"));
        }
        a.addAll(SqlImplUtil.processColumnList(b, a, caseSensitive, mergeCheck, true));
        List<PsiColumn> list = a;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "mergeColumnListInto"));
        }
        return list;
    }

    @NotNull
    public static List<PsiColumn> processColumnList(@NotNull List<? extends PsiColumn> tgt, @NotNull List<? extends PsiColumn> src, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> check, boolean skip) {
        if (tgt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tgt", "com/intellij/sql/psi/impl/SqlImplUtil", "processColumnList"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/sql/psi/impl/SqlImplUtil", "processColumnList"));
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)tgt.size());
        Map tgtMap = DasUtil.newCaseAwareMap((boolean)caseSensitive);
        for (PsiColumn psiColumn : src) {
            tgtMap.put(psiColumn.getName(), psiColumn);
        }
        for (PsiColumn psiColumn : tgt) {
            boolean matched;
            PsiColumn old = (PsiColumn)tgtMap.remove(psiColumn.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)psiColumn) != false);
            if (matched && skip) continue;
            result2.add(matched ? old : psiColumn);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "processColumnList"));
        }
        return arrayList;
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getDataType().equals(b.getDataType());
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    public static boolean equalsInsensetiveOrTrue(@Nullable String a, @Nullable String b, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b, (boolean)false);
    }

    @NotNull
    public static PsiElement[] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/psi/impl/SqlImplUtil", "getRelatedElements"));
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> {
            if (definition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/psi/impl/SqlImplUtil", "lambda$getRelatedElements$10"));
            }
            return CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "getRelatedElements"));
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] calcRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/psi/impl/SqlImplUtil", "calcRelatedElements"));
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class);
        if (ref == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "calcRelatedElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "calcRelatedElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results = newRef.multiResolve(false);
        if (results.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "calcRelatedElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            related[i2] = results[i2].getElement();
        }
        if (related == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil", "calcRelatedElements"));
        }
        return related;
    }

    private static class EmptyTable
    extends DasObject.Adapter
    implements DasTable {
        private EmptyTable() {
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
            if (c instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c).isAutoIncrementColumn(c)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable", "getColumnAttrs"));
                }
                return enumSet;
            }
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable", "getColumnAttrs"));
            }
            return set;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable", "getKind"));
            }
            return objectKind;
        }
    }

    public static class Column {
        public final String name;
        public final SqlType type;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name, SqlType type, @NotNull PsiElement element, PsiElement sourceElement) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
            }
            this.name = name;
            this.type = type;
            this.element = element;
            this.sourceElement = sourceElement;
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn {
        final DasTable myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasColumn myInfo;

        public MyColumnInfo(DasTable parent, int index, SqlTableType tableType) {
            super((PsiElement)((PsiElement)parent).getContainingFile());
            this.myTableInfo = parent;
            this.myIndex = index;
            this.myTableType = tableType;
            PsiElement columnElement = tableType.getSourceColumnElement(index);
            this.myInfo = columnElement instanceof DasColumn ? (DasColumn)columnElement : null;
        }

        public String getTableName() {
            return this.myTableInfo.getName();
        }

        public DasTable getTable() {
            return this.myTableInfo;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getKind"));
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)"noname");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getName"));
            }
            return string;
        }

        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        public DasObject getDbParent() {
            return this.getTable();
        }

        @NotNull
        public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getDbChildren"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getDbChildren"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getDbChildren"));
            }
            return jBIterable;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myInfo != null ? this.myInfo.getDataType() : DataTypeFactory.of(this.myTableType.getColumnType(this.myIndex).getDisplayName());
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getDataType"));
            }
            return dataType;
        }

        @Nullable
        public DasUserDefinedType getCustomType() {
            return null;
        }

        public boolean isNotNull() {
            return this.myInfo != null && this.myInfo.isNotNull();
        }

        public String getDefault() {
            return this.myInfo == null ? null : this.myInfo.getDefault();
        }

        public PsiElement getParent() {
            return (PsiElement)this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentation.getPresentableName(this.getKind(), GenericDialect.INSTANCE);
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getNavigationElement"));
            }
            return psiElement;
        }

        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @NotNull
        public String getDisplayOrder() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo", "getDisplayOrder"));
            }
            return string;
        }
    }
}

