/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.impl.lexer.SqlStringTokenLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralEscaper
extends LiteralTextEscaper<SqlStringLiteralExpression> {
    private int[] outSourceOffsets;

    public SqlStringLiteralEscaper(SqlStringLiteralExpression element) {
        super((PsiLanguageInjectionHost)element);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        IElementType elementType = SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost);
        String text = ((SqlStringLiteralExpression)this.myHost).getText();
        int r0 = rangeInsideHost.getStartOffset();
        int r1 = rangeInsideHost.getEndOffset();
        if (elementType == SqlTokens.SQL_STRING_TOKEN) {
            this.outSourceOffsets = new int[rangeInsideHost.getLength() + 1];
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this.myHost).getDatabaseDialect();
            SqlStringLiteralEscaper.decode(text, r0, r1, outChars, this.outSourceOffsets, dialect);
        } else {
            this.outSourceOffsets = null;
            outChars.append(text, rangeInsideHost.getStartOffset(), rangeInsideHost.getEndOffset());
        }
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "getOffsetInHost"));
        }
        IElementType elementType = SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost);
        int offset = offsetInDecoded;
        if (elementType == SqlTokens.SQL_STRING_TOKEN && this.outSourceOffsets != null) {
            int result2;
            int n = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
            if (result2 == -1) {
                return -1;
            }
            return (result2 <= rangeInsideHost.getLength() ? result2 : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
        }
        if ((offset += rangeInsideHost.getStartOffset()) < rangeInsideHost.getStartOffset()) {
            offset = rangeInsideHost.getStartOffset();
        }
        if (offset > rangeInsideHost.getEndOffset()) {
            offset = rangeInsideHost.getEndOffset();
        }
        return offset;
    }

    public boolean isOneLine() {
        return SqlStringLiteralManipulator.getStringTokenType((SqlStringLiteralExpression)this.myHost) != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
    }

    public static boolean supportsSlashEscapes(@NotNull SqlStringTokenElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "supportsSlashEscapes"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "supportsSlashEscapes"));
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        return familyId.isMysql() || familyId.isPostgres() && StringUtil.startsWithIgnoreCase((String)text, (String)"e");
    }

    public static void decode(@NotNull CharSequence text, int start, int end, @NotNull StringBuilder outChars, @Nullable int[] outOffsets, @NotNull DatabaseDialectEx dialect) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/impl/SqlStringLiteralEscaper", "decode"));
        }
        SqlStringTokenLexer lexer = new SqlStringTokenLexer(dialect);
        lexer.start(text, 0, text.length());
        int pos = 0;
        while (lexer.getTokenType() != null) {
            IElementType type = lexer.getTokenType();
            int t0 = lexer.getTokenStart();
            int t1 = lexer.getTokenEnd();
            if (t1 < start) {
                lexer.advance();
                continue;
            }
            for (int i2 = Math.max(t0, start); i2 < Math.min(t1, end); ++i2) {
                if (type == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) {
                    char esc = text.charAt(t1 - 1);
                    if (i2 != Math.max(t0, start)) continue;
                    outChars.append((char)(esc == 'b' ? 8 : (esc == 'n' ? 10 : (esc == 'r' ? 13 : (esc == 't' ? 9 : (esc == 'Z' ? 22 : (esc == '0' ? 0 : (esc == 'f' ? 12 : (int)esc))))))));
                    if (outOffsets == null) continue;
                    outOffsets[pos++] = i2 - start;
                    continue;
                }
                if (type == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) continue;
                outChars.append(text.charAt(i2));
                if (outOffsets == null) continue;
                outOffsets[pos++] = i2 - start;
            }
            if (t1 > end) break;
            lexer.advance();
        }
        if (outOffsets != null) {
            outOffsets[pos] = end - start;
        }
    }
}

