/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringTokenLexer
extends LexerBase {
    private final DatabaseDialect myDialect;
    private boolean myWithSlashEscapes;
    protected CharSequence myBuffer;
    protected int myStart;
    protected int myEnd;
    protected int myBufferStart;
    protected int myBufferEnd;
    protected IElementType myTokenType;
    private int myFirstQuoteOffset;

    public SqlStringTokenLexer(DatabaseDialect dialect) {
        this.myDialect = dialect;
    }

    public int getState() {
        return 0;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myStart = this.myEnd;
        this.locateToken();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/lexer/SqlStringTokenLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/sql/psi/impl/lexer/SqlStringTokenLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myStart = this.myEnd = startOffset;
        this.myBufferStart = this.myEnd;
        this.myBufferEnd = endOffset;
        this.myWithSlashEscapes = this.myDialect.getFamilyId().isMysql() || this.myDialect.getFamilyId().isPostgres() && startOffset < endOffset && (buffer.charAt(this.myBufferStart) == 'e' || buffer.charAt(this.myBufferStart) == 'E');
        this.myFirstQuoteOffset = StringUtil.indexOf((CharSequence)buffer, (char)'\'', (int)this.myBufferStart, (int)this.myBufferEnd);
        this.locateToken();
    }

    private void locateToken() {
        if (this.myStart >= this.myBufferEnd) {
            this.myTokenType = null;
            return;
        }
        char curChar = this.myBuffer.charAt(this.myStart);
        if (this.myStart + 1 >= this.myBufferEnd - 1 && curChar == '\\' && this.myWithSlashEscapes) {
            ++this.myEnd;
            this.myTokenType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        } else if (!(curChar == '\\' && this.myWithSlashEscapes || curChar == '\'' && this.myStart > this.myFirstQuoteOffset && this.myStart < this.myBufferEnd - 1)) {
            char c;
            this.myTokenType = SqlTokens.SQL_STRING_TOKEN;
            while (!(++this.myEnd >= this.myBufferEnd || (c = this.myBuffer.charAt(this.myEnd)) == '\'' && this.myEnd != this.myBufferEnd - 1 || c == '\\' && this.myWithSlashEscapes)) {
            }
        } else if (curChar == '\'' && curChar == this.myBuffer.charAt(this.myStart + 1)) {
            this.myEnd += 2;
            this.myTokenType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        } else {
            this.myEnd += 2;
            this.myTokenType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
    }
}

