/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.stubs.SqlAlterStatementStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSynonymStub<T extends SqlSynonymDefinition>
extends SqlNamedElementStub<T> {
    private final StringRef myTargetName;
    private SqlReferenceExpression myTargetReference;

    protected SqlSynonymStub(StubElement parent, @NotNull SqlStubElementType type, StringRef name, StringRef targetName) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/stubs/SqlSynonymStub", "<init>"));
        }
        super(parent, type, name);
        this.myTargetName = targetName;
    }

    public String getTargetName() {
        return this.myTargetName == null ? null : this.myTargetName.getString();
    }

    public SqlReferenceExpression getTargetReference() {
        if (this.myTargetReference == null) {
            SqlNamedElementStub<?> stub = this.getAlterStatementStub();
            String targetName = this.myTargetName == null && stub != null ? stub.getName() : this.getTargetName();
            this.myTargetReference = this.createReference(this.getReferenceTypeInner(stub), targetName);
        }
        return this.myTargetReference;
    }

    public SqlNameElement getNameReference() {
        return super.getNameReference(this.getReferenceType());
    }

    public SqlReferenceElementType getReferenceType() {
        return this.getReferenceTypeInner(this.getAlterStatementStub());
    }

    @NotNull
    protected SqlReferenceElementType getReferenceTypeInner(@Nullable SqlNamedElementStub<?> stub) {
        String statementTarget;
        SqlAlterStatementStubElementType type = stub == null ? null : (SqlAlterStatementStubElementType)stub.getStubType();
        String string = statementTarget = stub == null ? null : stub.getName();
        if (type == null) {
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_REFERENCE;
            if (sqlReferenceElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymStub", "getReferenceTypeInner"));
            }
            return sqlReferenceElementType;
        }
        if (this.myTargetName == null || statementTarget == null) {
            SqlReferenceElementType sqlReferenceElementType = type.getTargetReferenceType();
            if (sqlReferenceElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymStub", "getReferenceTypeInner"));
            }
            return sqlReferenceElementType;
        }
        if (type.getTargetReferenceType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
            if (sqlReferenceElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymStub", "getReferenceTypeInner"));
            }
            return sqlReferenceElementType;
        }
        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymStub", "getReferenceTypeInner"));
        }
        return sqlReferenceElementType;
    }

    @Nullable
    public SqlNamedElementStub<?> getAlterStatementStub() {
        for (StubElement stub = this.getParentStub(); stub != null; stub = stub.getParentStub()) {
            if (!(stub instanceof SqlNamedElementStub) || !(stub.getStubType() instanceof SqlAlterStatementStubElementType)) continue;
            return (SqlNamedElementStub)stub;
        }
        return null;
    }
}

