/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.statistic;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SqlDataSourceUsageCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/statistic/SqlDataSourceUsageCollector", "getProjectUsages"));
        }
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Set set = ContainerUtil.map2Set(SqlDataSourceStorage.getInstance(project).getDataSources(), dataSource -> {
            for (String url : dataSource.getUrls()) {
                VirtualFile file = manager.findFileByUrl(url);
                if (file == null) continue;
                return new UsageDescriptor(mappings.getMapping(file).getID(), 1);
            }
            return new UsageDescriptor("empty", 1);
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/statistic/SqlDataSourceUsageCollector", "getProjectUsages"));
        }
        return set;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"sql-datasource", (double)100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/statistic/SqlDataSourceUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

