/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathChecker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentPathUtils {
    private static final Logger LOG = Logger.getInstance(DeploymentPathUtils.class);
    public static final FileObject[] NO_CHILDREN = new FileObject[0];

    private DeploymentPathUtils() {
    }

    @Nullable
    private static FileObject getExcludedFile(ExecutionContext context, FileObject source, FileObject target) {
        FileObject remoteFile;
        FileObject localFile;
        String serverId = context.getServer().getId();
        List<ExcludedPath> paths = context.getConfig().getExcludedPaths(serverId);
        if (context.isServerSideModification()) {
            localFile = source;
            remoteFile = target;
        } else {
            localFile = target;
            remoteFile = source;
        }
        for (ExcludedPath path : paths) {
            if (path.isLocal()) {
                if (!path.isParentForLocalPath(DeploymentPathUtils.getLocalPath(localFile))) continue;
                LOG.debug("Skipping excluded local path in process: " + localFile.getName().getPath());
                return localFile;
            }
            if (!path.isParentForRemotePath(remoteFile.getName(), false, context.getServer())) continue;
            LOG.debug("Skipping excluded remote path in process: " + remoteFile.getName().getPath());
            return remoteFile;
        }
        return null;
    }

    private static FileType getType(FileObject target, boolean targetExists) throws FileSystemException {
        return targetExists ? target.getType() : FileType.IMAGINARY;
    }

    public static void refreshRemoteFile(FileObject file, ExecutionContextBase context) throws FileSystemException {
        DeploymentPathUtils.refreshRemoteFile(file, context, true);
    }

    private static void refreshRemoteFile(FileObject file, ExecutionContextBase context, boolean refreshFile) throws FileSystemException {
        if (PublishUtils.DISABLE_FILESYSTEM_CACHE) {
            context.addAffectedRoot(file.getName(), true);
            return;
        }
        FileObject parent = file.getParent();
        if (parent != null) {
            parent.refresh();
            if (refreshFile) {
                file.refresh();
            }
            if (!file.exists()) {
                DeploymentPathUtils.refreshRemoteFile(parent, context, false);
            }
            context.addAffectedRoot(parent.getName(), true);
        } else {
            file.refresh();
            context.addAffectedRoot(file.getName(), true);
        }
    }

    public static ErrorsAndExclusions processOutgoing(FileObject source, List<TransferOperation> result, ExecutionContext context) throws FileSystemException {
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.isServerSideModification() ? context.getConfig().getNearestMappingForLocal(source, false, true, false, (Mappable)context.getServer()) : context.getConfig().getNearestMappingDeploy2Local(source, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(source, context.isServerSideModification(), context);
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        if (mapping != null) {
            FileObject target = context.isServerSideModification() ? context.findRemoteFile(mapping.mapToDeployPath(source, (Mappable)context.getServer()), true) : DeploymentPathUtils.getLocalFile(mapping.mapToLocalPath(source.getName(), (Mappable)context.getServer()));
            return new DeploymentPathProcessor(context, result, true).processPath(source, target, mapping);
        }
        Pair<List<DeploymentPathMapping>, Boolean> childMappingsPair = context.isServerSideModification() ? context.getConfig().getChildMappingsForLocal(source, true, false, (Mappable)context.getServer()) : context.getConfig().getChildMappingsDeploy2Local(source, (Mappable)context.getServer());
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        if (((List)childMappingsPair.getFirst()).isEmpty() && Boolean.TRUE == childMappingsPair.getSecond()) {
            errorsAndExclusions.addExcludedPath(source, context.isServerSideModification(), context);
        }
        for (DeploymentPathMapping childMapping : (List)childMappingsPair.getFirst()) {
            FileObject targetChild;
            FileObject sourceChild;
            context.getProgressIndicator().checkCanceled();
            if (context.isServerSideModification()) {
                sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                targetChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
            } else {
                sourceChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
                targetChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
            }
            ErrorsAndExclusions e = new DeploymentPathProcessor(context, result, true).processPath(sourceChild, targetChild, childMapping);
            errorsAndExclusions.addAll(e);
        }
        return errorsAndExclusions;
    }

    public static ErrorsAndExclusions processIncoming(FileObject target, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.isServerSideModification() ? context.getConfig().getNearestMappingDeploy2Local(target, false, (Mappable)context.getServer()) : context.getConfig().getNearestMappingForLocal(target, false, true, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(target, context.isServerSideModification(), context);
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        if (mapping != null) {
            FileObject source = context.isServerSideModification() ? DeploymentPathUtils.getLocalFile(mapping.mapToLocalPath(target.getName(), (Mappable)context.getServer())) : context.findRemoteFile(mapping.mapToDeployPath(target, (Mappable)context.getServer()), true);
            return new DeploymentPathProcessor(context, result, false).processPath(source, target, mapping);
        }
        Pair<List<DeploymentPathMapping>, Boolean> childMappings = context.isServerSideModification() ? context.getConfig().getChildMappingsDeploy2Local(target, (Mappable)context.getServer()) : context.getConfig().getChildMappingsForLocal(target, true, false, (Mappable)context.getServer());
        if (((List)childMappings.getFirst()).isEmpty() && Boolean.TRUE == childMappings.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(target, context.isServerSideModification(), context);
        }
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        for (DeploymentPathMapping childMapping : (List)childMappings.getFirst()) {
            FileObject targetChild;
            FileObject sourceChild;
            context.getProgressIndicator().checkCanceled();
            if (context.isServerSideModification()) {
                sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                targetChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
            } else {
                sourceChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
                targetChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
            }
            ErrorsAndExclusions e = new DeploymentPathProcessor(context, result, false).processPath(sourceChild, targetChild, childMapping);
            errorsAndExclusions.addAll(e);
        }
        return errorsAndExclusions;
    }

    @Nullable
    public static FileObject getLocalFile(String localPath) {
        File file = new File(localPath);
        try {
            return PublishUtils.getManager().toFileObject(file);
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static String getFileName(WebServerConfig.RemotePath remotePath) {
        String path = remotePath.path.replace(File.separatorChar, '/');
        int i = path.lastIndexOf(47);
        return i != -1 ? path.substring(i + 1) : path;
    }

    @Nullable
    public static String getPathRemainder(String parentPath, String childPath, boolean caseSensitive) {
        if (StringUtil.isEmpty((String)parentPath)) {
            return null;
        }
        LOG.assertTrue(StringUtil.isNotEmpty((String)childPath));
        String parentPathIndependent = parentPath.replace(File.separatorChar, '/');
        String childPathIndependent = childPath.replace(File.separatorChar, '/');
        if (!caseSensitive) {
            parentPathIndependent = parentPathIndependent.toLowerCase();
            childPathIndependent = childPathIndependent.toLowerCase();
        }
        Object[] parentComponents = parentPathIndependent.split("/");
        Object[] childComponents = childPathIndependent.split("/");
        if (!ArrayUtil.startsWith((Object[])childComponents, (Object[])parentComponents)) {
            return null;
        }
        childComponents = childPath.replace(File.separatorChar, '/').split("/");
        String[] remainder = new String[childComponents.length - parentComponents.length];
        System.arraycopy(childComponents, parentComponents.length, remainder, 0, remainder.length);
        return StringUtil.join((String[])remainder, (String)"/");
    }

    public static boolean isAncestor(String ancestorPath, String path, boolean caseSensitive) {
        return DeploymentPathUtils.getPathRemainder(ancestorPath, path, caseSensitive) != null;
    }

    public static String getParentPath(WebServerConfig.RemotePath path) {
        return DeploymentPathUtils.getParentPath(path.path);
    }

    public static String getParentPath(String path) {
        String pathIndependent = path.replace(File.separatorChar, '/');
        int i = pathIndependent.lastIndexOf(47);
        return i != -1 ? path.substring(0, i) : path;
    }

    public static String getLocalPath(FileObject file) {
        return DeploymentPathUtils.getLocalPath(file.getName());
    }

    public static String getLocalPath(FileName filename) {
        String path = filename.getPath();
        if (SystemInfo.isWindows) {
            path = StringUtil.trimStart((String)filename.getRootURI(), (String)"file:///") + StringUtil.trimStart((String)path, (String)"/");
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    public static String join(@NotNull String head, @NotNull String tail) {
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "join"));
        }
        if (tail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "join"));
        }
        return DeploymentPathUtils.join(head, tail, '/');
    }

    public static String join(@NotNull String head, @NotNull String tail, char separator) {
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "join"));
        }
        if (tail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "join"));
        }
        if (tail.isEmpty()) {
            return head;
        }
        head = head.replace('/', separator).replace('\\', separator);
        tail = tail.replace('/', separator).replace('\\', separator);
        tail = StringUtil.trimEnd((String)tail, (String)String.valueOf(separator));
        if (head.length() > 0 && head.charAt(head.length() - 1) == separator) {
            head = head.substring(0, head.length() - 1);
        }
        if (tail.length() > 0 && tail.charAt(0) == separator) {
            tail = tail.substring(1, tail.length());
        }
        return head + separator + tail;
    }

    public static String joinWebPath(@NonNls @NotNull String serverUrl, @NotNull String path) {
        if (serverUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUrl", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "joinWebPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils", "joinWebPath"));
        }
        if (!serverUrl.contains(":")) {
            serverUrl = "http://" + serverUrl;
        }
        return DeploymentPathUtils.join(serverUrl, path);
    }

    public static FileObject[] getChildren(FileObject file) throws FileSystemException {
        try {
            return file.getChildren();
        }
        catch (FileSystemException e) {
            file.refresh();
            throw e;
        }
        catch (Throwable t) {
            file.refresh();
            LOG.warn(t);
            return NO_CHILDREN;
        }
    }

    private static class DeploymentPathProcessor {
        private final ExecutionContext myContext;
        private final List<TransferOperation> myResult;
        private final boolean myProcessChildMappings;
        private final DeploymentPathChecker myChecker = new DeploymentPathChecker();

        public DeploymentPathProcessor(ExecutionContext context, List<TransferOperation> result, boolean processChildMappings) {
            this.myContext = context;
            this.myResult = result;
            this.myProcessChildMappings = processChildMappings;
        }

        public ErrorsAndExclusions processPath(FileObject source, FileObject target, DeploymentPathMapping mapping) throws FileSystemException {
            this.myChecker.initProcessing();
            boolean targetExists = target.exists();
            return this.process(source, target, targetExists, mapping);
        }

        private ErrorsAndExclusions process(FileObject source, FileObject target, boolean targetExists, DeploymentPathMapping mapping) throws FileSystemException {
            FileObject excludedFile = DeploymentPathUtils.getExcludedFile(this.myContext, source, target);
            if (excludedFile != null) {
                boolean local = this.myContext.isServerSideModification() ? excludedFile == source : excludedFile == target;
                return ErrorsAndExclusions.reportExcluded(excludedFile, local, this.myContext);
            }
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            if (errorsAndExclusions.addAll(this.storeCheckAndReportDuplicatePath(source))) {
                return errorsAndExclusions;
            }
            this.myContext.getProgressIndicator().checkCanceled();
            String sourcePath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath(source) : this.myContext.getServer().getPresentablePath(source);
            this.myContext.getProgressIndicator().setText(WDBundle.message("collecting.files.0", sourcePath));
            if (this.myContext.getConfig().isExcludedByName(sourcePath)) {
                return errorsAndExclusions;
            }
            DeploymentMode mode = this.myContext.getDeploymentMode();
            if (!source.exists()) {
                mode.sourceNotExist(target, this.myContext, this.myResult, true);
            } else if (source.getType() == FileType.FILE) {
                mode.sourceIsFile(source, target, this.myContext, this.myResult);
            } else {
                Pair<DeploymentPathMapping, Boolean> childMapping;
                FileObject[] sourceChildren;
                if ((this.myContext.getConfig().isCreateEmptyDirectories() || this.myContext.getConfig().getFolderPermissions() != -1) && DeploymentPathUtils.getType(target, targetExists) != FileType.FOLDER) {
                    this.myResult.add(new TransferOperation.CreateFolder(target));
                } else if (this.myContext.isServerSideModification() && DeploymentPathUtils.getType(target, targetExists) == FileType.FOLDER && this.myContext.getConfig().getFolderPermissions() != -1) {
                    this.myResult.add(new TransferOperation.ChangePermissions(target));
                }
                for (FileObject sourceChild : sourceChildren = source.getType() == FileType.FOLDER ? DeploymentPathUtils.getChildren(source) : NO_CHILDREN) {
                    String sourceChildPath;
                    String string = sourceChildPath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath(sourceChild) : this.myContext.getServer().getPresentablePath(sourceChild);
                    if (this.myContext.getConfig().isExcludedByName(sourceChildPath)) continue;
                    Pair<DeploymentPathMapping, Boolean> childMappingPair = this.myContext.isServerSideModification() ? this.myContext.getConfig().getNearestMappingForLocal(sourceChild, false, true, false, (Mappable)this.myContext.getServer()) : this.myContext.getConfig().getNearestMappingDeploy2Local(sourceChild, false, (Mappable)this.myContext.getServer());
                    if (childMappingPair.getFirst() == null) {
                        if (Boolean.TRUE != childMappingPair.getSecond()) continue;
                        errorsAndExclusions.addExcludedPath(sourceChild, this.myContext.isServerSideModification(), this.myContext);
                        continue;
                    }
                    childMapping = (Pair<DeploymentPathMapping, Boolean>)childMappingPair.getFirst();
                    if (!this.myProcessChildMappings && childMapping != mapping) continue;
                    FileObject targetChild = this.myContext.isServerSideModification() ? this.myContext.findRemoteFile(childMapping.mapToDeployPath(sourceChild, (Mappable)this.myContext.getServer()), childMapping != mapping || DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY) : childMapping.mapToLocalFile(sourceChild, (Mappable)this.myContext.getServer());
                    FileObject excludedChildFile = DeploymentPathUtils.getExcludedFile(this.myContext, sourceChild, targetChild);
                    if (excludedChildFile != null) {
                        boolean local = this.myContext.isServerSideModification() ? excludedChildFile == sourceChild : excludedChildFile == targetChild;
                        errorsAndExclusions.addExcludedPath(excludedChildFile, local, this.myContext);
                        continue;
                    }
                    try {
                        ErrorsAndExclusions childErrorsAndExclusions = this.process(sourceChild, targetChild, DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY, (DeploymentPathMapping)childMapping);
                        errorsAndExclusions.addAllPaths(childErrorsAndExclusions);
                    }
                    catch (FileSystemException e) {
                        if (PublishUtils.isFatal(e) || this.myContext.getConfig().isStopOnFirstError()) {
                            throw e;
                        }
                        LOG.warn((Throwable)e);
                        errorsAndExclusions.myErrors.add(WDBundle.message("failed.to.process", sourceChildPath, PublishUtils.getMessage(e, false)));
                    }
                }
                if (mode.isDeleteMissingItemsPossible(this.myContext)) {
                    FileObject[] targetChildren;
                    for (FileObject targetChild : targetChildren = DeploymentPathUtils.getType(target, targetExists) == FileType.FOLDER ? DeploymentPathUtils.getChildren(target) : NO_CHILDREN) {
                        FileObject sourceChild;
                        Pair<DeploymentPathMapping, Boolean> childMapping2;
                        if (this.myContext.getConfig().isExcludedByName(this.myContext.isServerSideModification() ? this.myContext.getServer().getPresentablePath(targetChild) : DeploymentPathUtils.getLocalPath(targetChild))) continue;
                        if (this.myContext.isServerSideModification()) {
                            childMapping2 = this.myContext.getConfig().getNearestMappingDeploy2Local(targetChild, false, (Mappable)this.myContext.getServer());
                            if (childMapping2.getFirst() == null && ((Boolean)childMapping2.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(targetChild, false, this.myContext);
                                continue;
                            }
                            if (mapping != childMapping2.getFirst()) {
                                continue;
                            }
                        } else {
                            childMapping2 = this.myContext.getConfig().getNearestMappingForLocal(targetChild, false, true, false, (Mappable)this.myContext.getServer());
                            if (childMapping2.getFirst() == null && ((Boolean)childMapping2.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(targetChild, true, this.myContext);
                                continue;
                            }
                            if (mapping != childMapping2.getFirst()) continue;
                        }
                        if ((sourceChild = this.myContext.isServerSideModification() ? mapping.mapToLocalFile(targetChild, this.myContext.getServer()) : this.myContext.findRemoteFile(mapping.mapToDeployPath(targetChild, (Mappable)this.myContext.getServer()), DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY)).exists()) continue;
                        if (this.myContext.isServerSideModification()) {
                            childMapping = this.myContext.getConfig().getNearestMappingForLocal(sourceChild, false, true, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(sourceChild, true, this.myContext);
                                continue;
                            }
                        } else {
                            childMapping = this.myContext.getConfig().getNearestMappingDeploy2Local(sourceChild, false, (Mappable)this.myContext.getServer());
                            if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                                errorsAndExclusions.addExcludedPath(sourceChild, false, this.myContext);
                                continue;
                            }
                        }
                        if (targetChild.getType() == FileType.FILE) {
                            mode.sourceNotExist(targetChild, this.myContext, this.myResult, false);
                            continue;
                        }
                        Pair<List<DeploymentPathMapping>, Boolean> descendantMappings = this.myContext.isServerSideModification() ? this.myContext.getConfig().getChildMappingsDeploy2Local(targetChild, (Mappable)this.myContext.getServer()) : this.myContext.getConfig().getChildMappingsForLocal(targetChild, true, false, (Mappable)this.myContext.getServer());
                        boolean canDelete = true;
                        for (DeploymentPathMapping descendantMapping : (List)descendantMappings.getFirst()) {
                            FileObject descendant = this.myContext.isServerSideModification() ? this.myContext.findRemoteFile(descendantMapping.getFullDeployPath(this.myContext.getServer()), DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY) : DeploymentPathUtils.getLocalFile(descendantMapping.getLocalPath());
                            if (!descendant.exists()) continue;
                            canDelete = false;
                            break;
                        }
                        if (!canDelete) continue;
                        this.myResult.add(new TransferOperation.Delete(targetChild, targetChild.getType() == FileType.FOLDER, true));
                    }
                }
            }
            return errorsAndExclusions;
        }

        private ErrorsAndExclusions storeCheckAndReportDuplicatePath(@NotNull FileObject source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils$DeploymentPathProcessor", "storeCheckAndReportDuplicatePath"));
            }
            FileObject previousObject = this.myChecker.getAlreadyProcessedFileObject(source);
            if (previousObject != null) {
                String errorMessage = "Skipping duplicate path: " + source.getName().getPath() + " looks like a recursive symlink to " + previousObject.getName().getPath();
                LOG.warn(errorMessage);
                return ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
            }
            return new ErrorsAndExclusions();
        }
    }

    public static class ErrorsAndExclusions {
        private final Collection<String> myErrors = new ArrayList<String>();
        private final Collection<String> myPaths = new HashSet<String>();

        public boolean addAll(ErrorsAndExclusions other) {
            boolean changed = this.myErrors.addAll(other.myErrors);
            return changed |= this.myPaths.addAll(other.myPaths);
        }

        public boolean addExcludedPath(FileObject path, boolean isLocal, ExecutionContext context) {
            return this.myPaths.add(isLocal ? DeploymentPathUtils.getLocalPath(path) : context.getServer().getPresentablePath(path));
        }

        public boolean addExcludedPath(WebServerConfig.RemotePath path, WebServerConfig server) {
            return this.myPaths.add(server.getPresentablePath(path));
        }

        public void addError(String message) {
            this.myErrors.add(message);
        }

        public Collection<String> getReadOnlyErrors() {
            return Collections.unmodifiableCollection(this.myErrors);
        }

        public Collection<String> getReadOnlyPaths() {
            return Collections.unmodifiableCollection(this.myPaths);
        }

        public void addAllPaths(ErrorsAndExclusions childErrorsAndExclusions) {
            this.myPaths.addAll(childErrorsAndExclusions.myPaths);
        }

        public static ErrorsAndExclusions reportErrors(Collection<String> errors) {
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            errorsAndExclusions.myErrors.addAll(errors);
            return errorsAndExclusions;
        }

        public static ErrorsAndExclusions reportExcluded(FileObject excluded, Boolean local, ExecutionContext context) {
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            errorsAndExclusions.addExcludedPath(excluded, local, context);
            return errorsAndExclusions;
        }
    }
}

