/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.LogWrapper;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishUtils {
    private static final Logger LOG = Logger.getInstance(PublishUtils.class);
    private static DefaultFileSystemManager ourFilesystemManager;
    public static boolean DISABLE_FILESYSTEM_CACHE;
    private static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int DEFAULT_HTTP_RESPONSE_TIMEOUT = 20000;

    @Nullable
    public static String testConnection(Deployable server, JComponent parentComponent, String title, boolean checkUrl) throws FileSystemException {
        Ref error = new Ref();
        Ref homePath = new Ref();
        Runnable runnable = () -> {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            LOG.assertTrue(server.validateFastInternal(false) == null);
            try {
                pi.setText(WDBundle.message("validating.server", new Object[0]));
                String e = server.validateInternalSlow(-1L, false);
                if (e != null) {
                    error.set((Object)new CustomFileSystemException(e));
                    return;
                }
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
            }
            Semaphore done = new Semaphore();
            done.down();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(RemoteConnectionManager.ForceDisconnectListener.class);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    if (server.getAccessType().isProtocolBased()) {
                        pi.setText(WDBundle.message("connecting.by.0", server.getAccessType().getTitle()));
                        RemoteConnection connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwner(parentComponent), title, server, FileTransferConfig.Origin.Unchanged, (EventDispatcher<RemoteConnectionManager.ForceDisconnectListener>)forceDisconnectDispatcher, pi);
                        try {
                            connection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> homePath.set((Object)connection.resolveRoot().getCurrentDir())), pi);
                        }
                        finally {
                            connection.release();
                        }
                    }
                    if (checkUrl) {
                        PublishUtils.doCheckUrl(server, "", pi);
                    }
                }
                catch (FileSystemException e) {
                    error.set((Object)e);
                }
                finally {
                    done.up();
                }
            });
            while (!done.waitFor(100L)) {
                if (!pi.isCanceled()) continue;
                ((RemoteConnectionManager.ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                break;
            }
        };
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, parentComponent);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        if (!error.isNull()) {
            throw (FileSystemException)((Object)error.get());
        }
        return (String)homePath.get();
    }

    public static void doCheckUrl(Deployable server, String webPath, ProgressIndicator pi) throws FileSystemException {
        pi.setText(WDBundle.message("connecting.by.0", server.getUrl().startsWith("https:") ? "HTTPS" : "HTTP"));
        FileObject httpFile = PublishUtils.openUrl(DeploymentPathUtils.joinWebPath(server.getUrl(), webPath));
        if (httpFile.getType() != FileType.FILE) {
            throw new CustomFileSystemException(WDBundle.message("page.not.found", new Object[0]));
        }
    }

    public static String getMessage(Throwable throwable, boolean full) {
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof FTPConnectionClosedException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof FileSystemException && "vfs.provider/set-permissions.error".equals(((FileSystemException)throwable).getCode()) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String reason = throwable.getMessage();
        if (throwable.getCause() != throwable && (throwable.getCause() instanceof SftpException || throwable.getCause() instanceof JSchException || throwable.getCause() instanceof ConnectException || throwable.getCause() instanceof UnknownHostException)) {
            if (throwable.getCause().getCause() != null) {
                reason = PublishUtils.getNetworkExceptionMessage(throwable.getCause().getCause());
            }
            if (reason == null || throwable.getCause().getCause() == null) {
                reason = PublishUtils.getNetworkExceptionMessage(throwable.getCause());
            }
            if (reason == null) {
                reason = throwable.getMessage();
            }
        }
        if (reason == null) {
            reason = WDBundle.message("unknown.reason", new Object[0]);
        }
        if (full) {
            if (!reason.equals(throwable.getMessage())) {
                return MessageFormat.format("{0} ({1})", throwable.getMessage(), reason);
            }
            return throwable.getMessage().replace("\n", "").replace("\r", "");
        }
        return reason.replace("\n", "").replace("\r", "");
    }

    private static String getNetworkExceptionMessage(Throwable t) {
        if (t instanceof UnknownHostException) {
            return WDBundle.message("host.not.found", new Object[0]);
        }
        return t.getMessage();
    }

    public static boolean isFatal(Throwable t) {
        while (t instanceof FileSystemException) {
            String code = ((FileSystemException)t).getCode();
            if (code != null && code.contains("connect.error")) {
                return true;
            }
            if (t.getCause() == t) break;
            t = t.getCause();
        }
        return false;
    }

    public static synchronized FileSystemManager getManager() {
        if (ourFilesystemManager == null) {
            ourFilesystemManager = new StandardFileSystemManager(){

                public void init() throws FileSystemException {
                    this.setConfiguration(PublishUtils.class.getResource("commons-vfs-providers.xml"));
                    this.setCacheStrategy(DISABLE_FILESYSTEM_CACHE ? CacheStrategy.ON_RESOLVE : CacheStrategy.MANUAL);
                    this.setFilesCache((FilesCache)new SoftRefFilesCache(){

                        protected boolean shouldCloseFilesystemOnClear(Map files) {
                            return false;
                        }
                    });
                    super.init();
                }
            };
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

                public void dispose() {
                    ourFilesystemManager = null;
                }
            });
            try {
                ClassLoaderUtil.runWithClassLoader((ClassLoader)PublishUtils.class.getClassLoader(), () -> ourFilesystemManager.init());
            }
            catch (FileSystemException e) {
                LOG.error("Failed to initialize filesystem manager", (Throwable)e);
                return null;
            }
            ourFilesystemManager.setLogger((Log)new LogWrapper(LOG));
        }
        return ourFilesystemManager;
    }

    private static FileSystemOptions createHttpOptions(String key, int timeout) {
        FileSystemOptions options = new FileSystemOptions();
        ((WebdavFileSystemConfigBuilder)WebdavFileSystemConfigBuilder.getInstance()).setCreatorName(options, key);
        HttpFileSystemConfigBuilder.getInstance().setSoTimeout(options, timeout);
        return options;
    }

    public static boolean isProcessCanceledException(FileSystemException e) {
        return e.getCause() instanceof ProcessCanceledException;
    }

    public static FileObject openUrl(String url) throws FileSystemException {
        return PublishUtils.openUrl(url, 20000);
    }

    public static FileObject openUrl(String url, int timeout) throws FileSystemException {
        return PublishUtils.getManager().resolveFile(url, PublishUtils.createHttpOptions(url, timeout));
    }

    public static String fetchUrl(String url) throws IOException {
        FileObject httpFile;
        try {
            httpFile = PublishUtils.openUrl(url);
            if (httpFile.getType() != FileType.FILE) {
                throw new IOException(WDBundle.message("autodetect.error.404", url));
            }
            FileContentInfo info = httpFile.getContent().getContentInfo();
            LOG.debug("content type: " + info.getContentType() + ", encoding: " + info.getContentEncoding());
            if (!"text/html".equals(info.getContentType())) {
                throw new IOException(WDBundle.message("autodetect.invalid.content.type", info.getContentType()));
            }
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PublishUtils.getMessage(e, false));
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(httpFile.getContent().getInputStream()));
            StringBuilder result = new StringBuilder();
            result.append(StreamUtil.readTextFrom((Reader)reader));
            LOG.debug("fetch result: [" + result + "]");
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PublishUtils.getMessage(e, true));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isAuthFail(Throwable throwable) {
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof JSchException && "Auth fail".equals(throwable.getCause().getMessage())) {
            return true;
        }
        return throwable instanceof FileSystemException && "vfs.provider.ftp/login.error".equals(((FileSystemException)throwable).getCode());
    }

    public static FileObject findFile(@NotNull FileSystem fs, @NotNull WebServerConfig.RemotePath remotePath, @NotNull Connectable connectable) throws FileSystemException {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/jetbrains/plugins/webDeployment/PublishUtils", "findFile"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/jetbrains/plugins/webDeployment/PublishUtils", "findFile"));
        }
        if (connectable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectable", "com/jetbrains/plugins/webDeployment/PublishUtils", "findFile"));
        }
        if (connectable.getAccessType().isProtocolBased()) {
            return fs.resolveFile(remotePath.path);
        }
        String path = remotePath.path;
        if (SystemInfo.isWindows) {
            String drive = remotePath.path.substring(0, 2);
            path = path.substring(3, path.length());
            String rootUri = fs.getRootURI();
            LOG.assertTrue(drive.equals(rootUri.substring(8, 10)));
        }
        return fs.resolveFile(path);
    }

    @NotNull
    public static Function<MergeResult, String> getMergeResolveCaptions() {
        Function function = result -> {
            switch (result) {
                case CANCEL: {
                    return null;
                }
                case LEFT: {
                    return WDBundle.message("merge.on.upload.left.button", new Object[0]);
                }
                case RIGHT: {
                    return WDBundle.message("merge.on.upload.right.button", new Object[0]);
                }
                case RESOLVED: {
                    return WDBundle.message("merge.on.upload.ok.button", new Object[0]);
                }
            }
            throw new IllegalStateException(result.name());
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/PublishUtils", "getMergeResolveCaptions"));
        }
        return function;
    }

    public static boolean needsTransfer(@NotNull AccessType accessType) {
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/jetbrains/plugins/webDeployment/PublishUtils", "needsTransfer"));
        }
        return accessType != AccessType.LOCAL;
    }

    public static String formatSize(float size, String bKey, String kbKey, String mbKey) {
        if (size < 1000.0f) {
            return WDBundle.message(bKey, Float.valueOf(size));
        }
        if (size < 1000000.0f) {
            return WDBundle.message(kbKey, Float.valueOf(size / 1000.0f));
        }
        return WDBundle.message(mbKey, Float.valueOf(size / 1000.0f / 1000.0f));
    }

    static {
        DISABLE_FILESYSTEM_CACHE = Boolean.getBoolean("com.jetbrains.plugins.webDeployment.noCache");
    }

    public static class RefreshingLocalFileProvider
    extends DefaultLocalFileProvider {
        protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
            LocalFileName rootName = (LocalFileName)name;
            return new LocalFileSystem((FileName)rootName, rootName.getRootFile(), fileSystemOptions){

                public synchronized FileObject resolveFile(FileName name) throws FileSystemException {
                    FileObject file = super.resolveFile(name);
                    if (!DISABLE_FILESYSTEM_CACHE && file != null) {
                        file.refresh();
                    }
                    return file;
                }
            };
        }
    }
}

