/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport.channels;

import com.google.common.net.HostAndPort;
import com.intellij.util.ArrayUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0014H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0014\u0010 \u001a\u00020!8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/channels/SshChannelImpl;", "C", "Lcom/jcraft/jsch/Channel;", "Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "sshSession", "Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "channel", "_inputStream", "Ljava/io/InputStream;", "_outputStream", "Ljava/io/OutputStream;", "(Lcom/jetbrains/plugins/webDeployment/transport/SshSession;Lcom/jcraft/jsch/Channel;Ljava/io/InputStream;Ljava/io/OutputStream;)V", "get_inputStream", "()Ljava/io/InputStream;", "get_outputStream", "()Ljava/io/OutputStream;", "getChannel", "()Lcom/jcraft/jsch/Channel;", "Lcom/jcraft/jsch/Channel;", "exitStatus", "", "getExitStatus", "()I", "inputStream", "getInputStream", "isClosed", "", "()Z", "isConnected", "isRunning", "outputStream", "getOutputStream", "session", "Lcom/jcraft/jsch/Session;", "getSession", "()Lcom/jcraft/jsch/Session;", "getSshSession", "()Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "disconnect", "", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "webDeployment"})
public abstract class SshChannelImpl<C extends Channel>
implements SshChannel {
    @NotNull
    private final SshSession sshSession;
    @NotNull
    private final C channel;
    @Nullable
    private final InputStream _inputStream;
    @Nullable
    private final OutputStream _outputStream;

    @NotNull
    protected final Session getSession() {
        return this.getSshSession().getRawSession();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this._inputStream;
        if (inputStream == null) {
            InputStream inputStream2 = this.channel.getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"channel.inputStream");
        }
        return inputStream;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this._outputStream;
        if (outputStream == null) {
            OutputStream outputStream2 = this.channel.getOutputStream();
            outputStream = outputStream2;
            Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"channel.outputStream");
        }
        return outputStream;
    }

    private final boolean isRunning() {
        return this.channel.getExitStatus() < 0 && this.channel.isConnected();
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public int getExitStatus() {
        return this.channel.getExitStatus();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        String[] portForwardingL = ArrayUtil.EMPTY_STRING_ARRAY;
        try {
            portForwardingL = this.getSession().getPortForwardingL();
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
        for (int i = 0; i < portForwardingL.length; ++i) {
            String portForwarding = portForwardingL[i];
            int first = StringsKt.indexOf$default((CharSequence)portForwarding, (char)':', (int)0, (boolean)false, (int)6, null);
            int last = StringsKt.lastIndexOf$default((CharSequence)portForwarding, (char)':', (int)0, (boolean)false, (int)6, null);
            if (first == -1 || first == last) continue;
            try {
                String host;
                String string = portForwarding;
                int n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, first);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int localPort = Integer.parseInt(string3);
                String string4 = portForwarding;
                int n2 = first + 1;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n2, last), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string6 = portForwarding;
                int n3 = last + 1;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                int hostPort = Integer.parseInt(string8);
                if (!Intrinsics.areEqual((Object)host, (Object)this.getSession().getHost()) || hostPort != remotePort) continue;
                return HostAndPort.fromParts((String)"127.0.0.1", (int)localPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SshSession getSshSession() {
        return this.sshSession;
    }

    @NotNull
    public final C getChannel() {
        return this.channel;
    }

    @Nullable
    public final InputStream get_inputStream() {
        return this._inputStream;
    }

    @Nullable
    public final OutputStream get_outputStream() {
        return this._outputStream;
    }

    public SshChannelImpl(@NotNull SshSession sshSession, @NotNull C channel, @Nullable InputStream _inputStream, @Nullable OutputStream _outputStream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sshSession, (String)"sshSession");
        Intrinsics.checkParameterIsNotNull(channel, (String)"channel");
        this.sshSession = sshSession;
        this.channel = channel;
        this._inputStream = _inputStream;
        this._outputStream = _outputStream;
    }

    public /* synthetic */ SshChannelImpl(SshSession sshSession, Channel channel, InputStream inputStream, OutputStream outputStream, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 4) != 0) {
            inputStream = null;
        }
        if ((n & 8) != 0) {
            outputStream = null;
        }
        this(sshSession, channel, inputStream, outputStream);
    }
}

