/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Graphics;
import java.io.File;
import org.lobobrowser.html.control.BaseControl;
import org.lobobrowser.html.dombl.InputContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlLength;

public abstract class BaseInputControl
extends BaseControl
implements InputContext {
    private static final long serialVersionUID = 1L;
    protected String value;
    protected int size = -1;

    public BaseInputControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setOpaque(false);
        String sizeText = this.controlElement.getAttribute("size");
        if (sizeText != null) {
            this.setControlSize(new HtmlLength(sizeText).getLength(0));
        }
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        String sizeText = this.controlElement.getAttribute("size");
        if (sizeText != null) {
            try {
                this.size = Integer.parseInt(sizeText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getVAlign() {
        return 4;
    }

    @Override
    public void blur() {
    }

    @Override
    public void click() {
    }

    @Override
    public void focus() {
        this.requestFocus();
    }

    @Override
    public boolean getChecked() {
        return false;
    }

    @Override
    public boolean getDisabled() {
        return !this.isEnabled();
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public boolean getReadOnly() {
        return false;
    }

    @Override
    public int getTabIndex() {
        return 0;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String[] getValues() {
        return null;
    }

    @Override
    public void select() {
    }

    @Override
    public void setChecked(boolean checked) {
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.setEnabled(!disabled);
    }

    @Override
    public void setMaxLength(int maxLength) {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public void setControlSize(int size) {
        this.size = size;
        this.invalidate();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int getControlSize() {
        return this.size;
    }

    @Override
    public int getCols() {
        return 0;
    }

    @Override
    public int getRows() {
        return 0;
    }

    @Override
    public void setCols(int cols) {
    }

    @Override
    public void setRows(int rows) {
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    public boolean getMultiple() {
        return false;
    }

    @Override
    public int getSelectedIndex() {
        return -1;
    }

    @Override
    public int getVisibleSize() {
        return 0;
    }

    public void setMultiple(boolean value) {
    }

    @Override
    public void setSelectedIndex(int value) {
    }

    @Override
    public void setVisibleSize(int value) {
    }

    @Override
    public File[] getFileValue() {
        return null;
    }
}

