/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.AbstractAction;
import org.lobobrowser.primary.action.EnableableAction;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.RequestType;

public class UrlPrefixNavigateAction
extends AbstractAction
implements EnableableAction {
    private static final long serialVersionUID = 1L;
    private String urlPrefix;
    private boolean urlEncode;
    private ComponentSource componentSource;
    private NavigatorWindow window;
    private ActionPool action;

    public UrlPrefixNavigateAction(ComponentSource componentSource, NavigatorWindow window, ActionPool action) {
        this.action = action;
        this.window = window;
        this.componentSource = componentSource;
    }

    @Override
    public void updateEnabling() {
        NavigationEntry entry = this.window.getCurrentNavigationEntry();
        this.action.setEnabled(entry != null && !entry.getUrl().toExternalForm().startsWith(this.urlPrefix));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NavigationEntry entry = this.window.getCurrentNavigationEntry();
        if (entry == null) {
            return;
        }
        try {
            String roughLocation = this.urlPrefix + (this.urlEncode ? URLEncoder.encode(entry.getUrl().toExternalForm(), "UTF-8") : entry.getUrl().toExternalForm());
            this.componentSource.navigate(roughLocation, RequestType.PROGRAMMATIC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setUrlEncode(boolean urlEncode) {
        this.urlEncode = urlEncode;
    }
}

