/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettingsForm;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownPreviewConfigurable
implements SearchableConfigurable {
    @Nullable
    private MarkdownPreviewSettingsForm myForm;
    @NotNull
    private MarkdownApplicationSettings myMarkdownApplicationSettings;

    public MarkdownPreviewConfigurable(@NotNull MarkdownApplicationSettings markdownApplicationSettings) {
        if (markdownApplicationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markdownApplicationSettings", "org/intellij/plugins/markdown/settings/MarkdownPreviewConfigurable", "<init>"));
        }
        this.myForm = null;
        this.myMarkdownApplicationSettings = markdownApplicationSettings;
    }

    @NotNull
    public String getId() {
        if ("Settings.Markdown.Preview" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownPreviewConfigurable", "getId"));
        }
        return "Settings.Markdown.Preview";
    }

    @Nls
    public String getDisplayName() {
        return MarkdownBundle.message("settings.markdown.preview.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.getForm().getComponent();
    }

    public boolean isModified() {
        return !this.getForm().getMarkdownPreviewSettings().equals(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
    }

    public void apply() throws ConfigurationException {
        this.myMarkdownApplicationSettings.setMarkdownPreviewSettings(this.getForm().getMarkdownPreviewSettings());
    }

    public void reset() {
        this.getForm().setMarkdownPreviewSettings(this.myMarkdownApplicationSettings.getMarkdownPreviewSettings());
    }

    public void disposeUIResources() {
        this.myForm = null;
    }

    @NotNull
    public MarkdownPreviewSettingsForm getForm() {
        if (this.myForm == null) {
            this.myForm = new MarkdownPreviewSettingsForm();
        }
        MarkdownPreviewSettingsForm markdownPreviewSettingsForm = this.myForm;
        if (markdownPreviewSettingsForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownPreviewConfigurable", "getForm"));
        }
        return markdownPreviewSettingsForm;
    }
}

