/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.diagram.actions.CreateDependencyEdgeType;
import com.intellij.cdi.diagram.edges.CdiDiagramEdge;
import com.intellij.cdi.diagram.edges.CdiInjectionPointEdge;
import com.intellij.cdi.diagram.edges.CdiProducerEdge;
import com.intellij.cdi.diagram.managers.CdiDiagramCategoryManager;
import com.intellij.cdi.diagram.nodes.CdiDiagramNode;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDiagramDataModel
extends DiagramDataModel<CdiBeanDescriptor> {
    private CdiBeanDescriptor myElement;
    private final Collection<DiagramNode<CdiBeanDescriptor>> myNodes = new HashSet<DiagramNode<CdiBeanDescriptor>>();
    private final Collection<DiagramEdge<CdiBeanDescriptor>> myEdges = new HashSet<DiagramEdge<CdiBeanDescriptor>>();
    private final Collection<CdiBeanDescriptor> myRemovedNodes = new HashSet<CdiBeanDescriptor>();
    private final Collection<CdiBeanDescriptor> myAddedNodes = new HashSet<CdiBeanDescriptor>();

    public CdiDiagramDataModel(Project project, DiagramProvider<CdiBeanDescriptor> diagramProvider, VirtualFile file, CdiBeanDescriptor element) {
        super(project, diagramProvider);
        this.myElement = element;
    }

    @NotNull
    public Collection<DiagramNode<CdiBeanDescriptor>> getNodes() {
        Collection<DiagramNode<CdiBeanDescriptor>> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/CdiDiagramDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<CdiBeanDescriptor>> getEdges() {
        Collection<DiagramEdge<CdiBeanDescriptor>> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/CdiDiagramDataModel", "getEdges"));
        }
        return collection;
    }

    public DiagramEdge<CdiBeanDescriptor> createEdge(@NotNull DiagramNode<CdiBeanDescriptor> from, @NotNull DiagramNode<CdiBeanDescriptor> to) {
        boolean isProducable;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createEdge"));
        }
        CdiBeanDescriptor fromDescriptor = (CdiBeanDescriptor)from.getIdentifyingElement();
        CdiBeanDescriptor toDescriptor = (CdiBeanDescriptor)to.getIdentifyingElement();
        for (DiagramEdge<CdiBeanDescriptor> edge : this.myEdges) {
            if (!edge.getSource().equals(from) || !edge.getTarget().equals(to)) continue;
            return null;
        }
        boolean isInjectable = toDescriptor instanceof CdiBeanPsiClassDescriptor && !(toDescriptor.getIdentifyingElement() instanceof PsiCompiledElement);
        boolean bl = isProducable = fromDescriptor instanceof CdiBeanPsiClassDescriptor && !(fromDescriptor.getIdentifyingElement() instanceof PsiCompiledElement);
        if (isInjectable || isProducable) {
            LinkedHashSet<CreateDependencyEdgeType> types = new LinkedHashSet<CreateDependencyEdgeType>();
            if (isInjectable) {
                types.add(CreateDependencyEdgeType.INJECT_FIELD);
                types.add(CreateDependencyEdgeType.INJECT_METHOD);
            }
            if (isProducable) {
                types.add(CreateDependencyEdgeType.PRODUCE_FIELD);
                types.add(CreateDependencyEdgeType.PRODUCE_METHOD);
            }
            if (types.size() > 0) {
                Callable<CdiDiagramEdge> callable = () -> {
                    if (from == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/cdi/diagram/CdiDiagramDataModel", "lambda$createEdge$1"));
                    }
                    if (to == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/cdi/diagram/CdiDiagramDataModel", "lambda$createEdge$1"));
                    }
                    String[] names = (String[])ContainerUtil.map2Array((Collection)types, String.class, type -> type.getName());
                    int i = Messages.showChooseDialog((String)CdiBundle.message("diagram.choose.dependency.type.message", new Object[0]), (String)CdiBundle.message("diagram.choose.dependency.type.title", new Object[0]), (String[])names, (String)names[0], null);
                    if (i >= 0) {
                        CdiDiagramEdge edge = null;
                        block6: for (CreateDependencyEdgeType edgeType : CreateDependencyEdgeType.values()) {
                            if (!edgeType.getName().equals(names[i])) continue;
                            switch (edgeType) {
                                case INJECT_FIELD: {
                                    edge = CdiDiagramDataModel.createInjectedEdge(from, to, false);
                                    continue block6;
                                }
                                case INJECT_METHOD: {
                                    edge = CdiDiagramDataModel.createInjectedEdge(from, to, true);
                                    continue block6;
                                }
                                case PRODUCE_FIELD: {
                                    edge = CdiDiagramDataModel.createProducesEdge(from, to, false);
                                    continue block6;
                                }
                                case PRODUCE_METHOD: {
                                    edge = CdiDiagramDataModel.createProducesEdge(from, to, true);
                                }
                            }
                        }
                        if (edge != null) {
                            this.myEdges.add((DiagramEdge<CdiBeanDescriptor>)edge);
                            return edge;
                        }
                    }
                    return null;
                };
                return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)"CDI Dependencies", null, (PsiElement[])new PsiElement[0]);
            }
        }
        return super.createEdge(from, to);
    }

    @Nullable
    private static CdiInjectionPointEdge createInjectedEdge(DiagramNode<CdiBeanDescriptor> from, DiagramNode<CdiBeanDescriptor> to, boolean isMethod) {
        VirtualFile file;
        PsiClass toClass;
        PsiType fromType = ((CdiBeanDescriptor)from.getIdentifyingElement()).getType();
        PsiType toType = ((CdiBeanDescriptor)to.getIdentifyingElement()).getType();
        if (fromType != null && toType instanceof PsiClassType && (toClass = ((PsiClassType)toType).resolve()) != null && (file = toClass.getContainingFile().getVirtualFile()) != null && !ReadonlyStatusHandler.getInstance((Project)toClass.getProject()).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)toClass.getProject()).getElementFactory();
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)toClass.getProject());
            PsiMethod psiMember = isMethod ? CdiDiagramDataModel.createInjectedMethod(toClass, fromType, elementFactory, styleManager) : CdiDiagramDataModel.createInjectedField(toClass, fromType, elementFactory, styleManager);
            return new CdiInjectionPointEdge(from, to, new InjectionPointDescriptor((PsiModifierListOwner)psiMember), isMethod);
        }
        return null;
    }

    private static CdiProducerEdge createProducesEdge(DiagramNode<CdiBeanDescriptor> from, DiagramNode<CdiBeanDescriptor> to, boolean isMethod) {
        PsiClass fromClass;
        PsiType fromType = ((CdiBeanDescriptor)from.getIdentifyingElement()).getType();
        PsiType toType = ((CdiBeanDescriptor)to.getIdentifyingElement()).getType();
        if (toType != null && fromType instanceof PsiClassType && (fromClass = ((PsiClassType)fromType).resolve()) != null) {
            VirtualFile file = fromClass.getContainingFile().getVirtualFile();
            Project project = fromClass.getProject();
            if (file != null && !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                PsiMember psiMember = isMethod ? CdiDiagramDataModel.createProducesMethod(fromClass, toType, elementFactory, styleManager) : CdiDiagramDataModel.createProducesField(fromClass, toType, elementFactory, styleManager);
                return new CdiProducerEdge(from, to, psiMember);
            }
        }
        return null;
    }

    private static PsiMember createProducesMethod(PsiClass containingClass, PsiType type, PsiElementFactory elementFactory, JavaCodeStyleManager manager) {
        String paramName = manager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
        String methodName = "create" + StringUtil.capitalize((String)paramName);
        int i = 1;
        while (containingClass.findMethodsByName(paramName, true).length != 0) {
            methodName = methodName + i++;
        }
        String methodText = "public " + type.getCanonicalText() + " " + methodName + "() {return null;}";
        PsiMethod psiMethod = elementFactory.createMethodFromText(methodText, (PsiElement)containingClass);
        PsiMethod newMethod = (PsiMethod)containingClass.add((PsiElement)psiMethod);
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("public", true);
        modifierList.addAnnotation("javax.enterprise.inject.Produces");
        return psiMethod;
    }

    private static PsiField createInjectedField(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedField"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedField"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedField"));
        }
        if (styleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleManager", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedField"));
        }
        return CdiDiagramDataModel.createAnnotatedField(containingClass, type, elementFactory, styleManager, "javax.inject.Inject");
    }

    private static PsiField createProducesField(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createProducesField"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createProducesField"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createProducesField"));
        }
        if (styleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleManager", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createProducesField"));
        }
        return CdiDiagramDataModel.createAnnotatedField(containingClass, type, elementFactory, styleManager, "javax.enterprise.inject.Produces");
    }

    private static PsiField createAnnotatedField(PsiClass containingClass, PsiType type, PsiElementFactory elementFactory, JavaCodeStyleManager styleManager, String annotation) {
        String name = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, null, null, (PsiType)type).names[0];
        int i = 1;
        while (containingClass.findFieldByName(name, true) != null) {
            name = name + i++;
        }
        PsiField psiField = elementFactory.createField(name, type);
        PsiField newField = (PsiField)containingClass.add((PsiElement)psiField);
        PsiModifierList list = newField.getModifierList();
        if (list != null) {
            list.setModifierProperty("private", true);
            list.addAnnotation(annotation);
        }
        return psiField;
    }

    private static PsiMethod createInjectedMethod(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedMethod"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedMethod"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedMethod"));
        }
        if (styleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleManager", "com/intellij/cdi/diagram/CdiDiagramDataModel", "createInjectedMethod"));
        }
        String paramName = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
        String methodName = "set" + StringUtil.capitalize((String)paramName);
        int i = 1;
        while (containingClass.findMethodsByName(paramName, true).length != 0) {
            methodName = methodName + i++;
        }
        PsiMethod psiMethod = elementFactory.createMethod(methodName, (PsiType)PsiType.VOID);
        PsiMethod newMethod = (PsiMethod)containingClass.add((PsiElement)psiMethod);
        newMethod.getParameterList().add((PsiElement)elementFactory.createParameter(paramName, type));
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("public", true);
        modifierList.addAnnotation("javax.inject.Inject");
        return psiMethod;
    }

    @NotNull
    public String getNodeName(DiagramNode<CdiBeanDescriptor> n) {
        String name = n.getTooltip();
        String string = StringUtil.isEmptyOrSpaces((String)name) ? "Unknown" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/CdiDiagramDataModel", "getNodeName"));
        }
        return string;
    }

    public DiagramNode<CdiBeanDescriptor> addElement(CdiBeanDescriptor element) {
        CdiDiagramNode node;
        if (element != null) {
            this.myAddedNodes.add(element);
            this.myRemovedNodes.remove(element);
        }
        return this.myNodes.contains((Object)(node = new CdiDiagramNode(element, (DiagramProvider<CdiBeanDescriptor>)this.getProvider()))) ? null : node;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/diagram/CdiDiagramDataModel", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    public void updateDataModel() {
        CdiDiagramNode classNode = new CdiDiagramNode(this.myElement, (DiagramProvider<CdiBeanDescriptor>)this.getProvider());
        MultiMap map = new MultiMap();
        Module module = ModuleUtilCore.findModuleForPsiElement(this.myElement.getIdentifyingElement());
        if (module != null) {
            this.addNodeAndDependencies(classNode, (MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>>)map, new DiagramState(this.getBuilder()), module);
            for (CdiBeanDescriptor addedNodeDescriptor : this.myAddedNodes) {
                CdiDiagramNode addedNode = new CdiDiagramNode(addedNodeDescriptor, (DiagramProvider<CdiBeanDescriptor>)this.getProvider());
                this.addNodeAndDependencies(addedNode, (MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>>)map, new DiagramState(this.getBuilder()), module);
            }
            this.myEdges.addAll(map.values());
        }
    }

    private void addNodeAndDependencies(@NotNull CdiDiagramNode classNode, @NotNull MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, @NotNull DiagramState diagramState, @NotNull Module module) {
        if (classNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNode", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNodeAndDependencies"));
        }
        if (edges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edges", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNodeAndDependencies"));
        }
        if (diagramState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagramState", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNodeAndDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNodeAndDependencies"));
        }
        if (this.myNodes.contains((Object)classNode)) {
            return;
        }
        if (this.myRemovedNodes.contains(classNode.getIdentifyingElement())) {
            return;
        }
        this.myNodes.add((DiagramNode<CdiBeanDescriptor>)classNode);
        CdiBeanDescriptor beanDescriptor = classNode.getIdentifyingElement();
        if (beanDescriptor instanceof CdiBeanPsiClassDescriptor) {
            PsiClass psiClass = ((CdiBeanPsiClassDescriptor)beanDescriptor).getAnnotatedItem();
            if (diagramState.isCategoryEnabled(CdiDiagramCategoryManager.INJECTION_POINTS)) {
                this.addInjectedNodes(module, classNode, psiClass, edges, diagramState);
                this.addOutjectedNodes(module, classNode, psiClass, edges, diagramState);
            }
            if (diagramState.isCategoryEnabled(CdiDiagramCategoryManager.PRODUCERS)) {
                this.addProduces(psiClass, classNode, module, edges, diagramState);
                this.addFactories(module, psiClass, classNode, edges, diagramState);
            }
        }
    }

    private void addFactories(Module module, PsiClass psiClass, CdiDiagramNode targetNode, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState) {
        PsiClassType type = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
        List<PsiMember> producers = CdiCommonUtils.getPsiTypeProducers(module, (PsiType)type);
        for (PsiMember producer : producers) {
            PsiClass containingClass = producer.getContainingClass();
            CdiDiagramNode sourceNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(containingClass), module);
            if (sourceNode == null) continue;
            this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)producer, (DiagramEdge<CdiBeanDescriptor>)new CdiProducerEdge((DiagramNode<CdiBeanDescriptor>)sourceNode, (DiagramNode<CdiBeanDescriptor>)targetNode, producer));
        }
    }

    private static void addNewEdge(@NotNull MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, @NotNull PsiElement owner, @NotNull DiagramEdge<CdiBeanDescriptor> edge) {
        if (edges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edges", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNewEdge"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNewEdge"));
        }
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addNewEdge"));
        }
        Collection edgeCollection = edges.get((Object)owner);
        for (DiagramEdge existingEdge : edgeCollection) {
            if (!existingEdge.equals(edge)) continue;
            return;
        }
        edges.putValue((Object)owner, edge);
    }

    private void addProduces(@NotNull PsiClass psiClass, @NotNull CdiDiagramNode sourceNode, Module module, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addProduces"));
        }
        if (sourceNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addProduces"));
        }
        for (PsiField psiField : CdiCommonUtils.getProducerFields(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiField, module, edges, diagramState);
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiMethod, module, edges, diagramState);
        }
    }

    private void addProducesNode(CdiDiagramNode sourceNode, PsiMember psiMember, Module module, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState) {
        ProducerBeanDescriptor<? extends PsiMember> producerDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember);
        assert (producerDescriptor != null);
        CdiDiagramNode targetNode = this.createNode(producerDescriptor, module);
        if (targetNode != null) {
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)psiMember, (DiagramEdge<CdiBeanDescriptor>)new CdiProducerEdge((DiagramNode<CdiBeanDescriptor>)sourceNode, (DiagramNode<CdiBeanDescriptor>)targetNode, psiMember));
        }
    }

    @Nullable
    private CdiDiagramNode createNode(CdiBeanDescriptor descriptor, Module module) {
        PsiClass originalPsiClass;
        PsiType type;
        if (this.myRemovedNodes.contains(descriptor)) {
            return null;
        }
        if (descriptor instanceof CdiBeanPsiClassDescriptor) {
            return new CdiDiagramNode(descriptor, (DiagramProvider<CdiBeanDescriptor>)this.getProvider());
        }
        if (descriptor instanceof ProducerBeanDescriptor && !CdiDiagramDataModel.isPsiClassTypeWithGenerics(type = descriptor.getType()) && (originalPsiClass = CdiCommonUtils.getOriginalPsiClass(descriptor.getType(), module)) != null) {
            CdiBeanPsiClassDescriptor cdiBeanDescriptor = CdiDescriptorsFactory.createCdiBeanDescriptor(originalPsiClass);
            return this.myRemovedNodes.contains(cdiBeanDescriptor) ? null : new CdiDiagramNode(cdiBeanDescriptor, (DiagramProvider<CdiBeanDescriptor>)this.getProvider());
        }
        return new CdiDiagramNode(descriptor, (DiagramProvider<CdiBeanDescriptor>)this.getProvider());
    }

    private void addOutjectedNodes(Module module, CdiDiagramNode sourceNode, PsiClass psiClass, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState) {
        if (CdiCommonUtils.isDecorator(psiClass)) {
            return;
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(psiClass);
        Set<InjectionPointDescriptor> allInjectionPoints = CdiInjectionUtils.getInjectionPoints(module);
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints((PsiType)psiClassType, allInjectionPoints);
        for (InjectionPointDescriptor ip : injectionPoints) {
            CdiDiagramNode targetNode;
            PsiModifierListOwner owner = ip.getOwner();
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class);
            if (containingClass == null || CdiCommonUtils.isDecorator(containingClass) && !diagramState.isCategoryEnabled(CdiDiagramCategoryManager.DECORATORS) || (targetNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(containingClass), module)) == null) continue;
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, (DiagramEdge<CdiBeanDescriptor>)new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor>)sourceNode, (DiagramNode<CdiBeanDescriptor>)targetNode, ip, false));
        }
    }

    private void addInjectedNodes(@NotNull Module module, @NotNull CdiDiagramNode targetNode, @NotNull PsiClass psiClass, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addInjectedNodes"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addInjectedNodes"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/diagram/CdiDiagramDataModel", "addInjectedNodes"));
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
        for (InjectionPointDescriptor ip : injectionPoints) {
            if ("javax.enterprise.inject.spi.InjectionPoint".equals(ip.getType().getCanonicalText()) && ip.getQualifierAnnotations().length == 0) continue;
            Set<CdiBeanDescriptor> beanDescriptors = CdiInjectionUtils.getInjectedBeans(ip);
            if (beanDescriptors.size() > 0) {
                for (CdiBeanDescriptor beanDescriptor : beanDescriptors) {
                    CdiDiagramNode sourceNode;
                    Object identifyingElement = beanDescriptor.getIdentifyingElement();
                    if (identifyingElement instanceof PsiClass && CdiCommonUtils.isDecorator((PsiClass)identifyingElement) || (sourceNode = this.createNode(beanDescriptor, module)) == null) continue;
                    this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
                    PsiModifierListOwner owner = ip.getOwner();
                    CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, (DiagramEdge<CdiBeanDescriptor>)new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor>)sourceNode, (DiagramNode<CdiBeanDescriptor>)targetNode, ip, beanDescriptors.size() > 2));
                }
                continue;
            }
            this.addInjectionPointEdge(module, targetNode, ip, ip.getType(), edges, diagramState, true);
        }
    }

    private void addInjectionPointEdge(Module module, CdiDiagramNode targetNode, InjectionPointDescriptor descriptor, PsiType type, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor>> edges, DiagramState diagramState, boolean unknownBean) {
        CdiDiagramNode sourceNode;
        PsiClass sourcePsiClass = CdiCommonUtils.getOriginalPsiClass(type, module);
        if (sourcePsiClass != null && (sourceNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(sourcePsiClass), module)) != null) {
            PsiModifierListOwner owner = descriptor.getOwner();
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, (DiagramEdge<CdiBeanDescriptor>)new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor>)sourceNode, (DiagramNode<CdiBeanDescriptor>)targetNode, descriptor, unknownBean));
            this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
        }
    }

    private static boolean isContainerSpecificInjection(PsiClass sourcePsiClass) {
        return "javax.enterprise.event.Event".equals(sourcePsiClass.getQualifiedName());
    }

    private static boolean isPsiClassTypeWithGenerics(PsiType type) {
        if (type instanceof PsiClassType) {
            return CdiCommonUtils.resolveGenerics((PsiClassType)type).size() > 0;
        }
        return false;
    }

    public void removeNode(DiagramNode<CdiBeanDescriptor> node) {
        CdiBeanDescriptor identifyingElement = (CdiBeanDescriptor)node.getIdentifyingElement();
        this.myRemovedNodes.add(identifyingElement);
        this.myAddedNodes.remove(identifyingElement);
    }
}

