/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view.actions;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.view.CdiBeansRecursivePanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.CdiCoreIcons;
import org.jetbrains.annotations.NotNull;

public class ShowInjectionPointsAction
extends ToggleAction {
    private CdiBeansRecursivePanel myPanel;

    public ShowInjectionPointsAction(@NotNull CdiBeansRecursivePanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/cdi/view/actions/ShowInjectionPointsAction", "<init>"));
        }
        this.myPanel = panel;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText("Show Injection Points");
        e.getPresentation().setIcon(CdiCoreIcons.Inject);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myPanel.isShowInjectionPoints();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        CdiViewSettings viewSettings;
        if (state != this.myPanel.isShowInjectionPoints() && (viewSettings = CdiProjectComponent.getInstance(this.myPanel.getProject()).getState()) != null) {
            viewSettings.showInjectionPoints = state;
            this.myPanel.updatePanel();
        }
    }
}

