/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.SpringDataParserUtil;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringDataIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataCommonsCompletionContributor
extends CompletionContributor {
    public SpringDataCommonsCompletionContributor() {
        PsiJavaElementPattern.Capture psiIdentifierCapture = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class)).with((PatternCondition)new PatternCondition<PsiElement>("SpringDataRepository"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$1", "accepts"));
                }
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
                return psiClass != null && SpringDataUtil.isRepository(psiClass);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)psiIdentifierCapture, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$2", "addCompletions"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$2", "addCompletions"));
                }
                Pair repositoryTypes = SpringDataCommonsCompletionContributor.getRepositoryTypes(parameters);
                if (repositoryTypes != null) {
                    result.addAllElements((Iterable)SpringDataCommonsCompletionContributor.getCompletionVariants((Pair<PsiClass, ? extends PsiType>)repositoryTypes, SpringDataCommonsCompletionContributor.getPsiMemberName(parameters), result.getPrefixMatcher()));
                    result.stopHere();
                }
            }
        });
    }

    @NotNull
    private static Set<LookupElement> getCompletionVariants(@NotNull Pair<PsiClass, ? extends PsiType> typesPair, @Nullable String methodName, @NotNull PrefixMatcher matcher) {
        if (typesPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesPair", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        if (methodName == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
            }
            return set;
        }
        String prefix = matcher.getPrefix();
        PsiClass domainClass = (PsiClass)typesPair.getFirst();
        if (domainClass == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
            }
            return set;
        }
        PartTree partTree = new PartTree(methodName, domainClass);
        int offset = prefix.length();
        Position[] ranges = SpringDataCommonsCompletionContributor.getPartTreeTextRanges(partTree).toArray(new Position[1]);
        if (ranges.length == 1 && ranges[0] instanceof PartPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass, "");
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
            }
            return set;
        }
        for (int i = 0; i < ranges.length; ++i) {
            Position nextPosition;
            Position currentPosition = ranges[i];
            Position position = nextPosition = i + 1 < ranges.length ? ranges[i + 1] : null;
            if (currentPosition.getRange().contains(offset)) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionVariants(methodName, domainClass, currentPosition);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
                }
                return set;
            }
            if (currentPosition.getRange().getEndOffset() == offset) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionEndOffsetVariants(methodName, domainClass, currentPosition, nextPosition, offset);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
                }
                return set;
            }
            if (SpringDataCommonsCompletionContributor.isOffsetBetweenKnownPositions(offset, currentPosition, nextPosition)) {
                if (!(nextPosition instanceof PartPosition)) continue;
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getBetweenPartCompletionVariantsElements(methodName, domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, currentPosition.getRange().getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, nextPosition.getRange()));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
                }
                return set;
            }
            if (nextPosition != null || !SpringDataCommonsCompletionContributor.isIncompleteOrderByKeyword(partTree)) continue;
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getEmptyOrderByVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, methodName.indexOf("OrderBy")), "");
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        return set;
    }

    private static boolean isIncompleteOrderByKeyword(PartTree partTree) {
        return partTree.getOrderBySource() != null && partTree.getOrderBySource().getOrders().size() == 0;
    }

    private static boolean isOffsetBetweenKnownPositions(int offset, @NotNull Position currentPosition, @Nullable Position nextPosition) {
        if (currentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPosition", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "isOffsetBetweenKnownPositions"));
        }
        return nextPosition != null && currentPosition.getRange().getEndOffset() < offset && nextPosition.getRange().getStartOffset() > offset;
    }

    @NotNull
    private static Set<LookupElement> getPositionEndOffsetVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position currentPosition, @Nullable Position nextPosition, int offset) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
        }
        if (currentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPosition", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
        }
        TextRange textRange = currentPosition.getRange();
        if (currentPosition instanceof SubjectPosition) {
            if (nextPosition == null) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPropertyWithKeywordVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), "");
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
                }
                return set;
            }
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionVariants(methodName, domainClass, nextPosition);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
            }
            return set;
        }
        if (currentPosition instanceof PartPosition) {
            HashSet variants = ContainerUtil.newHashSet();
            Set<String> propertiesWithKeywords = SpringDataCommonsCompletionContributor.getLastPartPositionVariantsStrings(methodName, domainClass, (PartPosition)currentPosition, offset);
            variants.addAll(SpringDataCommonsCompletionContributor.getCompletionVariants(propertiesWithKeywords, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            variants.addAll(SpringDataCommonsCompletionContributor.getOperationVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            if (nextPosition == null) {
                variants.addAll(SpringDataCommonsCompletionContributor.getEmptyOrderByVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            }
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyChainVariants((PartPosition)currentPosition, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            HashSet hashSet = variants;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
            }
            return hashSet;
        }
        if (currentPosition instanceof SortPosition && nextPosition == null) {
            HashSet variants = ContainerUtil.newHashSet();
            Sort.Order order = ((SortPosition)currentPosition).getOrder();
            if (SpringDataCommonsCompletionContributor.isSortPropertyResolved(order)) {
                variants.addAll(SpringDataCommonsCompletionContributor.getSortVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), ""));
            }
            variants.addAll(SpringDataCommonsCompletionContributor.getSortVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), ""));
            HashSet hashSet = variants;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
            }
            return hashSet;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionEndOffsetVariants"));
        }
        return set;
    }

    @NotNull
    private static Set<String> getLastPartPositionVariantsStrings(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull PartPosition currentPosition, int offset) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getLastPartPositionVariantsStrings"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getLastPartPositionVariantsStrings"));
        }
        if (currentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPosition", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getLastPartPositionVariantsStrings"));
        }
        Set<String> propertiesWithKeywords = SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass));
        propertiesWithKeywords.remove(currentPosition.getPart().getSource());
        if (methodName.length() == offset) {
            if (methodName.endsWith("And")) {
                propertiesWithKeywords.remove("And");
            }
            if (methodName.endsWith("Or")) {
                propertiesWithKeywords.remove("Or");
            }
        }
        Set<String> set = propertiesWithKeywords;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getLastPartPositionVariantsStrings"));
        }
        return set;
    }

    private static boolean isSortPropertyResolved(Sort.Order order) {
        return order.getPropertyPath().getLeafProperty().getType() != null;
    }

    @NotNull
    private static Set<LookupElement> getBetweenPartCompletionVariantsElements(@Nullable String methodName, @NotNull PsiClass domainClass, String prefix, String suffix) {
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getBetweenPartCompletionVariantsElements"));
        }
        Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getOperations(), SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass))), prefix, suffix);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getBetweenPartCompletionVariantsElements"));
        }
        return set;
    }

    private static Set<LookupElement> getEmptyOrderByVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(Collections.singleton("OrderBy"), SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    @NotNull
    private static Set<LookupElement> getCompletionVariants(@NotNull Set<String> strings, @NotNull String prefixExpression, @Nullable String suffixExpression) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SpringDataCommonsCompletionContributor.complete.repository.name");
        HashSet set = ContainerUtil.newHashSet();
        for (String s : strings) {
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            set.add(SpringDataCommonsCompletionContributor.createLookupElement(prefixExpression, s, ""));
            if (StringUtil.isEmptyOrSpaces((String)suffixExpression)) continue;
            set.add(SpringDataCommonsCompletionContributor.createLookupElement(prefixExpression, s, suffixExpression));
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCompletionVariants"));
        }
        return hashSet;
    }

    private static Set<LookupElement> getSortVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass), "Asc", "Desc"), prefixExpression, suffixExpression);
    }

    @NotNull
    private static Set<LookupElement> getPositionVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position position) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
        }
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
        }
        TextRange textRange = position.getRange();
        String prefixExpression = SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset());
        String suffixExpression = SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange);
        if (position instanceof SubjectPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass, suffixExpression);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
            }
            return set;
        }
        if (position instanceof PartPosition) {
            HashSet variants = ContainerUtil.newHashSet();
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyChainVariants((PartPosition)position, prefixExpression, suffixExpression));
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyWithKeywordVariants(domainClass, prefixExpression, suffixExpression));
            HashSet hashSet = variants;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
            }
            return hashSet;
        }
        if (position instanceof SortPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSortVariants(domainClass, prefixExpression, suffixExpression);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPositionVariants"));
        }
        return set;
    }

    @NotNull
    private static Set<LookupElement> getPropertyChainVariants(@NotNull PartPosition position, @NotNull String prefixExpression, @NotNull String suffixExpression) {
        PsiClass psiClass;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
        }
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
        }
        Part part = position.getPart();
        PropertyPath leafProperty = part.getProperty().getLeafProperty();
        PsiType propertyType = leafProperty.getType();
        if (propertyType instanceof PsiClassType && (psiClass = ((PsiClassType)propertyType).resolve()) != null) {
            HashSet propertyChains = ContainerUtil.newHashSet();
            Set<String> capitalizedProperties = SpringDataCommonsCompletionContributor.getCapitalizedProperties(psiClass);
            String segment = StringUtil.capitalize((String)leafProperty.getSegment());
            String propertyPrefix = StringUtil.substringBefore((String)position.getPart().getSource(), (String)segment);
            String propertySuffix = StringUtil.substringAfter((String)position.getPart().getSource(), (String)segment);
            if (propertyPrefix == null || propertySuffix == null) {
                Set<LookupElement> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
                }
                return set;
            }
            if (propertySuffix.startsWith("_")) {
                propertySuffix = StringUtil.substringAfter((String)propertySuffix, (String)"_");
            }
            for (String s : capitalizedProperties) {
                propertyChains.add(segment + s);
                propertyChains.add(segment + "_" + s);
            }
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(propertyChains, prefixExpression + propertyPrefix, propertySuffix + suffixExpression);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyChainVariants"));
        }
        return set;
    }

    private static Set<LookupElement> getPropertyWithKeywordVariants(@NotNull PsiClass domainClass, String prefixExpression, String suffixExpression) {
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPropertyWithKeywordVariants"));
        }
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private static Set<LookupElement> getOperationVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getOperations(), SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private static String getSuffix(@NotNull String methodName, TextRange textRange) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getSuffix"));
        }
        return methodName.substring(textRange.getEndOffset());
    }

    @NotNull
    private static Set<LookupElement> getSubjectVariants(@Nullable PsiClass domainClass, @NotNull String suffixExpression) {
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getSubjectVariants"));
        }
        if (domainClass != null) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass.getName()), "", suffixExpression);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getSubjectVariants"));
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getSubjectVariants"));
        }
        return set;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> getRepositoryTypes(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getRepositoryTypes"));
        }
        PsiClass repositoryClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiClass.class);
        if (repositoryClass == null) {
            return null;
        }
        Pair<PsiClass, ? extends PsiType> pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass);
        return repositoryClass != null ? pair : null;
    }

    @Nullable
    private static String getPsiMemberName(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPsiMemberName"));
        }
        PsiMember psiMember = (PsiMember)parameters.getPosition().getParent();
        PsiMember originalElement = (PsiMember)PsiUtilBase.getOriginalElement((PsiElement)psiMember, PsiMember.class);
        if (originalElement != null) {
            return originalElement.getName();
        }
        return null;
    }

    @NotNull
    private static Set<String> getAllPropertiesWithKeywords(@NotNull Set<String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getAllPropertiesWithKeywords"));
        }
        HashSet all = ContainerUtil.newHashSet();
        for (String property : properties) {
            SpringDataCommonsCompletionContributor.addTails((Collection<String>)all, StringUtil.capitalize((String)property), Part.Type.ALL_KEYWORDS);
        }
        HashSet hashSet = all;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getAllPropertiesWithKeywords"));
        }
        return hashSet;
    }

    private static LookupElementBuilder createLookupElement(@NotNull String prefixExpression, @NotNull String property, @NotNull String suffixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "createLookupElement"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "createLookupElement"));
        }
        if (suffixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixExpression", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "createLookupElement"));
        }
        String lookupText = prefixExpression + property + suffixExpression;
        return LookupElementBuilder.create((String)lookupText).withPresentableText(property).bold().withTailText(StringUtil.isEmptyOrSpaces((String)suffixExpression) ? "" : suffixExpression, true).withIcon(SpringDataIcons.SpringData).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        });
    }

    private static Set<String> getSubjectVariants(@Nullable String domainClassName) {
        com.intellij.util.containers.HashSet strings = new com.intellij.util.containers.HashSet();
        String[] selectQuery = new String[]{"find", "read", "get", "query", "stream"};
        String[] query = new String[]{"count", "delete", "remove"};
        for (String s2 : selectQuery) {
            SpringDataCommonsCompletionContributor.addSubjectSimpleTails((Set<String>)strings, s2, domainClassName);
            SpringDataCommonsCompletionContributor.addTails((Collection<String>)strings, s2, "First", "Top", "DistinctFirst", "DistinctTop");
        }
        for (String s2 : query) {
            SpringDataCommonsCompletionContributor.addSubjectSimpleTails((Set<String>)strings, s2, domainClassName);
        }
        return strings.stream().map(s -> s + "By").collect(Collectors.toSet());
    }

    private static void addSubjectSimpleTails(Set<String> strings, String base, @Nullable String domainClassName) {
        SpringDataCommonsCompletionContributor.addTails(strings, base, "Distinct", "All");
        if (domainClassName != null) {
            SpringDataCommonsCompletionContributor.addTails(strings, base, domainClassName, StringUtil.pluralize((String)domainClassName));
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, String ... tails) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "addTails"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "addTails"));
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, Collection<String> tails) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "addTails"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "addTails"));
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static Set<String> getCapitalizedProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getCapitalizedProperties"));
        }
        return SpringDataUtil.getProperties(domainClass).stream().map(s -> StringUtil.capitalize((String)s)).collect(Collectors.toSet());
    }

    private static List<String> getOperations() {
        return Arrays.asList("And", "Or");
    }

    @NotNull
    public static List<Position> getPartTreeTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPartTreeTextRanges"));
        }
        LinkedList textRanges = ContainerUtil.newLinkedList();
        Pair<PartTree.Subject, TextRange> subject = SpringDataCommonsCompletionContributor.getSubject(partTree);
        if (subject != null) {
            textRanges.add(new SubjectPosition((TextRange)subject.getSecond()));
        }
        for (Map.Entry<Part, TextRange> entry : SpringDataParserUtil.getPartTextRanges(partTree).entrySet()) {
            textRanges.add(new PartPosition(entry.getValue(), entry.getKey()));
        }
        for (Map.Entry<Object, TextRange> entry : SpringDataParserUtil.getSortTextRanges(partTree).entrySet()) {
            textRanges.add(new SortPosition(entry.getValue(), (Sort.Order)entry.getKey()));
        }
        List<Position> list = textRanges.stream().sorted((o1, o2) -> Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(o1.getRange(), o2.getRange())).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "getPartTreeTextRanges"));
        }
        return list;
    }

    @Nullable
    private static Pair<PartTree.Subject, TextRange> getSubject(PartTree partTree) {
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null || StringUtil.isEmptyOrSpaces((String)subject.getExpression())) {
            return null;
        }
        return Pair.create((Object)subject, (Object)TextRange.create((int)0, (int)subject.getExpression().length()));
    }

    private static String getPrefix(String methodName, int offset) {
        return methodName.substring(0, offset);
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, Collection<String> tails) {
        Set<String> set = SpringDataCommonsCompletionContributor.mergeTails(base, ArrayUtil.toStringArray(tails));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "mergeTails"));
        }
        return set;
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, String ... tails) {
        HashSet strings = ContainerUtil.newHashSet();
        for (String property : base) {
            SpringDataCommonsCompletionContributor.addTails((Collection<String>)strings, property, tails);
        }
        HashSet hashSet = strings;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor", "mergeTails"));
        }
        return hashSet;
    }

    private static class SortPosition
    extends Position {
        private Sort.Order myOrder;

        public Sort.Order getOrder() {
            return this.myOrder;
        }

        private SortPosition(@NotNull TextRange range, Sort.Order key) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$SortPosition", "<init>"));
            }
            super(range);
            this.myOrder = key;
        }
    }

    private static class PartPosition
    extends Position {
        private Part myPart;

        private PartPosition(@NotNull TextRange range, @NotNull Part part) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$PartPosition", "<init>"));
            }
            if (part == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "part", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$PartPosition", "<init>"));
            }
            super(range);
            this.myPart = part;
        }

        public Part getPart() {
            return this.myPart;
        }
    }

    private static class SubjectPosition
    extends Position {
        private SubjectPosition(@NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$SubjectPosition", "<init>"));
            }
            super(range);
        }
    }

    private static class Position {
        private TextRange myRange;

        private Position(@NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$Position", "<init>"));
            }
            this.myRange = range;
        }

        public TextRange getRange() {
            return this.myRange;
        }
    }
}

