/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.ql.domain;

import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.data.commons.ql.domain.SpringDataDomainClassQLEntity;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataDomainModel
extends QlModel {
    private PsiElement myContextElement;

    public SpringDataDomainModel(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/data/commons/ql/domain/SpringDataDomainModel", "<init>"));
        }
        this.myContextElement = host;
    }

    public QlEntity[] getEntities() {
        PsiClass domainClass = SpringDataDomainModel.getDomainClass(this.myContextElement);
        if (domainClass != null) {
            return new QlEntity[]{new SpringDataDomainClassQLEntity(domainClass)};
        }
        return new QlEntity[0];
    }

    @Nullable
    public static PsiClass getDomainClass(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/ql/domain/SpringDataDomainModel", "getDomainClass"));
        }
        PsiClass repositoryClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (repositoryClass == null) {
            return null;
        }
        Pair<PsiClass, ? extends PsiType> pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass);
        if (pair == null) {
            return null;
        }
        return (PsiClass)pair.getFirst();
    }
}

