/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilterMarker;

public class DiffEntry {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
    public static final String DEV_NULL = "/dev/null";
    protected String oldPath;
    protected String newPath;
    protected FileMode oldMode;
    protected FileMode newMode;
    protected ChangeType changeType;
    protected int score;
    protected AbbreviatedObjectId oldId;
    protected AbbreviatedObjectId newId;
    private int treeFilterMarks = 0;

    protected DiffEntry() {
    }

    public static List<DiffEntry> scan(TreeWalk walk) throws IOException {
        return DiffEntry.scan(walk, false);
    }

    public static List<DiffEntry> scan(TreeWalk walk, boolean includeTrees) throws IOException {
        return DiffEntry.scan(walk, includeTrees, null);
    }

    public static List<DiffEntry> scan(TreeWalk walk, boolean includeTrees, TreeFilter[] markTreeFilters) throws IOException {
        if (walk.getTreeCount() != 2) {
            throw new IllegalArgumentException(JGitText.get().treeWalkMustHaveExactlyTwoTrees);
        }
        if (includeTrees && walk.isRecursive()) {
            throw new IllegalArgumentException(JGitText.get().cannotBeRecursiveWhenTreesAreIncluded);
        }
        TreeFilterMarker treeFilterMarker = markTreeFilters != null && markTreeFilters.length > 0 ? new TreeFilterMarker(markTreeFilters) : null;
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>();
        MutableObjectId idBuf = new MutableObjectId();
        while (walk.next()) {
            DiffEntry entry = new DiffEntry();
            walk.getObjectId(idBuf, 0);
            entry.oldId = AbbreviatedObjectId.fromObjectId(idBuf);
            walk.getObjectId(idBuf, 1);
            entry.newId = AbbreviatedObjectId.fromObjectId(idBuf);
            entry.oldMode = walk.getFileMode(0);
            entry.newMode = walk.getFileMode(1);
            entry.newPath = entry.oldPath = walk.getPathString();
            if (treeFilterMarker != null) {
                entry.treeFilterMarks = treeFilterMarker.getMarks(walk);
            }
            if (entry.oldMode == FileMode.MISSING) {
                entry.oldPath = DEV_NULL;
                entry.changeType = ChangeType.ADD;
                r.add(entry);
            } else if (entry.newMode == FileMode.MISSING) {
                entry.newPath = DEV_NULL;
                entry.changeType = ChangeType.DELETE;
                r.add(entry);
            } else if (!entry.oldId.equals(entry.newId)) {
                entry.changeType = ChangeType.MODIFY;
                if (RenameDetector.sameType(entry.oldMode, entry.newMode)) {
                    r.add(entry);
                } else {
                    r.addAll(DiffEntry.breakModify(entry));
                }
            } else if (entry.oldMode != entry.newMode) {
                entry.changeType = ChangeType.MODIFY;
                r.add(entry);
            }
            if (!includeTrees || !walk.isSubtree()) continue;
            walk.enterSubtree();
        }
        return r;
    }

    static DiffEntry add(String path, AnyObjectId id) {
        DiffEntry e = new DiffEntry();
        e.oldId = A_ZERO;
        e.oldMode = FileMode.MISSING;
        e.oldPath = DEV_NULL;
        e.newId = AbbreviatedObjectId.fromObjectId(id);
        e.newMode = FileMode.REGULAR_FILE;
        e.newPath = path;
        e.changeType = ChangeType.ADD;
        return e;
    }

    static DiffEntry delete(String path, AnyObjectId id) {
        DiffEntry e = new DiffEntry();
        e.oldId = AbbreviatedObjectId.fromObjectId(id);
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldPath = path;
        e.newId = A_ZERO;
        e.newMode = FileMode.MISSING;
        e.newPath = DEV_NULL;
        e.changeType = ChangeType.DELETE;
        return e;
    }

    static DiffEntry modify(String path) {
        DiffEntry e = new DiffEntry();
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldPath = path;
        e.newMode = FileMode.REGULAR_FILE;
        e.newPath = path;
        e.changeType = ChangeType.MODIFY;
        return e;
    }

    static List<DiffEntry> breakModify(DiffEntry entry) {
        DiffEntry del = new DiffEntry();
        del.oldId = entry.getOldId();
        del.oldMode = entry.getOldMode();
        del.oldPath = entry.getOldPath();
        del.newId = A_ZERO;
        del.newMode = FileMode.MISSING;
        del.newPath = DEV_NULL;
        del.changeType = ChangeType.DELETE;
        DiffEntry add = new DiffEntry();
        add.oldId = A_ZERO;
        add.oldMode = FileMode.MISSING;
        add.oldPath = DEV_NULL;
        add.newId = entry.getNewId();
        add.newMode = entry.getNewMode();
        add.newPath = entry.getNewPath();
        add.changeType = ChangeType.ADD;
        return Arrays.asList(del, add);
    }

    static DiffEntry pair(ChangeType changeType, DiffEntry src, DiffEntry dst, int score) {
        DiffEntry r = new DiffEntry();
        r.oldId = src.oldId;
        r.oldMode = src.oldMode;
        r.oldPath = src.oldPath;
        r.newId = dst.newId;
        r.newMode = dst.newMode;
        r.newPath = dst.newPath;
        r.changeType = changeType;
        r.score = score;
        r.treeFilterMarks = src.treeFilterMarks | dst.treeFilterMarks;
        return r;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getPath(Side side) {
        return side == Side.OLD ? this.getOldPath() : this.getNewPath();
    }

    public FileMode getOldMode() {
        return this.oldMode;
    }

    public FileMode getNewMode() {
        return this.newMode;
    }

    public FileMode getMode(Side side) {
        return side == Side.OLD ? this.getOldMode() : this.getNewMode();
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getScore() {
        return this.score;
    }

    public AbbreviatedObjectId getOldId() {
        return this.oldId;
    }

    public AbbreviatedObjectId getNewId() {
        return this.newId;
    }

    public boolean isMarked(int index) {
        return ((long)this.treeFilterMarks & 1L << index) != 0L;
    }

    public int getTreeFilterMarks() {
        return this.treeFilterMarks;
    }

    public AbbreviatedObjectId getId(Side side) {
        return side == Side.OLD ? this.getOldId() : this.getNewId();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DiffEntry[");
        buf.append((Object)this.changeType);
        buf.append(" ");
        switch (this.changeType) {
            case ADD: {
                buf.append(this.newPath);
                break;
            }
            case COPY: {
                buf.append(this.oldPath + "->" + this.newPath);
                break;
            }
            case DELETE: {
                buf.append(this.oldPath);
                break;
            }
            case MODIFY: {
                buf.append(this.oldPath);
                break;
            }
            case RENAME: {
                buf.append(this.oldPath + "->" + this.newPath);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public static enum Side {
        OLD,
        NEW;

    }

    public static enum ChangeType {
        ADD,
        MODIFY,
        DELETE,
        RENAME,
        COPY;

    }
}

