/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SLRUMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringCachingProcessor<InParams extends SpringModelSearchParameters> {
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private static final String CACHE_SIZE_PROPERTY_NAME = "idea.spring.model.processing.cache.size";
    private static final int CONFIGURED_CACHE_SIZE = SystemProperties.getIntProperty((String)"idea.spring.model.processing.cache.size", (int)1000);
    private final SpringSLRUCache<InParams, Collection<SpringBeanPointer>> myFindAllCache = new SpringSLRUCache<InParams, Collection<SpringBeanPointer>>(CONFIGURED_CACHE_SIZE){

        @Override
        @NotNull
        protected Collection<SpringBeanPointer> createValue(InParams key) {
            Collection<SpringBeanPointer> collection = SpringCachingProcessor.this.findPointers(key);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$1", "createValue"));
            }
            return collection;
        }
    };
    private final SpringSLRUCache<InParams, NullableLazyValue<SpringBeanPointer>> myFindFirstCache = new SpringSLRUCache<InParams, NullableLazyValue<SpringBeanPointer>>(CONFIGURED_CACHE_SIZE){

        @Override
        @NotNull
        protected NullableLazyValue<SpringBeanPointer> createValue(final InParams key) {
            NullableLazyValue<SpringBeanPointer> nullableLazyValue = new NullableLazyValue<SpringBeanPointer>(){

                @Nullable
                protected SpringBeanPointer compute() {
                    return SpringCachingProcessor.this.findFirstPointer(key);
                }
            };
            if (nullableLazyValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$2", "createValue"));
            }
            return nullableLazyValue;
        }
    };

    @NotNull
    protected abstract Collection<SpringBeanPointer> findPointers(@NotNull InParams var1);

    protected SpringCachingProcessor() {
    }

    @Nullable
    protected abstract SpringBeanPointer findFirstPointer(@NotNull InParams var1);

    public boolean process(InParams params, Processor<SpringBeanPointer> processor, Set<String> activeProfiles) {
        if (processor instanceof CommonProcessors.FindFirstProcessor && this.myFindAllCache.getCachedValue(params) == null) {
            SpringBeanPointer first = (SpringBeanPointer)this.myFindFirstCache.get(params).getValue();
            return SpringCachingProcessor.processBeansInActiveProfile(processor, first, activeProfiles);
        }
        for (SpringBeanPointer pointer : this.myFindAllCache.get(params)) {
            if (SpringCachingProcessor.processBeansInActiveProfile(processor, pointer, activeProfiles)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBeansInActiveProfile(Processor<SpringBeanPointer> processor, @Nullable SpringBeanPointer pointer, Set<String> activeProfiles) {
        if (pointer == null) {
            return true;
        }
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return processor.process((Object)pointer);
        }
        if (!SpringProfileUtils.isProfileAccepted(pointer.getSpringBean().getProfile(), activeProfiles)) {
            return true;
        }
        return processor.process((Object)pointer);
    }

    protected static abstract class SpringSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = new Object();

        protected SpringSLRUCache(int queueSize) {
            super(queueSize, queueSize);
        }

        @NotNull
        protected abstract V createValue(K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public V get(K key) {
            V value = this.getCachedValue(key);
            if (value != null) {
                V v = value;
                if (v == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$SpringSLRUCache", "get"));
                }
                return v;
            }
            value = this.createValue(key);
            Object object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            V v = value;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$SpringSLRUCache", "get"));
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        protected V getCachedValue(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
            }
            return (V)value;
        }
    }
}

