/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.VisitedModelsDelegateProcessor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.custom.CustomComponentsDiscovererHelper;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModel
implements CommonSpringModel {
    @Nullable
    private final Module myModule;
    private Set<SpringModel> myDependencies = Collections.emptySet();
    @Nullable
    private final SpringFileSet myFileSet;
    public static final CommonSpringModel UNKNOWN = new CommonSpringModel(){

        @Override
        public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel$2", "processByClass"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel$2", "processByClass"));
            }
            return true;
        }

        @Override
        public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel$2", "processByName"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel$2", "processByName"));
            }
            return true;
        }

        @Override
        @NotNull
        public Collection<SpringBeanPointer> getAllDomBeans() {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getAllDomBeans"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<SpringBeanPointer> getAllCommonBeans() {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getAllCommonBeans"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<String> getAllBeanNames(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel$2", "getAllBeanNames"));
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getAllBeanNames"));
            }
            return set;
        }

        @Override
        public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel$2", "getDuplicatedNames"));
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> getPlaceholderConfigurers() {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getPlaceholderConfigurers"));
            }
            return list;
        }

        @NotNull
        public List<SpringBeansPackagesScan> getComponentScans() {
            List<SpringBeansPackagesScan> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getComponentScans"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getAnnotationConfigApplicationContexts"));
            }
            return list;
        }

        @Override
        public Collection<XmlTag> getCustomBeanCandidates(String id) {
            return Collections.emptyList();
        }

        @Override
        public Module getModule() {
            return null;
        }

        @Override
        public Set<String> getActiveProfiles() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<String> getAllProfiles() {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getAllProfiles"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<PsiFile> getConfigFiles() {
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "getConfigFiles"));
            }
            return set;
        }

        @Override
        public boolean hasConfigFile(@NotNull PsiFile configFile) {
            if (configFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/SpringModel$2", "hasConfigFile"));
            }
            return false;
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> findQualifiedBeans(@NotNull SpringQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/SpringModel$2", "findQualifiedBeans"));
            }
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$2", "findQualifiedBeans"));
            }
            return list;
        }
    };

    protected SpringModel(@Nullable Module module) {
        this(module, null);
    }

    protected SpringModel(@Nullable Module module, @Nullable SpringFileSet fileSet) {
        this.myFileSet = fileSet;
        this.myModule = module;
    }

    @Nullable
    public SpringFileSet getFileSet() {
        return this.myFileSet;
    }

    @NotNull
    public Set<SpringModel> getDependencies() {
        Set<SpringModel> set = this.myDependencies;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getDependencies"));
        }
        return set;
    }

    public void setDependencies(@NotNull Set<SpringModel> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/spring/contexts/model/SpringModel", "setDependencies"));
        }
        this.myDependencies = dependencies;
    }

    @NotNull
    public final Set<CommonSpringModel> getModelsToProcess() {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        ContainerUtil.addAllNotNull(models, this.getModelsToProcess(true));
        if (this.myModule != null && !this.myModule.isDisposed()) {
            ContainerUtil.addAllNotNull(models, CustomComponentsDiscovererHelper.getInstance(this.myModule).getCustomModels());
        }
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    public abstract Set<CommonSpringModel> getModelsToProcess(boolean var1);

    @Override
    @NotNull
    public Collection<SpringBeanPointer> getAllDomBeans() {
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels((Processor<CommonSpringModel>)((Processor)model -> {
            pointers.addAll(model.getAllDomBeans());
            return true;
        }));
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllDomBeans"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<String> getAllBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "getAllBeanNames"));
        }
        THashSet allOtherNames = new THashSet();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getAllBeanNames$1(beanName, (Set)allOtherNames, arg_0)));
        Object object = allOtherNames.size() > 0 ? allOtherNames : Collections.singleton(beanName);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllBeanNames"));
        }
        return object;
    }

    @Override
    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "getDuplicatedNames"));
        }
        SmartList pointers = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getDuplicatedNames$2((List)pointers, beanName, arg_0)));
        return pointers;
    }

    @Override
    @NotNull
    public Collection<SpringBeanPointer> getAllCommonBeans() {
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels((Processor<CommonSpringModel>)((Processor)model -> {
            pointers.addAll(model.getAllCommonBeans());
            return true;
        }));
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllCommonBeans"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> findQualifiedBeans(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/SpringModel", "findQualifiedBeans"));
        }
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels((Processor<CommonSpringModel>)((Processor)model -> {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/SpringModel", "lambda$findQualifiedBeans$4"));
            }
            pointers.addAll(model.findQualifiedBeans(qualifier));
            return true;
        }));
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "findQualifiedBeans"));
        }
        return arrayList;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processByClass"));
        }
        if (!params.canSearch()) {
            return true;
        }
        VisitedModelsDelegateProcessor delegateProcessor = new VisitedModelsDelegateProcessor(processor);
        return this.processModels((Processor<CommonSpringModel>)((Processor)commonModel -> {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "lambda$processByClass$5"));
            }
            if (delegateProcessor.hasBeenVisited((CommonSpringModel)commonModel)) {
                return true;
            }
            delegateProcessor.addVisited((CommonSpringModel)commonModel);
            return commonModel.processByClass(params, delegateProcessor);
        }));
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processByName"));
        }
        if (!params.canSearch()) {
            return true;
        }
        VisitedModelsDelegateProcessor delegateProcessor = new VisitedModelsDelegateProcessor(processor);
        return this.processModels((Processor<CommonSpringModel>)((Processor)commonModel -> {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "lambda$processByName$6"));
            }
            if (delegateProcessor.hasBeenVisited((CommonSpringModel)commonModel)) {
                return true;
            }
            delegateProcessor.addVisited((CommonSpringModel)commonModel);
            return commonModel.processByName(params, delegateProcessor);
        }));
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public String toString() {
        SpringFileSet fileSet = this.getFileSet();
        return this.getClass().getName() + (fileSet != null ? " fileset=" + fileSet.getId() : "");
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        SmartList pointers = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getPlaceholderConfigurers$7((List)pointers, arg_0)));
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getPlaceholderConfigurers"));
        }
        return smartList;
    }

    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        SmartList pointers = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getComponentScans$8((List)pointers, arg_0)));
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getComponentScans"));
        }
        return smartList;
    }

    public boolean processModels(@NotNull Processor<CommonSpringModel> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        return SpringModel.processModels(this, (Set<CommonSpringModel>)ContainerUtil.newTroveSet(), processor);
    }

    private static boolean processModels(@NotNull CommonSpringModel model, @NotNull Set<CommonSpringModel> visited, @NotNull Processor<CommonSpringModel> processor) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (visited.add(model)) {
            ProgressManager.checkCanceled();
            if (model instanceof SpringModel) {
                for (CommonSpringModel commonModel : ((SpringModel)model).getModelsToProcess()) {
                    if (SpringModel.processModels(commonModel, visited, processor)) continue;
                    return false;
                }
            } else {
                return processor.process((Object)model);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        SmartList pointers = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getAnnotationConfigApplicationContexts$9((List)pointers, arg_0)));
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAnnotationConfigApplicationContexts"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public Set<String> getActiveProfiles() {
        if (this.myFileSet == null) {
            return null;
        }
        return this.myFileSet.getActiveProfiles();
    }

    @Override
    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        SmartList tags = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getCustomBeanCandidates$10((Collection)tags, id, arg_0)));
        return tags;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/contexts/model/SpringModel", "getDescendants"));
        }
        SmartList pointers = new SmartList();
        this.processModels((Processor<CommonSpringModel>)((Processor)arg_0 -> SpringModel.lambda$getDescendants$11((List)pointers, context, arg_0)));
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getDescendants"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        LinkedHashSet<PsiFile> files = new LinkedHashSet<PsiFile>();
        Processor collectConfigFiles = commonSpringModel -> {
            files.addAll(commonSpringModel.getConfigFiles());
            return true;
        };
        this.processConfigFiles((Processor<CommonSpringModel>)collectConfigFiles);
        LinkedHashSet<PsiFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getConfigFiles"));
        }
        return linkedHashSet;
    }

    @Override
    public boolean hasConfigFile(final @NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/SpringModel", "hasConfigFile"));
        }
        CommonProcessors.FindProcessor<CommonSpringModel> findProcessor = new CommonProcessors.FindProcessor<CommonSpringModel>(){

            protected boolean accept(CommonSpringModel model) {
                return model.hasConfigFile(configFile);
            }
        };
        this.processConfigFiles((Processor<CommonSpringModel>)findProcessor);
        return findProcessor.isFound();
    }

    protected boolean processConfigFiles(Processor<CommonSpringModel> processor) {
        return this.processModels((Processor<CommonSpringModel>)((Processor)commonModel -> {
            if (!processor.process(commonModel)) {
                return false;
            }
            return !(commonModel instanceof CachedLocalModel) || ((CachedLocalModel)commonModel).processRelatedModels(processor);
        }));
    }

    private static /* synthetic */ boolean lambda$getDescendants$11(List pointers, @NotNull SpringBeanPointer context, CommonSpringModel model) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/contexts/model/SpringModel", "lambda$getDescendants$11"));
        }
        pointers.addAll(model.getDescendants(context));
        return true;
    }

    private static /* synthetic */ boolean lambda$getCustomBeanCandidates$10(Collection tags, String id, CommonSpringModel model) {
        tags.addAll(model.getCustomBeanCandidates(id));
        return true;
    }

    private static /* synthetic */ boolean lambda$getAnnotationConfigApplicationContexts$9(List pointers, CommonSpringModel model) {
        pointers.addAll(model.getAnnotationConfigApplicationContexts());
        return true;
    }

    private static /* synthetic */ boolean lambda$getComponentScans$8(List pointers, CommonSpringModel model) {
        pointers.addAll(model.getComponentScans());
        return true;
    }

    private static /* synthetic */ boolean lambda$getPlaceholderConfigurers$7(List pointers, CommonSpringModel model) {
        pointers.addAll(model.getPlaceholderConfigurers());
        return true;
    }

    private static /* synthetic */ boolean lambda$getDuplicatedNames$2(List pointers, @NotNull String beanName, CommonSpringModel model) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "lambda$getDuplicatedNames$2"));
        }
        pointers.addAll(model.getDuplicatedNames(beanName));
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllBeanNames$1(@NotNull String beanName, Set allOtherNames, CommonSpringModel model) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "lambda$getAllBeanNames$1"));
        }
        Set<String> otherNames = model.getAllBeanNames(beanName);
        if (otherNames.size() > 1) {
            allOtherNames.addAll(otherNames);
        }
        return true;
    }
}

