/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PatternUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAntPatternPackageReferenceSet
extends PackageReferenceSet {
    public SpringAntPatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet", "<init>"));
        }
        super(packageName, element, startInElement, scope);
    }

    @NotNull
    protected PsiPackageReference createReference(TextRange range, int index) {
        PsiPackageReference psiPackageReference = new PsiPackageReference(this, range, index){

            @NotNull
            protected ResolveResult[] doMultiResolve() {
                HashSet<PsiPackage> packages = new HashSet<PsiPackage>();
                for (PsiPackage parentPackage : this.getContext()) {
                    packages.addAll(this.resolvePackages(parentPackage));
                }
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(packages);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1", "doMultiResolve"));
                }
                return resolveResultArray;
            }

            public Collection<PsiPackage> resolvePackages(@Nullable PsiPackage context) {
                PsiPackageReference parentContextReference;
                if (context == null) {
                    return Collections.emptySet();
                }
                String packageName = this.getValue();
                CommonProcessors.CollectProcessor<PsiPackage> processor = this.getProcessor(packageName);
                PsiPackageReference psiPackageReference = parentContextReference = this.myIndex > 0 ? (PsiPackageReference)this.getReferenceSet().getReference(this.myIndex - 1) : null;
                if (packageName.equals("*")) {
                    for (PsiPackage aPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        if (!processor.process((Object)aPackage)) break;
                    }
                    return processor.getResults();
                }
                if (parentContextReference != null && parentContextReference.getValue().equals("**")) {
                    return this.getSubPackages(context, processor);
                }
                if (packageName.equals("**")) {
                    if (this.isLastReference()) {
                        return this.getSubPackages(context, processor);
                    }
                    return Collections.singleton(context);
                }
                if (packageName.contains("*") || packageName.contains("?")) {
                    for (PsiPackage aPackage : context.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                        processor.process((Object)aPackage);
                    }
                    return processor.getResults();
                }
                return this.getReferenceSet().resolvePackageName(context, packageName);
            }

            public boolean isLastReference() {
                return ((Object)((Object)this)).equals(this.getReferenceSet().getLastReference());
            }

            @NotNull
            public CommonProcessors.CollectProcessor<PsiPackage> getProcessor(@NotNull String packageName) {
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1", "getProcessor"));
                }
                final Pattern pattern = PatternUtil.fromMask((String)packageName);
                CommonProcessors.CollectProcessor<PsiPackage> collectProcessor = new CommonProcessors.CollectProcessor<PsiPackage>(new LinkedHashSet()){

                    protected boolean accept(PsiPackage aPackage) {
                        String name = aPackage.getName();
                        return name != null && pattern.matcher(name).matches();
                    }
                };
                if (collectProcessor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1", "getProcessor"));
                }
                return collectProcessor;
            }

            @NotNull
            public Collection<PsiPackage> getSubPackages(@Nullable PsiPackage context, CommonProcessors.CollectProcessor<PsiPackage> processor) {
                this.processSubPackages(context, processor);
                Collection collection = processor.getResults();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet$1", "getSubPackages"));
                }
                return collection;
            }

            private void processSubPackages(PsiPackage pkg, CommonProcessors.CollectProcessor<PsiPackage> processor) {
                for (PsiPackage aPackage : pkg.getSubPackages(SpringAntPatternPackageReferenceSet.this.getResolveScope())) {
                    processor.process((Object)aPackage);
                    this.processSubPackages(aPackage, processor);
                }
            }
        };
        if (psiPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringAntPatternPackageReferenceSet", "createReference"));
        }
        return psiPackageReference;
    }
}

