/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SpringBeanReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    private final NullableFunction<PsiElement, PsiClass> myRequiredTypeFun;

    public SpringBeanReferenceProvider() {
        this.myRequiredTypeFun = member -> null;
    }

    public SpringBeanReferenceProvider(@NotNull NullableFunction<PsiElement, PsiClass> requiredTypeFun) {
        if (requiredTypeFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredTypeFun", "com/intellij/spring/references/SpringBeanReferenceProvider", "<init>"));
        }
        this.myRequiredTypeFun = requiredTypeFun;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringBeanReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringBeanReferenceProvider", "getReferencesByElement"));
        }
        String beanName = (String)((PsiLiteralExpression)element).getValue();
        boolean isFactoryBeanRef = false;
        if (StringUtil.isEmptyOrSpaces((String)beanName)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringBeanReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (beanName.startsWith("&")) {
            beanName = beanName.substring(1);
            isFactoryBeanRef = true;
        }
        TextRange range = TextRange.from((int)element.getText().indexOf(beanName), (int)beanName.length());
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference(element, range, (PsiClass)this.myRequiredTypeFun.fun((Object)element), isFactoryBeanRef){

            public boolean isSoft() {
                return true;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringBeanReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

