/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.icons.AllIcons;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptLanguageServiceCompletionContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import icons.AngularJSIcons;
import javax.swing.Icon;
import org.angularjs.service.Angular2LanguageService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2ServiceCompletionContributor
extends TypeScriptLanguageServiceCompletionContributor {
    protected boolean isAvailableForFile(PsiFile file) {
        if (!Angular2LanguageService.isEnabledAngularService(file.getProject())) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return TypeScriptLanguageServiceUtil.useServiceCompletion((Project)file.getProject(), (VirtualFile)virtualFile);
    }

    protected boolean isApplicablePlaceForCompletion(PsiElement position) {
        IElementType type;
        PsiElement parent = position.getParent();
        if (parent instanceof JSExpression) {
            return true;
        }
        return parent instanceof XmlTag && ((type = position.getNode().getElementType()) == XmlTokenType.XML_NAME || type == XmlTokenType.XML_TAG_NAME);
    }

    protected VirtualFile getVirtualFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/codeInsight/Angular2ServiceCompletionContributor", "getVirtualFile"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        return virtualFile;
    }

    @Nullable
    protected Icon getIcon(String kind, @Nullable String kindModifiers) {
        if ("element".equals(kind)) {
            return AllIcons.Nodes.Tag;
        }
        if ("component".equals(kind)) {
            return AngularJSIcons.Angular2;
        }
        return Angular2ServiceCompletionContributor.getKindIcon((String)kind);
    }
}

