/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.angularjs.codeInsight.refs.AngularPolyReferenceBase;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularUiRouterViewsIndex;
import org.jetbrains.annotations.NotNull;

public class AngularJSUiRouterViewReferencesProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSUiRouterViewReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/codeInsight/refs/AngularJSUiRouterViewReferencesProvider", "getReferencesByElement"));
        }
        PsiElement identifier = element instanceof JSProperty ? ((JSProperty)element).getNameIdentifier() : element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new AngularJSUiRouterViewReference(identifier)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterViewReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class AngularJSUiRouterViewReference
    extends AngularPolyReferenceBase<PsiElement> {
        public AngularJSUiRouterViewReference(PsiElement element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        private String getViewName() {
            String text = StringUtil.unquoteString((String)this.getCanonicalText());
            int idx = text.indexOf(64);
            if (idx >= 0) {
                return text.substring(0, idx);
            }
            return text;
        }

        @Override
        @NotNull
        public ResolveResult[] resolveInner() {
            String id = this.getViewName();
            Condition<VirtualFile> filter = StringUtil.isEmptyOrSpaces((String)id) ? this.filterByTemplateUrl() : Condition.TRUE;
            ResolveResult[] resolveResultArray = AngularIndexUtil.multiResolveAngularNamedDefinitionIndex(this.getElement().getProject(), AngularUiRouterViewsIndex.UI_ROUTER_VIEWS_CACHE_INDEX, id, filter, false);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterViewReferencesProvider$AngularJSUiRouterViewReference", "resolveInner"));
            }
            return resolveResultArray;
        }

        private Condition<VirtualFile> filterByTemplateUrl() {
            String templateUrlText;
            JSProperty templateUrl;
            JSExpression object;
            JSExpression jSExpression = object = this.myElement.getParent() instanceof JSProperty ? ((JSProperty)this.myElement.getParent()).getValue() : null;
            if (object instanceof JSObjectLiteralExpression && (templateUrl = ((JSObjectLiteralExpression)object).findProperty("templateUrl")) != null && templateUrl.getValue() != null && templateUrl.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)templateUrl.getValue()).isQuotedLiteral() && !StringUtil.isEmptyOrSpaces((String)(templateUrlText = StringUtil.unquoteString((String)templateUrl.getValue().getText())))) {
                String finalTemplateUrlText = templateUrlText = templateUrlText.trim().replace('\\', '/');
                return file -> {
                    String path = file.getPath();
                    return path.endsWith(finalTemplateUrlText);
                };
            }
            return Condition.TRUE;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterViewReferencesProvider$AngularJSUiRouterViewReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

