/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.tags;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import icons.AngularJSIcons;
import java.util.List;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.tags.AngularJSTagDescriptor;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSTagDescriptorsProvider
implements XmlElementDescriptorProvider,
XmlTagNameProvider {
    private static final String NG_CONTAINER = "ng-container";
    private static final String NG_CONTENT = "ng-content";
    private static final String NG_TEMPLATE = "ng-template";

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag xmlTag, String prefix) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "org/angularjs/codeInsight/tags/AngularJSTagDescriptorsProvider", "addTagNameVariants"));
        }
        if (!(xmlTag instanceof HtmlTag) || !AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
            return;
        }
        Project project = xmlTag.getProject();
        Language language = xmlTag.getContainingFile().getLanguage();
        DirectiveUtil.processTagDirectives(project, (Processor<JSImplicitElement>)((Processor)directive -> {
            AngularJSTagDescriptorsProvider.addLookupItem(language, elements, directive);
            return true;
        }));
        if (AngularIndexUtil.hasAngularJS2(project)) {
            AngularJSTagDescriptorsProvider.addLookupItem(language, elements, (JSImplicitElement)AngularJSTagDescriptorsProvider.createDirective(xmlTag, NG_CONTAINER));
            AngularJSTagDescriptorsProvider.addLookupItem(language, elements, (JSImplicitElement)AngularJSTagDescriptorsProvider.createDirective(xmlTag, NG_CONTENT));
            AngularJSTagDescriptorsProvider.addLookupItem(language, elements, (JSImplicitElement)AngularJSTagDescriptorsProvider.createDirective(xmlTag, NG_TEMPLATE));
        }
    }

    private static void addLookupItem(Language language, List<LookupElement> elements, JSImplicitElement directive) {
        LookupElementBuilder element = LookupElementBuilder.create((PsiNamedElement)directive).withIcon(AngularJSIcons.Angular2);
        if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            element = element.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        }
        elements.add((LookupElement)element);
    }

    @Nullable
    public XmlElementDescriptor getDescriptor(XmlTag xmlTag) {
        XmlElementDescriptor descriptor;
        Project project = xmlTag.getProject();
        if (!(xmlTag instanceof HtmlTag) || !AngularIndexUtil.hasAngularJS(project)) {
            return null;
        }
        String tagName = xmlTag.getName();
        String directiveName = DirectiveUtil.normalizeAttributeName(tagName);
        XmlNSDescriptor nsDescriptor = xmlTag.getNSDescriptor(xmlTag.getNamespace(), false);
        XmlElementDescriptor xmlElementDescriptor = descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(xmlTag) : null;
        if (descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor)) {
            return null;
        }
        if ((NG_CONTAINER.equals(directiveName) || NG_CONTENT.equals(directiveName) || NG_TEMPLATE.equals(directiveName)) && AngularIndexUtil.hasAngularJS2(project)) {
            return new AngularJSTagDescriptor(directiveName, (JSImplicitElement)AngularJSTagDescriptorsProvider.createDirective(xmlTag, directiveName));
        }
        JSImplicitElement directive = DirectiveUtil.getTagDirective(directiveName, project);
        if (DirectiveUtil.isAngular2Directive((PsiElement)directive) && !directive.getName().equals(tagName)) {
            directive = null;
        }
        if (directive == null && !tagName.equals(directiveName) && AngularIndexUtil.hasAngularJS2(project) && !DirectiveUtil.isAngular2Directive((PsiElement)(directive = DirectiveUtil.getTagDirective(tagName, project)))) {
            directive = null;
        }
        return directive != null ? new AngularJSTagDescriptor(directiveName, directive) : null;
    }

    @NotNull
    private static JSImplicitElementImpl createDirective(XmlTag xmlTag, String name) {
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl.Builder(name, (PsiElement)xmlTag).setTypeString("E;;;").toImplicitElement();
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/tags/AngularJSTagDescriptorsProvider", "createDirective"));
        }
        return jSImplicitElementImpl;
    }
}

