/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularFilterIndex;
import org.angularjs.index.AngularGenericModulesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularInjectionDelimiterIndex;
import org.angularjs.index.AngularModuleIndex;
import org.angularjs.index.AngularSymbolIndex;
import org.angularjs.index.AngularUiRouterGenericStatesIndex;
import org.angularjs.index.AngularUiRouterStatesIndex;
import org.angularjs.lang.AngularJSLanguage;
import org.angularjs.lang.psi.AngularJSAsExpression;
import org.angularjs.lang.psi.AngularJSFilterExpression;
import org.angularjs.lang.psi.AngularJSRepeatExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSIndexingHandler
extends FrameworkIndexingHandler {
    private static final Map<String, StubIndexKey<String, JSImplicitElementProvider>> INDEXERS = new HashMap<String, StubIndexKey<String, JSImplicitElementProvider>>();
    private static final Map<String, Function<String, String>> NAME_CONVERTERS = new HashMap<String, Function<String, String>>();
    private static final Map<String, Function<PsiElement, String>> DATA_CALCULATORS = new HashMap<String, Function<PsiElement, String>>();
    private static final Map<String, PairProcessor<JSProperty, JSElementIndexingData>> CUSTOM_PROPERTY_PROCESSORS = new HashMap<String, PairProcessor<JSProperty, JSElementIndexingData>>();
    private static final Map<String, Function<String, List<String>>> POLY_NAME_CONVERTERS = new HashMap<String, Function<String, List<String>>>();
    private static final Map<String, Processor<JSArgumentList>> ARGUMENT_LIST_CHECKERS = new HashMap<String, Processor<JSArgumentList>>();
    public static final Set<String> INTERESTING_METHODS = new HashSet<String>();
    public static final Set<String> INJECTABLE_METHODS = new HashSet<String>();
    public static final String CONTROLLER = "controller";
    public static final String DIRECTIVE = "directive";
    public static final String COMPONENT = "component";
    public static final String BINDINGS = "bindings";
    public static final String MODULE = "module";
    public static final String FILTER = "filter";
    public static final String STATE = "state";
    private static final String START_SYMBOL = "startSymbol";
    private static final String END_SYMBOL = "endSymbol";
    public static final String DEFAULT_RESTRICTIONS = "D";
    public static final String WHEN = "when";
    private static final String[] ALL_INTERESTING_METHODS;
    private static final BidirectionalMap<String, StubIndexKey<String, JSImplicitElementProvider>> INDEXES;
    public static final String AS_CONNECTOR_WITH_SPACES = " as ";
    public static final String ANGULAR_DIRECTIVES_INDEX_USER_STRING = "adi";
    public static final String ANGULAR_FILTER_INDEX_USER_STRING = "afi";
    public static final String ANGULAR_SYMBOL_INDEX_USER_STRING = "asi";
    public static final String ANGULAR_MODULE_INDEX_USER_STRING = "ami";
    static final String RESTRICT = "@restrict";
    static final String ELEMENT = "@element";
    private static final String PARAM = "@param";

    public static boolean isInjectable(PsiElement context) {
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSCallExpression.class, (boolean)false, (Class[])new Class[]{JSBlockStatement.class});
        if (call != null) {
            JSExpression methodExpression = call.getMethodExpression();
            JSReferenceExpression callee = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
            JSExpression qualifier = callee != null ? callee.getQualifier() : null;
            return qualifier != null && INJECTABLE_METHODS.contains(callee.getReferenceName());
        }
        return false;
    }

    @NotNull
    public String[] interestedMethodNames() {
        if (ALL_INTERESTING_METHODS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularJSIndexingHandler", "interestedMethodNames"));
        }
        return ALL_INTERESTING_METHODS;
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(final @NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/angularjs/index/AngularJSIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        return new JSLiteralImplicitElementProvider(){

            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/angularjs/index/AngularJSIndexingHandler$1", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/angularjs/index/AngularJSIndexingHandler$1", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "org/angularjs/index/AngularJSIndexingHandler$1", "fillIndexingData"));
                }
                JSExpression[] arguments = callExpression.getArguments();
                if (arguments.length == 0 || arguments[0] != argument) {
                    return;
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return;
                }
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier == null) {
                    return;
                }
                StubIndexKey index = (StubIndexKey)INDEXERS.get(command);
                if (index != null) {
                    if (argument.isQuotedLiteral()) {
                        Processor argumentListProcessor = (Processor)ARGUMENT_LIST_CHECKERS.get(command);
                        if (argumentListProcessor != null && !argumentListProcessor.process((Object)callExpression.getArgumentList())) {
                            return;
                        }
                        Function calculator = (Function)DATA_CALCULATORS.get(command);
                        String data = calculator != null ? (String)calculator.fun((Object)argument) : null;
                        String argumentText = AngularJSIndexingHandler.unquote((PsiElement)argument);
                        AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)argument, command, (StubIndexKey<String, JSImplicitElementProvider>)index, argumentText, data, outIndexingData);
                    }
                } else if (INJECTABLE_METHODS.contains(command) && argument.isQuotedLiteral()) {
                    AngularJSIndexingHandler.generateNamespace(argument, outIndexingData);
                }
                if (AngularJSIndexingHandler.START_SYMBOL.equals(command) || AngularJSIndexingHandler.END_SYMBOL.equals(command)) {
                    while (qualifier != null) {
                        if (qualifier instanceof JSReferenceExpression) {
                            if ("$interpolateProvider".equals(((JSReferenceExpression)qualifier).getReferenceName()) && argument.isQuotedLiteral()) {
                                String interpolation = AngularJSIndexingHandler.unquote((PsiElement)argument);
                                if ("//".equals(interpolation)) {
                                    return;
                                }
                                FileViewProvider provider = qualifier.getContainingFile().getOriginalFile().getViewProvider();
                                VirtualFile virtualFile = provider.getVirtualFile();
                                VirtualFile virtualFile2 = virtualFile = virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile).getOriginalFile() : virtualFile;
                                if (JSLibraryUtil.isProbableLibraryFile((VirtualFile)virtualFile)) {
                                    return;
                                }
                                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)argument, null, (StubIndexKey<String, JSImplicitElementProvider>)AngularInjectionDelimiterIndex.KEY, command, interpolation, outIndexingData);
                            }
                            qualifier = ((JSReferenceExpression)qualifier).getQualifier();
                            continue;
                        }
                        qualifier = qualifier instanceof JSCallExpression ? ((JSCallExpression)qualifier).getMethodExpression() : null;
                    }
                }
            }
        };
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression[] arguments;
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJSIndexingHandler", "processCallExpression"));
        }
        JSReferenceExpression reference = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        if (reference == null) {
            return;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)reference, (String[])new String[]{"$stateProvider", STATE})) {
            JSExpression[] arguments2 = callExpression.getArguments();
            if (arguments2.length == 1 && arguments2[0] instanceof JSReferenceExpression) {
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)callExpression, null, AngularUiRouterGenericStatesIndex.KEY, STATE, null, outData);
            }
        } else if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)reference, (String[])new String[]{"angular", MODULE}) && (arguments = callExpression.getArguments()).length > 1 && arguments[0] instanceof JSReferenceExpression) {
            AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)callExpression, null, AngularGenericModulesIndex.KEY, MODULE, null, outData);
        }
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression((ASTNode)node);
        if (methodExpression == null) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        ASTNode qualifier = JSReferenceExpressionImpl.getQualifierNode((ASTNode)methodExpression);
        if (qualifier == null) {
            return false;
        }
        return STATE.equals(referencedNameElement.getText()) && "$stateProvider".equalsIgnoreCase(qualifier.getText()) || MODULE.equals(referencedNameElement.getText()) && "angular".equalsIgnoreCase(qualifier.getText());
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        JSElementIndexingData localOutData;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/angularjs/index/AngularJSIndexingHandler", "processAnyProperty"));
        }
        String name = property.getName();
        if (name == null) {
            return outData;
        }
        Pair<JSCallExpression, Integer> pair = AngularJSIndexingHandler.findImmediatelyWrappingCall(property);
        if (pair == null) {
            return outData;
        }
        JSCallExpression callExpression = (JSCallExpression)pair.getFirst();
        int level = (Integer)pair.getSecond();
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)methodExpression).getQualifier() == null) {
            return outData;
        }
        String command = ((JSReferenceExpression)methodExpression).getReferenceName();
        PairProcessor<JSProperty, JSElementIndexingData> customProcessor = CUSTOM_PROPERTY_PROCESSORS.get(command);
        if (customProcessor != null && customProcessor.process((Object)property, (Object)(localOutData = outData == null ? new JSElementIndexingDataImpl() : outData))) {
            return localOutData;
        }
        if (level > 1) {
            return outData;
        }
        PsiElement parent = property.getParent();
        StubIndexKey<String, JSImplicitElementProvider> index = INDEXERS.get(command);
        if (index == null) {
            return outData;
        }
        if (callExpression.getArguments()[0] != parent) {
            return outData;
        }
        if (outData == null) {
            outData = new JSElementIndexingDataImpl();
        }
        AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)property, command, index, name, null, outData);
        return outData;
    }

    @Nullable
    private static Pair<JSCallExpression, Integer> findImmediatelyWrappingCall(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/angularjs/index/AngularJSIndexingHandler", "findImmediatelyWrappingCall"));
        }
        PsiElement current = property.getParent();
        int level = 0;
        while (current != null && current instanceof JSElement) {
            PsiElement callExpression;
            if (current instanceof JSProperty) {
                current = current.getParent();
                continue;
            }
            if (current instanceof JSObjectLiteralExpression) {
                ++level;
                current = current.getParent();
                continue;
            }
            if (current instanceof JSArgumentList && (callExpression = current.getParent()) instanceof JSCallExpression) {
                return Pair.create((Object)((JSCallExpression)callExpression), (Object)level);
            }
            return null;
        }
        return null;
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        StubIndexKey index;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/index/AngularJSIndexingHandler", "indexImplicitElement"));
        }
        String userID = element.getUserString();
        StubIndexKey stubIndexKey = index = userID != null ? (StubIndexKey)INDEXES.get((Object)userID) : null;
        if (index != null && sink != null) {
            sink.occurrence(index, (Object)element.getName());
            if (index != AngularSymbolIndex.KEY) {
                sink.occurrence(AngularSymbolIndex.KEY, (Object)element.getName());
            }
        }
        return false;
    }

    public JSElementIndexingData processJSDocComment(@NotNull JSDocComment comment, @Nullable JSElementIndexingData outData) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/angularjs/index/AngularJSIndexingHandler", "processJSDocComment"));
        }
        JSDocTag ngdocTag = null;
        JSDocTag nameTag = null;
        for (JSDocTag tag : comment.getTags()) {
            if ("ngdoc".equals(tag.getName())) {
                ngdocTag = tag;
                continue;
            }
            if (!"name".equals(tag.getName())) continue;
            nameTag = tag;
        }
        if (ngdocTag != null && nameTag != null) {
            String name;
            JSDocTagValue nameValue = nameTag.getValue();
            String string = name = nameValue != null ? nameValue.getText() : null;
            if (name != null) {
                name = name.substring(name.indexOf(58) + 1);
            }
            String ngdocValue = null;
            PsiElement nextSibling = ngdocTag.getNextSibling();
            if (nextSibling instanceof PsiWhiteSpace) {
                nextSibling = nextSibling.getNextSibling();
            }
            if (nextSibling != null && nextSibling.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA) {
                ngdocValue = nextSibling.getText();
            }
            if (ngdocValue != null && name != null) {
                String[] commentLines = StringUtil.splitByLines((String)comment.getText());
                boolean directive = ngdocValue.contains(DIRECTIVE);
                boolean component = ngdocValue.contains(COMPONENT);
                if (directive || component) {
                    String restrictions = AngularJSIndexingHandler.calculateRestrictions(commentLines, directive ? DEFAULT_RESTRICTIONS : "E");
                    if (outData == null) {
                        outData = new JSElementIndexingDataImpl();
                    }
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)comment, directive ? DIRECTIVE : COMPONENT, AngularDirectivesDocIndex.KEY, name, restrictions, outData);
                } else if (ngdocValue.contains(FILTER)) {
                    if (outData == null) {
                        outData = new JSElementIndexingDataImpl();
                    }
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)comment, FILTER, AngularFilterIndex.KEY, name, null, outData);
                }
            }
        }
        return outData;
    }

    private static String calculateRestrictions(String[] commentLines, String defaultRestrictions) {
        String restrict = defaultRestrictions;
        String tag = "";
        String param = "";
        StringBuilder attributes = new StringBuilder();
        for (String line : commentLines) {
            JSDocumentationUtils.DocTag docTag;
            restrict = AngularJSIndexingHandler.getParamValue(restrict, line, RESTRICT);
            tag = AngularJSIndexingHandler.getParamValue(tag, line, ELEMENT);
            int start = line.indexOf(PARAM);
            if (start < 0 || (docTag = JSDocumentationUtils.getDocTag((String)line.substring(start))) == null) continue;
            String string = param = docTag.matchValue != null ? docTag.matchValue : param;
            if (attributes.length() > 0) {
                attributes.append(",");
            }
            attributes.append(docTag.matchName);
        }
        return restrict + ";" + tag + ";" + param.trim() + ";" + attributes.toString().trim();
    }

    public static boolean isAngularRestrictions(@Nullable String restrictions) {
        return restrictions == null || StringUtil.countChars((CharSequence)restrictions, (char)';') >= 3;
    }

    static String getParamValue(String previousValue, String line, String docTag) {
        int indexOfTag = line.indexOf(docTag);
        if (indexOfTag >= 0) {
            int commentAtEndIndex = line.indexOf("//", indexOfTag);
            String newValue = line.substring(indexOfTag + docTag.length(), commentAtEndIndex > 0 ? commentAtEndIndex : line.length());
            if (!StringUtil.isEmpty((String)(newValue = newValue.trim()))) {
                return newValue;
            }
        }
        return previousValue;
    }

    private static void generateNamespace(@NotNull JSLiteralExpression argument, @NotNull JSElementIndexingData outData) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/angularjs/index/AngularJSIndexingHandler", "generateNamespace"));
        }
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJSIndexingHandler", "generateNamespace"));
        }
        String namespace = AngularJSIndexingHandler.unquote((PsiElement)argument);
        if (namespace == null) {
            return;
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName((String)namespace);
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder((JSQualifiedName)qName, (PsiElement)argument).setType(JSImplicitElement.Type.Class).setUserString(ANGULAR_SYMBOL_INDEX_USER_STRING);
        JSImplicitElementImpl implicitElement = elementBuilder.toImplicitElement();
        outData.addImplicitElement((JSImplicitElement)implicitElement);
    }

    private static void addImplicitElements(@NotNull JSImplicitElementProvider elementProvider, @Nullable String command, @NotNull StubIndexKey<String, JSImplicitElementProvider> index, @Nullable String defaultName, @Nullable String value, @NotNull JSElementIndexingData outData) {
        String name;
        if (elementProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementProvider", "org/angularjs/index/AngularJSIndexingHandler", "addImplicitElements"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/angularjs/index/AngularJSIndexingHandler", "addImplicitElements"));
        }
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJSIndexingHandler", "addImplicitElements"));
        }
        if (defaultName == null) {
            return;
        }
        List keys = INDEXES.getKeysByValue(index);
        assert (keys != null && keys.size() == 1);
        Consumer adder = builder -> {
            if (elementProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementProvider", "org/angularjs/index/AngularJSIndexingHandler", "lambda$addImplicitElements$4"));
            }
            if (outData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJSIndexingHandler", "lambda$addImplicitElements$4"));
            }
            builder.setType(elementProvider instanceof JSDocComment ? JSImplicitElement.Type.Tag : JSImplicitElement.Type.Class).setTypeString(value);
            builder.setUserString((String)keys.get(0));
            JSImplicitElementImpl implicitElement = builder.toImplicitElement();
            outData.addImplicitElement((JSImplicitElement)implicitElement);
        };
        Function<String, List<String>> variants = POLY_NAME_CONVERTERS.get(command);
        Function<String, String> converter = command != null ? NAME_CONVERTERS.get(command) : null;
        String string = name = converter != null ? (String)converter.fun((Object)defaultName) : defaultName;
        if (variants != null) {
            List strings = (List)variants.fun((Object)name);
            for (String string2 : strings) {
                adder.consume((Object)new JSImplicitElementImpl.Builder(string2, (PsiElement)elementProvider));
            }
        } else {
            adder.consume((Object)new JSImplicitElementImpl.Builder((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName((String)name), (PsiElement)elementProvider));
        }
        if (!StringUtil.equals((CharSequence)defaultName, (CharSequence)name)) {
            JSImplicitElementImpl.Builder symbolElementBuilder = new JSImplicitElementImpl.Builder(defaultName, (PsiElement)elementProvider).setType(elementProvider instanceof JSDocComment ? JSImplicitElement.Type.Tag : JSImplicitElement.Type.Class).setTypeString(value);
            List symbolKeys = INDEXES.getKeysByValue(AngularSymbolIndex.KEY);
            assert (symbolKeys != null && symbolKeys.size() == 1);
            symbolElementBuilder.setUserString((String)symbolKeys.get(0));
            JSImplicitElementImpl implicitElement2 = symbolElementBuilder.toImplicitElement();
            outData.addImplicitElement((JSImplicitElement)implicitElement2);
        }
    }

    private static String calculateRestrictions(PsiElement element, String defaultRestrictions) {
        final Ref restrict = Ref.create((Object)defaultRestrictions);
        final Ref scope = Ref.create((Object)"");
        PsiElement function = AngularJSIndexingHandler.findFunction(element);
        if (function != null) {
            function.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSProperty(JSProperty node) {
                    String name = node.getName();
                    JSExpression value = node.getValue();
                    if ("restrict".equals(name)) {
                        String unquoted;
                        if (value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral() && (unquoted = AngularJSIndexingHandler.unquote((PsiElement)value)) != null) {
                            restrict.set((Object)unquoted);
                        }
                    } else if ("scope".equals(name) && value instanceof JSObjectLiteralExpression) {
                        scope.set((Object)StringUtil.join((Object[])((JSObjectLiteralExpression)value).getProperties(), PsiNamedElement::getName, (String)","));
                    }
                }
            });
        }
        return ((String)restrict.get()).trim() + ";;;" + (String)scope.get();
    }

    private static PsiElement findFunction(PsiElement element) {
        JSArrayLiteralExpression array;
        PsiElement function = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSFunction.class);
        if (function == null) {
            function = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSObjectLiteralExpression.class);
        }
        if (function == null) {
            JSExpression expression = (JSExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSExpression.class);
            function = AngularJSIndexingHandler.findDeclaredFunction(expression);
        }
        if (function == null && (function = PsiTreeUtil.findChildOfType((PsiElement)(array = (JSArrayLiteralExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, JSArrayLiteralExpression.class)), JSFunction.class)) == null) {
            JSExpression candidate = array != null ? (JSExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)array.getLastChild(), JSExpression.class) : null;
            function = AngularJSIndexingHandler.findDeclaredFunction(candidate);
        }
        return function;
    }

    private static PsiElement findDeclaredFunction(JSExpression expression) {
        String name;
        String string = name = expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceName() : null;
        if (name != null) {
            CompositeElement definition;
            ASTNode node = expression.getNode();
            JSTreeUtil.JSScopeDeclarationsAndAssignments declaration = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp((String)name, (ASTNode)node);
            CompositeElement compositeElement = definition = declaration != null ? declaration.findNearestDefinition(node) : null;
            if (definition != null) {
                return definition.getPsi();
            }
        }
        return null;
    }

    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        if (!(objectLiteralExpression.getParent() instanceof JSReturnStatement)) {
            return null;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)objectLiteralExpression, JSFunction.class);
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)function, JSCallExpression.class);
        if (call != null) {
            JSExpression argument;
            JSExpression[] arguments;
            JSExpression methodExpression = call.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return null;
            }
            JSReferenceExpression callee = (JSReferenceExpression)methodExpression;
            JSExpression qualifier = callee.getQualifier();
            if (qualifier == null) {
                return null;
            }
            String command = callee.getReferencedName();
            if (INJECTABLE_METHODS.contains(command) && (arguments = call.getArguments()).length > 0 && (argument = arguments[0]) instanceof JSLiteralExpression && ((JSLiteralExpression)argument).isQuotedLiteral()) {
                return AngularJSIndexingHandler.unquote((PsiElement)argument);
            }
        }
        return null;
    }

    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement resolveResult, boolean hasSomeType) {
        PsiElement resolveParent;
        if (!AngularIndexUtil.hasAngularJS(resolveResult.getProject())) {
            return false;
        }
        if (resolveResult instanceof JSDefinitionExpression && resolveResult.getLanguage() instanceof AngularJSLanguage && (resolveParent = resolveResult.getParent()) instanceof AngularJSAsExpression) {
            String name = resolveParent.getFirstChild().getText();
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult);
            JSType type = JSNamedType.createType((String)name, (JSTypeSource)source, (JSContext)JSContext.INSTANCE);
            evaluator.addType(type, resolveResult);
            return true;
        }
        if (resolveResult instanceof JSVariable && resolveResult.getLanguage() instanceof AngularJSLanguage && (resolveParent = resolveResult.getParent().getParent()) instanceof AngularJSRepeatExpression && AngularJSIndexingHandler.calculateRepeatParameterType(evaluator, (AngularJSRepeatExpression)resolveParent)) {
            return true;
        }
        if (resolveResult instanceof JSParameter && evaluator.isFromCurrentFile(resolveResult) && AngularJSIndexingHandler.isInjectable(resolveResult)) {
            String name = ((JSParameter)resolveResult).getName();
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult);
            JSType type = JSNamedType.createType((String)name, (JSTypeSource)source, (JSContext)JSContext.UNKNOWN);
            evaluator.addType(type, resolveResult);
        }
        return false;
    }

    public int getVersion() {
        return 58;
    }

    private static boolean calculateRepeatParameterType(JSTypeEvaluator evaluator, AngularJSRepeatExpression resolveParent) {
        PsiElement last = AngularJSIndexingHandler.findReferenceExpression(resolveParent);
        JSExpression arrayExpression = null;
        if (last instanceof JSReferenceExpression) {
            PsiElement resolve = ((JSReferenceExpression)last).resolve();
            if (resolve != null) {
                JSType type;
                if (resolve instanceof JSTypeDeclarationOwner && (type = ((JSTypeDeclarationOwner)resolve).getType()) != null) {
                    return evaluator.addComponentTypeFromProcessor((JSExpression)last, type) != null;
                }
                if ((resolve = JSPsiImplUtils.getAssignedExpression((PsiElement)resolve)) != null) {
                    arrayExpression = (JSExpression)resolve;
                }
            }
        } else if (last instanceof JSExpression) {
            arrayExpression = (JSExpression)last;
        }
        if (last != null && arrayExpression != null) {
            return evaluator.addComponentTypeFromArrayExpression((JSExpression)resolveParent, arrayExpression) != null;
        }
        return false;
    }

    private static PsiElement findReferenceExpression(AngularJSRepeatExpression parent) {
        JSExpression collection = parent.getCollection();
        while (collection instanceof JSBinaryExpression && ((JSBinaryExpression)collection).getROperand() instanceof AngularJSFilterExpression) {
            collection = ((JSBinaryExpression)collection).getLOperand();
        }
        return collection;
    }

    private static PairProcessor<JSProperty, JSElementIndexingData> createRouterParametersProcessor() {
        return new PairProcessor<JSProperty, JSElementIndexingData>(){

            public boolean process(JSProperty property, JSElementIndexingData outData) {
                if (!(property.getValue() instanceof JSLiteralExpression)) {
                    return true;
                }
                JSLiteralExpression value = (JSLiteralExpression)property.getValue();
                if (!value.isQuotedLiteral()) {
                    return true;
                }
                String unquotedValue = AngularJSIndexingHandler.unquote((PsiElement)value);
                if ("controllerAs".equals(property.getName())) {
                    return this.recordControllerAs(property, outData, value, unquotedValue);
                }
                if (AngularJSIndexingHandler.CONTROLLER.equals(property.getName())) {
                    int idx;
                    int n = idx = unquotedValue != null ? unquotedValue.indexOf(AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES) : 0;
                    if (idx > 0 && idx + AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES.length() < unquotedValue.length() - 1) {
                        return this.recordControllerAs(property, outData, value, unquotedValue.substring(idx + AngularJSIndexingHandler.AS_CONNECTOR_WITH_SPACES.length(), unquotedValue.length()));
                    }
                } else if ("name".equals(property.getName())) {
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)value, AngularJSIndexingHandler.STATE, (StubIndexKey<String, JSImplicitElementProvider>)((StubIndexKey)INDEXERS.get(AngularJSIndexingHandler.STATE)), unquotedValue, null, outData);
                    return true;
                }
                return true;
            }

            private boolean recordControllerAs(JSProperty property, JSElementIndexingData outData, JSLiteralExpression value, String unquotedValue) {
                StubIndexKey index = (StubIndexKey)INDEXERS.get(AngularJSIndexingHandler.CONTROLLER);
                assert (index != null);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)property.getParent(), JSObjectLiteralExpression.class);
                if (object == null) {
                    return false;
                }
                JSProperty controllerProperty = object.findProperty(AngularJSIndexingHandler.CONTROLLER);
                if (controllerProperty != null) {
                    AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)controllerProperty, null, (StubIndexKey<String, JSImplicitElementProvider>)index, unquotedValue, null, outData);
                    return true;
                }
                AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)value, null, (StubIndexKey<String, JSImplicitElementProvider>)index, unquotedValue, null, outData);
                return true;
            }
        };
    }

    @Nullable
    static String unquote(PsiElement value) {
        return (String)((JSLiteralExpression)value).getValue();
    }

    private static boolean bindingsProcessor(JSProperty property, JSElementIndexingData data) {
        PsiElement parent = property.getParent();
        if (parent instanceof JSObjectLiteralExpression && parent.getParent() instanceof JSProperty && BINDINGS.equals(((JSProperty)parent.getParent()).getName())) {
            Pair<JSCallExpression, Integer> call = AngularJSIndexingHandler.findImmediatelyWrappingCall(property);
            assert (call != null);
            JSExpression[] arguments = ((JSCallExpression)call.first).getArguments();
            if (arguments.length < 2 || !(arguments[0] instanceof JSLiteralExpression) || !((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                return false;
            }
            String componentName = AngularJSIndexingHandler.unquote((PsiElement)arguments[0]);
            AngularJSIndexingHandler.addImplicitElements((JSImplicitElementProvider)property, BINDINGS, AngularDirectivesDocIndex.KEY, DirectiveUtil.getAttributeName(property.getName()), "A;" + DirectiveUtil.getAttributeName(componentName) + ";expression;", data);
            return true;
        }
        return false;
    }

    static {
        Collections.addAll(INTERESTING_METHODS, "service", "factory", "value", "constant", "provider");
        INJECTABLE_METHODS.addAll(INTERESTING_METHODS);
        Collections.addAll(INJECTABLE_METHODS, CONTROLLER, DIRECTIVE, COMPONENT, MODULE, "config", "run");
        INDEXERS.put(DIRECTIVE, AngularDirectivesIndex.KEY);
        NAME_CONVERTERS.put(DIRECTIVE, (Function<String, String>)((Function)DirectiveUtil::getAttributeName));
        DATA_CALCULATORS.put(DIRECTIVE, (Function<PsiElement, String>)((Function)element -> AngularJSIndexingHandler.calculateRestrictions(element, DEFAULT_RESTRICTIONS)));
        INDEXERS.put(COMPONENT, AngularDirectivesIndex.KEY);
        NAME_CONVERTERS.put(COMPONENT, NAME_CONVERTERS.get(DIRECTIVE));
        DATA_CALCULATORS.put(COMPONENT, (Function<PsiElement, String>)((Function)element -> AngularJSIndexingHandler.calculateRestrictions(element, "E")));
        INDEXERS.put(CONTROLLER, AngularControllerIndex.KEY);
        INDEXERS.put(MODULE, AngularModuleIndex.KEY);
        INDEXERS.put(FILTER, AngularFilterIndex.KEY);
        INDEXERS.put(STATE, AngularUiRouterStatesIndex.KEY);
        THashSet allInterestingMethods = new THashSet(INTERESTING_METHODS);
        allInterestingMethods.addAll(INJECTABLE_METHODS);
        allInterestingMethods.addAll(INDEXERS.keySet());
        allInterestingMethods.add((Object)START_SYMBOL);
        allInterestingMethods.add((Object)END_SYMBOL);
        ALL_INTERESTING_METHODS = ArrayUtil.toStringArray((Collection)allInterestingMethods);
        INDEXES = new BidirectionalMap();
        INDEXES.put((Object)"aci", AngularControllerIndex.KEY);
        INDEXES.put((Object)"addi", AngularDirectivesDocIndex.KEY);
        INDEXES.put((Object)ANGULAR_DIRECTIVES_INDEX_USER_STRING, AngularDirectivesIndex.KEY);
        INDEXES.put((Object)ANGULAR_FILTER_INDEX_USER_STRING, AngularFilterIndex.KEY);
        INDEXES.put((Object)"aidi", AngularInjectionDelimiterIndex.KEY);
        INDEXES.put((Object)ANGULAR_MODULE_INDEX_USER_STRING, AngularModuleIndex.KEY);
        INDEXES.put((Object)ANGULAR_SYMBOL_INDEX_USER_STRING, AngularSymbolIndex.KEY);
        INDEXES.put((Object)"arsi", AngularUiRouterStatesIndex.KEY);
        INDEXES.put((Object)"arsgi", AngularUiRouterGenericStatesIndex.KEY);
        INDEXES.put((Object)"agmi", AngularGenericModulesIndex.KEY);
        for (String key : INDEXES.keySet()) {
            JSImplicitElement.ourUserStringsRegistry.registerUserString(key);
        }
        CUSTOM_PROPERTY_PROCESSORS.put(COMPONENT, (PairProcessor<JSProperty, JSElementIndexingData>)((PairProcessor)AngularJSIndexingHandler::bindingsProcessor));
        NAME_CONVERTERS.put(BINDINGS, NAME_CONVERTERS.get(DIRECTIVE));
        PairProcessor<JSProperty, JSElementIndexingData> processor = AngularJSIndexingHandler.createRouterParametersProcessor();
        CUSTOM_PROPERTY_PROCESSORS.put(WHEN, processor);
        CUSTOM_PROPERTY_PROCESSORS.put("otherwise", processor);
        CUSTOM_PROPERTY_PROCESSORS.put(STATE, processor);
        POLY_NAME_CONVERTERS.put(STATE, (Function<String, List<String>>)((NotNullFunction)dom -> {
            String[] parts = dom.split("\\.");
            ArrayList<String> result = new ArrayList<String>();
            result.add((String)dom);
            String tail = "";
            for (int i = parts.length - 1; i > 0; --i) {
                String part = "." + parts[i] + tail;
                result.add(part);
                tail = part;
            }
            return result;
        }));
        POLY_NAME_CONVERTERS.put(MODULE, (Function<String, List<String>>)((Function)Collections::singletonList));
        ARGUMENT_LIST_CHECKERS.put(MODULE, (Processor<JSArgumentList>)((Processor)list -> list.getArguments().length > 1));
    }
}

