/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.angularjs.index.AngularTemplateIndexInputFilter;
import org.jetbrains.annotations.NotNull;

public class AngularTemplateCacheIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> TEMPLATE_CACHE_INDEX = ID.create((String)"angularjs.template.cache");
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = TEMPLATE_CACHE_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularTemplateCacheIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularTemplateCacheIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularTemplateCacheIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        AngularTemplateIndexInputFilter angularTemplateIndexInputFilter = AngularTemplateIndexInputFilter.INSTANCE;
        if (angularTemplateIndexInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularTemplateCacheIndex", "getInputFilter"));
        }
        return angularTemplateIndexInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 58;
    }

    public static void processTemplates(PsiFile psiFile, final Processor<XmlAttribute> processor) {
        if (psiFile instanceof XmlFile) {
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    XmlAttribute id;
                    if (HtmlUtil.isScriptTag((XmlTag)tag) && "text/ng-template".equals(tag.getAttributeValue("type")) && (id = tag.getAttribute("id")) != null) {
                        processor.process((Object)id);
                        return;
                    }
                    super.visitXmlTag(tag);
                }
            });
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/angularjs/index/AngularTemplateCacheIndex$MyDataIndexer", "map"));
            }
            THashMap result = new THashMap();
            PsiFile psiFile = inputData.getPsiFile();
            AngularTemplateCacheIndex.processTemplates(psiFile, (Processor<XmlAttribute>)((Processor)arg_0 -> MyDataIndexer.lambda$map$0((Map)result, arg_0)));
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularTemplateCacheIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }

        private static /* synthetic */ boolean lambda$map$0(Map result, XmlAttribute attribute) {
            result.put(attribute.getValue(), null);
            return true;
        }
    }
}

