/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.service;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetErrCommand;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.service.protocol.Angular2LanguageServiceProtocol;
import org.angularjs.service.protocol.command.Angular2CompletionsCommand;
import org.angularjs.service.protocol.command.Angular2GetHtmlErrorCommand;
import org.angularjs.service.protocol.command.Angular2GetProjectHtmlErrCommand;
import org.angularjs.settings.AngularSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2LanguageService
extends TypeScriptServerServiceImpl {
    private static final ParameterizedCachedValueProvider<VirtualFile, Project> CACHE_SERVICE_PATH_PROVIDER = new ParameterizedCachedValueProvider<VirtualFile, Project>(){

        @Nullable
        public CachedValueProvider.Result<VirtualFile> compute(Project project) {
            VirtualFile result = Angular2LanguageService.findServiceDirectoryImpl(project);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER});
        }
    };
    public static final Key<ParameterizedCachedValue<VirtualFile, Project>> NG_SERVICE_PATH_KEY = Key.create((String)"CACHED_NG_SERVICE_PATH");
    private final Condition<VirtualFile> myFileFilter;

    public Angular2LanguageService(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/service/Angular2LanguageService", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/angularjs/service/Angular2LanguageService", "<init>"));
        }
        super(project, settings, "Angular Console");
        this.myFileFilter = Conditions.or((Condition)super.getAcceptableFilesFilter(), el -> el != null && el.isInLocalFileSystem() && el.getFileType() == HtmlFileType.INSTANCE);
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile directory = Angular2LanguageService.getServiceDirectory(this.myProject);
        if (directory == null) {
            return null;
        }
        String path = directory.getCanonicalPath();
        if (path == null) {
            return null;
        }
        return new Angular2LanguageServiceProtocol(this.myProject, path, this.mySettings, readyConsumer);
    }

    public static VirtualFile getServiceDirectory(Project project) {
        return (VirtualFile)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, NG_SERVICE_PATH_KEY, CACHE_SERVICE_PATH_PROVIDER, false, (Object)project);
    }

    @Nullable
    private static VirtualFile findServiceDirectoryImpl(Project project) {
        for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            VirtualFile serviceDirectory;
            VirtualFile angularPackage;
            VirtualFile modules;
            if (!file.isInLocalFileSystem() || !file.isDirectory() || (modules = file.findChild("node_modules")) == null || (angularPackage = modules.findChild("@angular")) == null || (serviceDirectory = angularPackage.findChild("language-service")) == null) continue;
            return serviceDirectory;
        }
        return null;
    }

    @NotNull
    protected TypeScriptGetErrCommand createGetErrCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/service/Angular2LanguageService", "createGetErrCommand"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/angularjs/service/Angular2LanguageService", "createGetErrCommand"));
        }
        if (file.getFileType() == HtmlFileType.INSTANCE) {
            Angular2GetHtmlErrorCommand angular2GetHtmlErrorCommand = new Angular2GetHtmlErrorCommand(path);
            if (angular2GetHtmlErrorCommand == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "createGetErrCommand"));
            }
            return angular2GetHtmlErrorCommand;
        }
        TypeScriptGetErrCommand typeScriptGetErrCommand = super.createGetErrCommand(file, path);
        if (typeScriptGetErrCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "createGetErrCommand"));
        }
        return typeScriptGetErrCommand;
    }

    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/service/Angular2LanguageService", "canHighlight"));
        }
        if (file instanceof HtmlFileImpl) {
            return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable((Project)this.myProject, (JSLanguageServiceBase)this, (TypeScriptCompilerSettings)this.mySettings);
        }
        return super.canHighlight(file);
    }

    @NotNull
    protected String getProcessName() {
        if ("Angular" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "getProcessName"));
        }
        return "Angular";
    }

    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "getAcceptableFilesFilter"));
        }
        return condition;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/angularjs/service/Angular2LanguageService", "createCompletionCommand"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/angularjs/service/Angular2LanguageService", "createCompletionCommand"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/service/Angular2LanguageService", "createCompletionCommand"));
        }
        Angular2CompletionsCommand angular2CompletionsCommand = file instanceof XmlFile || virtualFile.getFileType() instanceof XmlLikeFileType ? new Angular2CompletionsCommand(args) : super.createCompletionCommand(args, virtualFile, file);
        if (angular2CompletionsCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "createCompletionCommand"));
        }
        return angular2CompletionsCommand;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/service/Angular2LanguageService", "createProjectCommand"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/angularjs/service/Angular2LanguageService", "createProjectCommand"));
        }
        FileType type = file.getFileType();
        Angular2GetProjectHtmlErrCommand angular2GetProjectHtmlErrCommand = type instanceof XmlLikeFileType ? new Angular2GetProjectHtmlErrCommand(path) : super.createProjectCommand(file, path);
        if (angular2GetProjectHtmlErrCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/service/Angular2LanguageService", "createProjectCommand"));
        }
        return angular2GetProjectHtmlErrCommand;
    }

    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        TypeScriptCompilerService defaultService = TypeScriptCompilerService.getDefaultService((Project)this.myProject);
        if (defaultService.isServiceCreated()) {
            JSLanguageServiceQueue.LOGGER.info("Dispose default service by " + this.getProcessName());
            TransactionGuard.submitTransaction((Disposable)this, () -> defaultService.terminateStartedProcess(false));
        }
        return super.createLanguageServiceQueue();
    }

    public static boolean isEnabledAngularService(Project project) {
        return AngularSettings.get(project).isUseService() && AngularIndexUtil.hasAngularJS2(project) && Angular2LanguageService.getServiceDirectory(project) != null;
    }

    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return AngularSettings.get(this.myProject);
    }
}

