/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class ArquillianMavenLibraryModel
extends ArquillianLibraryModel {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private String version;
    private boolean downloadSources;
    private boolean downloadJavaDocs;

    public ArquillianMavenLibraryModel(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "<init>"));
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArquillianMavenLibraryModel(ArquillianMavenLibraryState state) {
        this.groupId = state.groupId;
        this.artifactId = state.artifactId;
        this.version = state.version;
        this.downloadSources = state.downloadSources;
        this.downloadJavaDocs = state.downloadJavaDocs;
    }

    @Override
    public boolean hasChanges(ArquillianLibraryState state) {
        if (!(state instanceof ArquillianMavenLibraryState)) {
            return true;
        }
        ArquillianMavenLibraryState mavenLibraryState = (ArquillianMavenLibraryState)state;
        return !this.groupId.equals(mavenLibraryState.groupId) || !this.artifactId.equals(mavenLibraryState.artifactId) || !this.version.equals(mavenLibraryState.version) || this.downloadSources != mavenLibraryState.downloadSources || this.downloadJavaDocs != mavenLibraryState.downloadJavaDocs;
    }

    @Override
    public ArquillianMavenLibraryState getCurrentState() {
        return new ArquillianMavenLibraryState(this.groupId, this.artifactId, this.version, this.downloadSources, this.downloadJavaDocs);
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "getArtifactId"));
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "getVersion"));
        }
        return string;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel", "setVersion"));
        }
        this.version = version;
        this.notifyMeChanged();
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
        this.notifyMeChanged();
    }

    public boolean isDownloadJavaDocs() {
        return this.downloadJavaDocs;
    }

    public void setDownloadJavaDocs(boolean downloadJavaDocs) {
        this.downloadJavaDocs = downloadJavaDocs;
        this.notifyMeChanged();
    }

    @Override
    public String getDescription() {
        return RepositoryLibraryDescription.findDescription((String)this.groupId, (String)this.artifactId).getDisplayName(this.version);
    }

    @Override
    public Icon getIcon() {
        return RepositoryLibraryType.getInstance().getIcon(new RepositoryLibraryProperties(this.groupId, this.artifactId, this.version));
    }

    @Override
    public void editProperties(Project project) {
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(this.version, this.downloadSources, this.downloadJavaDocs);
        RepositoryLibraryDescription libraryDescription = RepositoryLibraryDescription.findDescription((String)this.groupId, (String)this.artifactId);
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(project, model, libraryDescription, true, false);
        if (!dialog.showAndGet()) {
            return;
        }
        this.version = model.getVersion();
        this.downloadSources = model.isDownloadSources();
        this.downloadJavaDocs = model.isDownloadJavaDocs();
        this.notifyMeChanged();
        JarRepositoryManager.loadDependenciesAsync((Project)project, (RepositoryLibraryProperties)new RepositoryLibraryProperties(this.groupId, this.artifactId, this.version), (boolean)this.downloadSources, (boolean)this.downloadJavaDocs, null, null, null);
    }
}

