/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class SwitchCodegen {
    protected final KtWhenExpression expression;
    protected final boolean isStatement;
    protected final boolean isExhaustive;
    protected final ExpressionCodegen codegen;
    protected final BindingContext bindingContext;
    protected final Type subjectType;
    protected final Type resultType;
    protected final InstructionAdapter v;
    protected final NavigableMap<Integer, Label> transitionsTable;
    protected final List<Label> entryLabels;
    protected Label elseLabel;
    protected Label endLabel;
    protected Label defaultLabel;

    public SwitchCodegen(@NotNull KtWhenExpression expression2, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen, @Nullable Type subjectType) {
        if (expression2 == null) {
            SwitchCodegen.$$$reportNull$$$0(0);
        }
        if (codegen == null) {
            SwitchCodegen.$$$reportNull$$$0(1);
        }
        this.transitionsTable = new TreeMap<Integer, Label>();
        this.entryLabels = new ArrayList<Label>();
        this.elseLabel = new Label();
        this.endLabel = new Label();
        this.expression = expression2;
        this.isStatement = isStatement;
        this.isExhaustive = isExhaustive;
        this.codegen = codegen;
        this.bindingContext = codegen.getBindingContext();
        this.subjectType = subjectType != null ? subjectType : codegen.expressionType(expression2.getSubjectExpression());
        this.resultType = isStatement ? Type.VOID_TYPE : codegen.expressionType(expression2);
        this.v = codegen.v;
    }

    public void generate() {
        this.prepareConfiguration();
        boolean hasElse = this.expression.getElseExpression() != null;
        this.defaultLabel = hasElse || !this.isStatement || this.isExhaustive ? this.elseLabel : this.endLabel;
        this.generateSubject();
        this.generateSwitchInstructionByTransitionsTable();
        this.generateEntries();
        if (!(hasElse || this.isStatement && !this.isExhaustive)) {
            this.v.visitLabel(this.elseLabel);
            this.codegen.putUnitInstanceOntoStackForNonExhaustiveWhen(this.expression, this.isStatement);
        }
        this.codegen.markLineNumber(this.expression, this.isStatement);
        this.v.mark(this.endLabel);
    }

    private void prepareConfiguration() {
        for (KtWhenEntry entry : this.expression.getEntries()) {
            Label entryLabel = new Label();
            for (ConstantValue<?> constant : SwitchCodegenUtil.getConstantsFromEntry(entry, this.bindingContext, this.codegen.getState().getShouldInlineConstVals())) {
                if (constant instanceof NullValue) continue;
                this.processConstant(constant, entryLabel);
            }
            if (entry.isElse()) {
                this.elseLabel = entryLabel;
            }
            this.entryLabels.add(entryLabel);
        }
    }

    protected abstract void processConstant(@NotNull ConstantValue<?> var1, @NotNull Label var2);

    protected void putTransitionOnce(int value, @NotNull Label entryLabel) {
        if (entryLabel == null) {
            SwitchCodegen.$$$reportNull$$$0(2);
        }
        if (!this.transitionsTable.containsKey(value)) {
            this.transitionsTable.put(value, entryLabel);
        }
    }

    protected void generateSubject() {
        this.codegen.gen(this.expression.getSubjectExpression(), this.subjectType);
    }

    protected void generateNullCheckIfNeeded() {
        assert (this.expression.getSubjectExpression() != null) : "subject expression can't be null";
        KotlinType subjectJetType = this.bindingContext.getType(this.expression.getSubjectExpression());
        assert (subjectJetType != null) : "subject type can't be null (i.e. void)";
        if (TypeUtils.isNullableType(subjectJetType)) {
            int nullEntryIndex = this.findNullEntryIndex(this.expression);
            Label nullLabel = nullEntryIndex == -1 ? this.defaultLabel : this.entryLabels.get(nullEntryIndex);
            Label notNullLabel = new Label();
            this.v.dup();
            this.v.ifnonnull(notNullLabel);
            this.v.pop();
            this.v.goTo(nullLabel);
            this.v.visitLabel(notNullLabel);
        }
    }

    private int findNullEntryIndex(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            SwitchCodegen.$$$reportNull$$$0(3);
        }
        int entryIndex = 0;
        for (KtWhenEntry entry : expression2.getEntries()) {
            for (ConstantValue<?> constant : SwitchCodegenUtil.getConstantsFromEntry(entry, this.bindingContext, this.codegen.getState().getShouldInlineConstVals())) {
                if (!(constant instanceof NullValue)) continue;
                return entryIndex;
            }
            ++entryIndex;
        }
        return -1;
    }

    private void generateSwitchInstructionByTransitionsTable() {
        boolean useTableSwitch;
        int[] keys = new int[this.transitionsTable.size()];
        Label[] labels2 = new Label[this.transitionsTable.size()];
        int i = 0;
        for (Map.Entry transition : this.transitionsTable.entrySet()) {
            keys[i] = (Integer)transition.getKey();
            labels2[i] = (Label)transition.getValue();
            ++i;
        }
        int nlabels = keys.length;
        int hi = keys[nlabels - 1];
        int lo = keys[0];
        long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
        long table_time_cost = 3L;
        long lookup_space_cost = 3L + 2L * (long)nlabels;
        long lookup_time_cost = nlabels;
        boolean bl = useTableSwitch = nlabels > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost;
        if (!useTableSwitch) {
            this.v.lookupswitch(this.defaultLabel, keys, labels2);
            return;
        }
        Object[] sparseLabels = new Label[hi - lo + 1];
        Arrays.fill(sparseLabels, this.defaultLabel);
        for (i = 0; i < keys.length; ++i) {
            sparseLabels[keys[i] - lo] = labels2[i];
        }
        this.v.tableswitch(lo, hi, this.defaultLabel, (Label[])sparseLabels);
    }

    protected void generateEntries() {
        Iterator<Label> entryLabelsIterator = this.entryLabels.iterator();
        for (KtWhenEntry entry : this.expression.getEntries()) {
            this.v.visitLabel(entryLabelsIterator.next());
            FrameMap.Mark mark = this.codegen.myFrameMap.mark();
            this.codegen.gen(entry.getExpression(), this.resultType);
            mark.dropTo();
            if (entry.isElse()) continue;
            this.v.goTo(this.endLabel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryLabel";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/when/SwitchCodegen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "putTransitionOnce";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNullEntryIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

