/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import org.jetbrains.annotations.NotNull;

public final class CharPercentEscaper {
    private static final boolean[] safeOctets = CharPercentEscaper.createSafeOctets("-._~!$'()*,;&=@:+abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    private static boolean[] createSafeOctets(String safeChars) {
        char[] safeCharArray;
        int maxChar = -1;
        for (char c : safeCharArray = safeChars.toCharArray()) {
            maxChar = Math.max(c, maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c : safeCharArray) {
            octets[c] = true;
        }
        return octets;
    }

    public static boolean isSafe(char c) {
        return c < safeOctets.length && safeOctets[c];
    }

    public static void escape(int cp, @NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/debugger/CharPercentEscaper", "escape"));
        }
        if (cp <= 127) {
            builder.ensureCapacity(builder.length() + 3);
            builder.append('%');
            builder.append(UPPER_HEX_DIGITS[cp & 0xF]);
            builder.append(UPPER_HEX_DIGITS[cp >>> 4]);
        } else if (cp <= 2047) {
            char c5 = UPPER_HEX_DIGITS[cp & 0xF];
            char c4 = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            char c2 = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            char c1 = UPPER_HEX_DIGITS[0xC | (cp >>>= 4)];
            builder.ensureCapacity(builder.length() + 6);
            builder.append('%');
            builder.append(c1);
            builder.append(c2);
            builder.append('%');
            builder.append(c4);
            builder.append(c5);
        } else if (cp <= 65535) {
            char c8 = UPPER_HEX_DIGITS[cp & 0xF];
            char c7 = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            char c5 = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            char c4 = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            cp >>>= 2;
            builder.ensureCapacity(builder.length() + 9);
            builder.append('%');
            builder.append('E');
            builder.append(UPPER_HEX_DIGITS[cp]);
            builder.append('%');
            builder.append(c4);
            builder.append(c5);
            builder.append('%');
            builder.append(c7);
            builder.append(c8);
        } else if (cp <= 0x10FFFF) {
            char[] dest = new char[12];
            dest[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[10] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[8] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 7];
            builder.append(dest);
        } else {
            throw new IllegalArgumentException("Invalid unicode character value " + cp);
        }
    }
}

