/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.util.Url;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u001bH\u0007R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "", "()V", "scriptUrlToRelativePath", "Lgnu/trove/THashMap;", "Lcom/intellij/util/Url;", "", "getScriptUrlToRelativePath", "()Lgnu/trove/THashMap;", "scriptUrlToSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "getScriptUrlToSourceMap", "sourceMapUrlToSourceMap", "Lcom/intellij/util/containers/BidirectionalMap;", "add", "", "mapUrl", "map", "scriptUrl", "containsMap", "containsScript", "get", "url", "getByScript", "process", "", "procedure", "Lgnu/trove/TObjectObjectProcedure;", "JavaScriptDebugger"})
public final class PreloadedSourceMapList {
    @NotNull
    private final THashMap<Url, SourceMap> scriptUrlToSourceMap = new THashMap();
    private final BidirectionalMap<Url, SourceMap> sourceMapUrlToSourceMap = new BidirectionalMap();
    @NotNull
    private final THashMap<Url, String> scriptUrlToRelativePath = new THashMap();

    @NotNull
    public final THashMap<Url, SourceMap> getScriptUrlToSourceMap() {
        return this.scriptUrlToSourceMap;
    }

    @NotNull
    public final THashMap<Url, String> getScriptUrlToRelativePath() {
        return this.scriptUrlToRelativePath;
    }

    public final synchronized boolean add(@NotNull Url mapUrl, @NotNull SourceMap map, @NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)mapUrl, (String)"mapUrl");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        if (this.scriptUrlToSourceMap.containsKey((Object)scriptUrl)) {
            return false;
        }
        this.sourceMapUrlToSourceMap.put((Object)mapUrl, (Object)map);
        this.scriptUrlToSourceMap.put((Object)scriptUrl, (Object)map);
        return true;
    }

    @Nullable
    public final synchronized SourceMap get(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return (SourceMap)this.sourceMapUrlToSourceMap.get((Object)url);
    }

    @Nullable
    public final synchronized SourceMap getByScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return (SourceMap)this.scriptUrlToSourceMap.get((Object)scriptUrl);
    }

    public final synchronized boolean containsMap(@NotNull SourceMap map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        return this.sourceMapUrlToSourceMap.containsValue((Object)map);
    }

    public final synchronized boolean containsScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.containsKey((Object)scriptUrl);
    }

    public final synchronized void process(@NotNull TObjectObjectProcedure<Url, SourceMap> procedure) {
        Intrinsics.checkParameterIsNotNull(procedure, (String)"procedure");
        this.scriptUrlToSourceMap.forEachEntry(procedure);
    }
}

