/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.AsarKt;
import com.intellij.util.io.DirectoryItem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.Item;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/io/AsarFileSystem;", "", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "root", "", "", "Lcom/intellij/util/io/Item;", "vfsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVfsRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVfsRoot", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDir", "Lcom/intellij/util/io/DirectoryItem;", "path", "getFile", "Lcom/intellij/util/io/FileItem;", "loadBytes", "", "item", "loadText", "", "openFileChannel", "Ljava/nio/channels/SeekableByteChannel;", "kotlin.jvm.PlatformType", "JavaScriptDebugger"})
public final class AsarFileSystem {
    private final Map<String, Item> root;
    @Nullable
    private VirtualFile vfsRoot;
    private final Path file;

    @Nullable
    public final VirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public final void setVfsRoot(@Nullable VirtualFile virtualFile) {
        this.vfsRoot = virtualFile;
    }

    @Nullable
    public final CharSequence loadText(@NotNull String path) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileItem fileItem = this.getFile(path);
        if (fileItem != null) {
            FileItem fileItem2;
            FileItem it = fileItem2 = fileItem;
            charSequence = this.loadText(it);
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CharSequence loadText(@NotNull FileItem item) {
        Closeable closeable;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable closeable2 = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean bl = false;
        try {
            Closeable closeable3;
            CharSequence charSequence2;
            SeekableByteChannel it = (SeekableByteChannel)closeable2;
            it.position(item.getOffset());
            Closeable closeable4 = Channels.newInputStream(it);
            boolean bl2 = false;
            try {
                InputStream it2;
                InputStream inputStream = it2 = (InputStream)closeable4;
                Charset charset = Charsets.UTF_8;
                charSequence2 = IoKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)item.getSize());
                closeable3 = closeable4;
            }
            catch (Exception exception) {
                try {
                    bl2 = true;
                    try {
                        Closeable closeable5 = closeable4;
                        if (closeable5 != null) {
                            closeable5.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                catch (Throwable throwable) {
                    if (!bl2) {
                        Closeable closeable6 = closeable4;
                        if (closeable6 != null) {
                            closeable6.close();
                        }
                    }
                    throw throwable;
                }
            }
            if (closeable3 != null) {
                closeable3.close();
            }
            charSequence = charSequence2;
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable7 = closeable2;
                    if (closeable7 != null) {
                        closeable7.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable8 = closeable2;
                    if (closeable8 != null) {
                        closeable8.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] loadBytes(@NotNull FileItem item) {
        Closeable closeable;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable closeable2 = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean bl = false;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable2;
            it.position(item.getOffset());
            ByteBuffer buffer = ByteBuffer.allocate(item.getSize());
            do {
                it.read(buffer);
            } while (buffer.remaining() > 0);
            byte[] byArray2 = buffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"buffer.array()");
            byArray = byArray2;
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.newByteChannel(fil\u2026     buffer.array()\n    }");
        return byArray;
    }

    @Nullable
    public final FileItem getFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof FileItem)) {
            item = null;
        }
        return (FileItem)item;
    }

    @Nullable
    public final DirectoryItem getDir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof DirectoryItem)) {
            item = null;
        }
        return (DirectoryItem)item;
    }

    public final SeekableByteChannel openFileChannel() {
        return Files.newByteChannel(this.file, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsarFileSystem(@NotNull Path file) {
        LittleEndianDataInputStream littleEndianDataInputStream;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        THashMap root = null;
        Closeable closeable = Files.newInputStream(this.file, new OpenOption[0]);
        LittleEndianDataInputStream littleEndianDataInputStream2 = littleEndianDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream3 = littleEndianDataInputStream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        littleEndianDataInputStream2((InputStream)bufferedInputStream);
        closeable = (Closeable)littleEndianDataInputStream3;
        n = 0;
        try {
            JsonReader jsonReader;
            LittleEndianDataInputStream it = (LittleEndianDataInputStream)closeable;
            if (it.readInt() != 4) {
                throw (Throwable)new IOException("Incorrect header");
            }
            int headerSize = (int)UnsignedInts.toLong((int)it.readInt()) + 8;
            if (Files.size(this.file) < (long)headerSize) {
                throw (Throwable)new IOException("File size is less than specified header size");
            }
            it.readLong();
            InputStream inputStream = (InputStream)it;
            JsonReader jsonReader2 = jsonReader;
            JsonReader jsonReader3 = jsonReader;
            Charset charset = Charsets.UTF_8;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            jsonReader2((Reader)inputStreamReader);
            root = AsarKt.access$readItem(jsonReader3, headerSize);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            try {
                n = 1;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (n == 0) {
                    closeable.close();
                }
                throw throwable;
            }
        }
        closeable.close();
        THashMap tHashMap = root;
        if (tHashMap == null) {
            Intrinsics.throwNpe();
        }
        this.root = (Map)tHashMap;
    }
}

