/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public class MarshalQueryablePair<T1, T2>
implements MarshalQueryable<Pair<T1, T2>> {
    @Override
    public Marshaler<Pair<T1, T2>> createMarshaler(TypeReference<Pair<T1, T2>> managedType, int nativeType) {
        return new MarshalerPair(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Pair<T1, T2>> managedType, int nativeType) {
        return Pair.class.equals(managedType.getRawType());
    }

    private class MarshalerPair
    extends Marshaler<Pair<T1, T2>> {
        private final Class<? super Pair<T1, T2>> mClass;
        private final Constructor<Pair<T1, T2>> mConstructor;
        private final Marshaler<T1> mNestedTypeMarshalerFirst;
        private final Marshaler<T2> mNestedTypeMarshalerSecond;

        protected MarshalerPair(TypeReference<Pair<T1, T2>> typeReference, int nativeType) {
            ParameterizedType paramType;
            super(MarshalQueryablePair.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
            try {
                paramType = (ParameterizedType)typeReference.getType();
            }
            catch (ClassCastException e) {
                throw new AssertionError("Raw use of Pair is not supported", e);
            }
            Type actualTypeArgument = paramType.getActualTypeArguments()[0];
            TypeReference<?> actualTypeArgToken = TypeReference.createSpecializedTypeReference(actualTypeArgument);
            this.mNestedTypeMarshalerFirst = MarshalRegistry.getMarshaler(actualTypeArgToken, this.mNativeType);
            actualTypeArgument = paramType.getActualTypeArguments()[1];
            actualTypeArgToken = TypeReference.createSpecializedTypeReference(actualTypeArgument);
            this.mNestedTypeMarshalerSecond = MarshalRegistry.getMarshaler(actualTypeArgToken, this.mNativeType);
            try {
                this.mConstructor = this.mClass.getConstructor(Object.class, Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void marshal(Pair<T1, T2> value, ByteBuffer buffer) {
            if (value.first == null) {
                throw new UnsupportedOperationException("Pair#first must not be null");
            }
            if (value.second == null) {
                throw new UnsupportedOperationException("Pair#second must not be null");
            }
            this.mNestedTypeMarshalerFirst.marshal(value.first, buffer);
            this.mNestedTypeMarshalerSecond.marshal(value.second, buffer);
        }

        @Override
        public Pair<T1, T2> unmarshal(ByteBuffer buffer) {
            Object first = this.mNestedTypeMarshalerFirst.unmarshal(buffer);
            Object second = this.mNestedTypeMarshalerSecond.unmarshal(buffer);
            try {
                return this.mConstructor.newInstance(first, second);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public int getNativeSize() {
            int firstSize = this.mNestedTypeMarshalerFirst.getNativeSize();
            int secondSize = this.mNestedTypeMarshalerSecond.getNativeSize();
            if (firstSize != NATIVE_SIZE_DYNAMIC && secondSize != NATIVE_SIZE_DYNAMIC) {
                return firstSize + secondSize;
            }
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public int calculateMarshalSize(Pair<T1, T2> value) {
            int nativeSize = this.getNativeSize();
            if (nativeSize != NATIVE_SIZE_DYNAMIC) {
                return nativeSize;
            }
            int firstSize = this.mNestedTypeMarshalerFirst.calculateMarshalSize(value.first);
            int secondSize = this.mNestedTypeMarshalerSecond.calculateMarshalSize(value.second);
            return firstSize + secondSize;
        }
    }
}

