/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

public class MotionEvent
extends InputEvent
implements Parcelable {
    private static final long NS_PER_MS = 1000000L;
    private static final String LABEL_PREFIX = "AXIS_";
    public static final int INVALID_POINTER_ID = -1;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_HOVER_MOVE = 7;
    public static final int ACTION_SCROLL = 8;
    public static final int ACTION_HOVER_ENTER = 9;
    public static final int ACTION_HOVER_EXIT = 10;
    public static final int ACTION_BUTTON_PRESS = 11;
    public static final int ACTION_BUTTON_RELEASE = 12;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    public static final int FLAG_WINDOW_IS_PARTIALLY_OBSCURED = 2;
    public static final int FLAG_TAINTED = Integer.MIN_VALUE;
    public static final int FLAG_TARGET_ACCESSIBILITY_FOCUS = 0x40000000;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_PRESSURE = 2;
    public static final int AXIS_SIZE = 3;
    public static final int AXIS_TOUCH_MAJOR = 4;
    public static final int AXIS_TOUCH_MINOR = 5;
    public static final int AXIS_TOOL_MAJOR = 6;
    public static final int AXIS_TOOL_MINOR = 7;
    public static final int AXIS_ORIENTATION = 8;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_HSCROLL = 10;
    public static final int AXIS_Z = 11;
    public static final int AXIS_RX = 12;
    public static final int AXIS_RY = 13;
    public static final int AXIS_RZ = 14;
    public static final int AXIS_HAT_X = 15;
    public static final int AXIS_HAT_Y = 16;
    public static final int AXIS_LTRIGGER = 17;
    public static final int AXIS_RTRIGGER = 18;
    public static final int AXIS_THROTTLE = 19;
    public static final int AXIS_RUDDER = 20;
    public static final int AXIS_WHEEL = 21;
    public static final int AXIS_GAS = 22;
    public static final int AXIS_BRAKE = 23;
    public static final int AXIS_DISTANCE = 24;
    public static final int AXIS_TILT = 25;
    public static final int AXIS_SCROLL = 26;
    public static final int AXIS_RELATIVE_X = 27;
    public static final int AXIS_RELATIVE_Y = 28;
    public static final int AXIS_GENERIC_1 = 32;
    public static final int AXIS_GENERIC_2 = 33;
    public static final int AXIS_GENERIC_3 = 34;
    public static final int AXIS_GENERIC_4 = 35;
    public static final int AXIS_GENERIC_5 = 36;
    public static final int AXIS_GENERIC_6 = 37;
    public static final int AXIS_GENERIC_7 = 38;
    public static final int AXIS_GENERIC_8 = 39;
    public static final int AXIS_GENERIC_9 = 40;
    public static final int AXIS_GENERIC_10 = 41;
    public static final int AXIS_GENERIC_11 = 42;
    public static final int AXIS_GENERIC_12 = 43;
    public static final int AXIS_GENERIC_13 = 44;
    public static final int AXIS_GENERIC_14 = 45;
    public static final int AXIS_GENERIC_15 = 46;
    public static final int AXIS_GENERIC_16 = 47;
    private static final SparseArray<String> AXIS_SYMBOLIC_NAMES;
    public static final int BUTTON_PRIMARY = 1;
    public static final int BUTTON_SECONDARY = 2;
    public static final int BUTTON_TERTIARY = 4;
    public static final int BUTTON_BACK = 8;
    public static final int BUTTON_FORWARD = 16;
    public static final int BUTTON_STYLUS_PRIMARY = 32;
    public static final int BUTTON_STYLUS_SECONDARY = 64;
    private static final String[] BUTTON_SYMBOLIC_NAMES;
    public static final int TOOL_TYPE_UNKNOWN = 0;
    public static final int TOOL_TYPE_FINGER = 1;
    public static final int TOOL_TYPE_STYLUS = 2;
    public static final int TOOL_TYPE_MOUSE = 3;
    public static final int TOOL_TYPE_ERASER = 4;
    private static final SparseArray<String> TOOL_TYPE_SYMBOLIC_NAMES;
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    private static final int MAX_RECYCLED = 10;
    private static final Object gRecyclerLock;
    private static int gRecyclerUsed;
    private static MotionEvent gRecyclerTop;
    private static final Object gSharedTempLock;
    private static PointerCoords[] gSharedTempPointerCoords;
    private static PointerProperties[] gSharedTempPointerProperties;
    private static int[] gSharedTempPointerIndexMap;
    private long mNativePtr;
    private MotionEvent mNext;
    public static final Parcelable.Creator<MotionEvent> CREATOR;

    private static void ensureSharedTempPointerCapacity(int desiredCapacity) {
        if (gSharedTempPointerCoords == null || gSharedTempPointerCoords.length < desiredCapacity) {
            int capacity;
            int n = capacity = gSharedTempPointerCoords != null ? gSharedTempPointerCoords.length : 8;
            while (capacity < desiredCapacity) {
                capacity *= 2;
            }
            gSharedTempPointerCoords = PointerCoords.createArray(capacity);
            gSharedTempPointerProperties = PointerProperties.createArray(capacity);
            gSharedTempPointerIndexMap = new int[capacity];
        }
    }

    private static long nativeInitialize(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, float f3, float f4, long l2, long l3, int n8, PointerProperties[] pointerPropertiesArray, PointerCoords[] pointerCoordsArray) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeInitialize(JIIIIIIIFFFFJJI[Landroid/view/MotionEvent$PointerProperties;[Landroid/view/MotionEvent$PointerCoords;)J", true, null);
    }

    private static long nativeCopy(long l, long l2, boolean bl) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeCopy(JJZ)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeDispose(J)V", true, null);
    }

    private static void nativeAddBatch(long l, long l2, PointerCoords[] pointerCoordsArray, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeAddBatch(JJ[Landroid/view/MotionEvent$PointerCoords;I)V", true, null);
    }

    private static int nativeGetDeviceId(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetDeviceId(J)I", true, null);
    }

    private static int nativeGetSource(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetSource(J)I", true, null);
    }

    private static int nativeSetSource(long l, int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeSetSource(JI)I", true, null);
    }

    private static int nativeGetAction(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetAction(J)I", true, null);
    }

    private static void nativeSetAction(long l, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetAction(JI)V", true, null);
    }

    private static boolean nativeIsTouchEvent(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeIsTouchEvent(J)Z", true, null) != 0;
    }

    private static int nativeGetFlags(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetFlags(J)I", true, null);
    }

    private static void nativeSetFlags(long l, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetFlags(JI)V", true, null);
    }

    private static int nativeGetEdgeFlags(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetEdgeFlags(J)I", true, null);
    }

    private static void nativeSetEdgeFlags(long l, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetEdgeFlags(JI)V", true, null);
    }

    private static int nativeGetMetaState(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetMetaState(J)I", true, null);
    }

    private static int nativeGetButtonState(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetButtonState(J)I", true, null);
    }

    private static void nativeSetButtonState(long l, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetButtonState(JI)V", true, null);
    }

    private static int nativeGetActionButton(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetActionButton(J)I", true, null);
    }

    private static void nativeSetActionButton(long l, int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetActionButton(JI)V", true, null);
    }

    private static void nativeOffsetLocation(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeOffsetLocation(JFF)V", true, null);
    }

    private static float nativeGetXOffset(long l) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetXOffset(J)F", true, null);
    }

    private static float nativeGetYOffset(long l) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetYOffset(J)F", true, null);
    }

    private static float nativeGetXPrecision(long l) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetXPrecision(J)F", true, null);
    }

    private static float nativeGetYPrecision(long l) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetYPrecision(J)F", true, null);
    }

    private static long nativeGetDownTimeNanos(long l) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeGetDownTimeNanos(J)J", true, null);
    }

    private static void nativeSetDownTimeNanos(long l, long l2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetDownTimeNanos(JJ)V", true, null);
    }

    private static int nativeGetPointerCount(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetPointerCount(J)I", true, null);
    }

    private static int nativeGetPointerId(long l, int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetPointerId(JI)I", true, null);
    }

    private static int nativeGetToolType(long l, int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetToolType(JI)I", true, null);
    }

    private static int nativeFindPointerIndex(long l, int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeFindPointerIndex(JI)I", true, null);
    }

    private static int nativeGetHistorySize(long l) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetHistorySize(J)I", true, null);
    }

    private static long nativeGetEventTimeNanos(long l, int n) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeGetEventTimeNanos(JI)J", true, null);
    }

    private static float nativeGetRawAxisValue(long l, int n, int n2, int n3) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetRawAxisValue(JIII)F", true, null);
    }

    private static float nativeGetAxisValue(long l, int n, int n2, int n3) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetAxisValue(JIII)F", true, null);
    }

    private static void nativeGetPointerCoords(long l, int n, int n2, PointerCoords pointerCoords) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeGetPointerCoords(JIILandroid/view/MotionEvent$PointerCoords;)V", true, null);
    }

    private static void nativeGetPointerProperties(long l, int n, PointerProperties pointerProperties) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeGetPointerProperties(JILandroid/view/MotionEvent$PointerProperties;)V", true, null);
    }

    private static void nativeScale(long l, float f) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeScale(JF)V", true, null);
    }

    private static void nativeTransform(long l, Matrix matrix) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeTransform(JLandroid/graphics/Matrix;)V", true, null);
    }

    private static long nativeReadFromParcel(long l, Parcel parcel) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeReadFromParcel(JLandroid/os/Parcel;)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static String nativeAxisToString(int n) {
        return (String)OverrideMethod.invokeA("android.view.MotionEvent#nativeAxisToString(I)Ljava/lang/String;", true, null);
    }

    private static int nativeAxisFromString(String string2) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeAxisFromString(Ljava/lang/String;)I", true, null);
    }

    private MotionEvent() {
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                MotionEvent.nativeDispose(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MotionEvent obtain() {
        MotionEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            ev = gRecyclerTop;
            if (ev == null) {
                return new MotionEvent();
            }
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mNext = null;
        ev.prepareForReuse();
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, PointerProperties[] pointerProperties, PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, source, action, flags, edgeFlags, metaState, buttonState, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, pointerCount, pointerProperties, pointerCoords);
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, int[] pointerIds, PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            for (int i = 0; i < pointerCount; ++i) {
                pp[i].clear();
                pp[i].id = pointerIds[i];
            }
            return MotionEvent.obtain(downTime, eventTime, action, pointerCount, pp, pointerCoords, metaState, 0, xPrecision, yPrecision, deviceId, edgeFlags, source, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerProperties[] pp = gSharedTempPointerProperties;
            pp[0].clear();
            pp[0].id = 0;
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, 0, action, 0, edgeFlags, metaState, 0, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, 1, pp, pc);
            return ev;
        }
    }

    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointerCount, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags);
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, 1.0f, 1.0f, metaState, 1.0f, 1.0f, 0, 0);
    }

    public static MotionEvent obtain(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, true);
        return ev;
    }

    public static MotionEvent obtainNoHistory(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, false);
        return ev;
    }

    @Override
    public MotionEvent copy() {
        return MotionEvent.obtain(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        super.recycle();
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public void scale(float scale) {
        if (scale != 1.0f) {
            MotionEvent.nativeScale(this.mNativePtr, scale);
        }
    }

    @Override
    public int getDeviceId() {
        return MotionEvent.nativeGetDeviceId(this.mNativePtr);
    }

    @Override
    public int getSource() {
        return MotionEvent.nativeGetSource(this.mNativePtr);
    }

    @Override
    public void setSource(int source) {
        MotionEvent.nativeSetSource(this.mNativePtr, source);
    }

    public int getAction() {
        return MotionEvent.nativeGetAction(this.mNativePtr);
    }

    public int getActionMasked() {
        return MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF;
    }

    public int getActionIndex() {
        return (MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF00) >> 8;
    }

    public boolean isTouchEvent() {
        return MotionEvent.nativeIsTouchEvent(this.mNativePtr);
    }

    public int getFlags() {
        return MotionEvent.nativeGetFlags(this.mNativePtr);
    }

    @Override
    public boolean isTainted() {
        int flags = this.getFlags();
        return (flags & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void setTainted(boolean tainted) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, tainted ? flags | Integer.MIN_VALUE : flags & Integer.MAX_VALUE);
    }

    public boolean isTargetAccessibilityFocus() {
        int flags = this.getFlags();
        return (flags & 0x40000000) != 0;
    }

    public void setTargetAccessibilityFocus(boolean targetsFocus) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, targetsFocus ? flags | 0x40000000 : flags & 0xBFFFFFFF);
    }

    public long getDownTime() {
        return MotionEvent.nativeGetDownTimeNanos(this.mNativePtr) / 1000000L;
    }

    public void setDownTime(long downTime) {
        MotionEvent.nativeSetDownTimeNanos(this.mNativePtr, downTime * 1000000L);
    }

    @Override
    public long getEventTime() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE) / 1000000L;
    }

    @Override
    public long getEventTimeNano() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE);
    }

    public float getX() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public float getY() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public float getPressure() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, Integer.MIN_VALUE);
    }

    public float getSize() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, Integer.MIN_VALUE);
    }

    public float getTouchMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, Integer.MIN_VALUE);
    }

    public float getTouchMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, Integer.MIN_VALUE);
    }

    public float getToolMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, Integer.MIN_VALUE);
    }

    public float getToolMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, Integer.MIN_VALUE);
    }

    public float getOrientation() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, Integer.MIN_VALUE);
    }

    public float getAxisValue(int axis) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, Integer.MIN_VALUE);
    }

    public int getPointerCount() {
        return MotionEvent.nativeGetPointerCount(this.mNativePtr);
    }

    public int getPointerId(int pointerIndex) {
        return MotionEvent.nativeGetPointerId(this.mNativePtr, pointerIndex);
    }

    public int getToolType(int pointerIndex) {
        return MotionEvent.nativeGetToolType(this.mNativePtr, pointerIndex);
    }

    public int findPointerIndex(int pointerId) {
        return MotionEvent.nativeFindPointerIndex(this.mNativePtr, pointerId);
    }

    public float getX(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, Integer.MIN_VALUE);
    }

    public float getY(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, Integer.MIN_VALUE);
    }

    public float getPressure(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, Integer.MIN_VALUE);
    }

    public float getSize(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, Integer.MIN_VALUE);
    }

    public float getTouchMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, Integer.MIN_VALUE);
    }

    public float getTouchMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, Integer.MIN_VALUE);
    }

    public float getToolMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, Integer.MIN_VALUE);
    }

    public float getToolMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, Integer.MIN_VALUE);
    }

    public float getOrientation(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, Integer.MIN_VALUE);
    }

    public float getAxisValue(int axis, int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, Integer.MIN_VALUE);
    }

    public void getPointerCoords(int pointerIndex, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, Integer.MIN_VALUE, outPointerCoords);
    }

    public void getPointerProperties(int pointerIndex, PointerProperties outPointerProperties) {
        MotionEvent.nativeGetPointerProperties(this.mNativePtr, pointerIndex, outPointerProperties);
    }

    public int getMetaState() {
        return MotionEvent.nativeGetMetaState(this.mNativePtr);
    }

    public int getButtonState() {
        return MotionEvent.nativeGetButtonState(this.mNativePtr);
    }

    public void setButtonState(int buttonState) {
        MotionEvent.nativeSetButtonState(this.mNativePtr, buttonState);
    }

    public int getActionButton() {
        return MotionEvent.nativeGetActionButton(this.mNativePtr);
    }

    public void setActionButton(int button) {
        MotionEvent.nativeSetActionButton(this.mNativePtr, button);
    }

    public float getRawX() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public float getRawY() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public float getXPrecision() {
        return MotionEvent.nativeGetXPrecision(this.mNativePtr);
    }

    public float getYPrecision() {
        return MotionEvent.nativeGetYPrecision(this.mNativePtr);
    }

    public int getHistorySize() {
        return MotionEvent.nativeGetHistorySize(this.mNativePtr);
    }

    public long getHistoricalEventTime(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos) / 1000000L;
    }

    public long getHistoricalEventTimeNano(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos);
    }

    public float getHistoricalX(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, pos);
    }

    public float getHistoricalY(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, pos);
    }

    public float getHistoricalPressure(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, pos);
    }

    public float getHistoricalSize(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, pos);
    }

    public float getHistoricalTouchMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, pos);
    }

    public float getHistoricalTouchMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, pos);
    }

    public float getHistoricalToolMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, pos);
    }

    public float getHistoricalToolMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, pos);
    }

    public float getHistoricalOrientation(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, pos);
    }

    public float getHistoricalAxisValue(int axis, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, pos);
    }

    public float getHistoricalX(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, pos);
    }

    public float getHistoricalY(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, pos);
    }

    public float getHistoricalPressure(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, pos);
    }

    public float getHistoricalSize(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, pos);
    }

    public float getHistoricalTouchMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, pos);
    }

    public float getHistoricalTouchMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, pos);
    }

    public float getHistoricalToolMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, pos);
    }

    public float getHistoricalToolMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, pos);
    }

    public float getHistoricalOrientation(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, pos);
    }

    public float getHistoricalAxisValue(int axis, int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, pos);
    }

    public void getHistoricalPointerCoords(int pointerIndex, int pos, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, pos, outPointerCoords);
    }

    public int getEdgeFlags() {
        return MotionEvent.nativeGetEdgeFlags(this.mNativePtr);
    }

    public void setEdgeFlags(int flags) {
        MotionEvent.nativeSetEdgeFlags(this.mNativePtr, flags);
    }

    public void setAction(int action) {
        MotionEvent.nativeSetAction(this.mNativePtr, action);
    }

    public void offsetLocation(float deltaX, float deltaY) {
        if (deltaX != 0.0f || deltaY != 0.0f) {
            MotionEvent.nativeOffsetLocation(this.mNativePtr, deltaX, deltaY);
        }
    }

    public void setLocation(float x, float y) {
        float oldX = this.getX();
        float oldY = this.getY();
        this.offsetLocation(x - oldX, y - oldY);
    }

    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeTransform(this.mNativePtr, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pc, metaState);
        }
    }

    public void addBatch(long eventTime, PointerCoords[] pointerCoords, int metaState) {
        MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pointerCoords, metaState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBatch(MotionEvent event) {
        int action = MotionEvent.nativeGetAction(this.mNativePtr);
        if (action != 2 && action != 7) {
            return false;
        }
        if (action != MotionEvent.nativeGetAction(event.mNativePtr)) {
            return false;
        }
        if (MotionEvent.nativeGetDeviceId(this.mNativePtr) != MotionEvent.nativeGetDeviceId(event.mNativePtr) || MotionEvent.nativeGetSource(this.mNativePtr) != MotionEvent.nativeGetSource(event.mNativePtr) || MotionEvent.nativeGetFlags(this.mNativePtr) != MotionEvent.nativeGetFlags(event.mNativePtr)) {
            return false;
        }
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        if (pointerCount != MotionEvent.nativeGetPointerCount(event.mNativePtr)) {
            return false;
        }
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(Math.max(pointerCount, 2));
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[0]);
                MotionEvent.nativeGetPointerProperties(event.mNativePtr, i, pp[1]);
                if (pp[0].equals(pp[1])) continue;
                return false;
            }
            int metaState = MotionEvent.nativeGetMetaState(event.mNativePtr);
            int historySize = MotionEvent.nativeGetHistorySize(event.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < pointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(event.mNativePtr, i, historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(event.mNativePtr, historyPos);
                MotionEvent.nativeAddBatch(this.mNativePtr, eventTimeNanos, pc, metaState);
            }
        }
        return true;
    }

    public boolean isWithinBoundsNoHistory(float left, float top, float right, float bottom) {
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            float x = MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, i, Integer.MIN_VALUE);
            float y = MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, i, Integer.MIN_VALUE);
            if (!(x < left || x > right || y < top) && !(y > bottom)) continue;
            return false;
        }
        return true;
    }

    private static float clamp(float value, float low, float high) {
        if (value < low) {
            return low;
        }
        if (value > high) {
            return high;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MotionEvent clampNoHistory(float left, float top, float right, float bottom) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[i]);
                MotionEvent.nativeGetPointerCoords(this.mNativePtr, i, Integer.MIN_VALUE, pc[i]);
                pc[i].x = MotionEvent.clamp(pc[i].x, left, right);
                pc[i].y = MotionEvent.clamp(pc[i].y, top, bottom);
            }
            ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), MotionEvent.nativeGetAction(this.mNativePtr), MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE), pointerCount, pp, pc);
            return ev;
        }
    }

    public int getPointerIdBits() {
        int idBits = 0;
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            idBits |= 1 << MotionEvent.nativeGetPointerId(this.mNativePtr, i);
        }
        return idBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MotionEvent split(int idBits) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int oldPointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(oldPointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            int[] map = gSharedTempPointerIndexMap;
            int oldAction = MotionEvent.nativeGetAction(this.mNativePtr);
            int oldActionMasked = oldAction & 0xFF;
            int oldActionPointerIndex = (oldAction & 0xFF00) >> 8;
            int newActionPointerIndex = -1;
            int newPointerCount = 0;
            int newIdBits = 0;
            for (int i = 0; i < oldPointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[newPointerCount]);
                int idBit = 1 << pp[newPointerCount].id;
                if ((idBit & idBits) == 0) continue;
                if (i == oldActionPointerIndex) {
                    newActionPointerIndex = newPointerCount;
                }
                map[newPointerCount] = i;
                ++newPointerCount;
                newIdBits |= idBit;
            }
            if (newPointerCount == 0) {
                throw new IllegalArgumentException("idBits did not match any ids in the event");
            }
            int newAction = oldActionMasked == 5 || oldActionMasked == 6 ? (newActionPointerIndex < 0 ? 2 : (newPointerCount == 1 ? (oldActionMasked == 5 ? 0 : 1) : oldActionMasked | newActionPointerIndex << 8)) : oldAction;
            int historySize = MotionEvent.nativeGetHistorySize(this.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < newPointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(this.mNativePtr, map[i], historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, historyPos);
                if (h == 0) {
                    ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), newAction, MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), eventTimeNanos, newPointerCount, pp, pc);
                    continue;
                }
                MotionEvent.nativeAddBatch(ev.mNativePtr, eventTimeNanos, pc, 0);
            }
            return ev;
        }
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("MotionEvent { action=").append(MotionEvent.actionToString(this.getAction()));
        msg.append(", actionButton=").append(MotionEvent.buttonStateToString(this.getActionButton()));
        int pointerCount = this.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            msg.append(", id[").append(i).append("]=").append(this.getPointerId(i));
            msg.append(", x[").append(i).append("]=").append(this.getX(i));
            msg.append(", y[").append(i).append("]=").append(this.getY(i));
            msg.append(", toolType[").append(i).append("]=").append(MotionEvent.toolTypeToString(this.getToolType(i)));
        }
        msg.append(", buttonState=").append(MotionEvent.buttonStateToString(this.getButtonState()));
        msg.append(", metaState=").append(KeyEvent.metaStateToString(this.getMetaState()));
        msg.append(", flags=0x").append(Integer.toHexString(this.getFlags()));
        msg.append(", edgeFlags=0x").append(Integer.toHexString(this.getEdgeFlags()));
        msg.append(", pointerCount=").append(pointerCount);
        msg.append(", historySize=").append(this.getHistorySize());
        msg.append(", eventTime=").append(this.getEventTime());
        msg.append(", downTime=").append(this.getDownTime());
        msg.append(", deviceId=").append(this.getDeviceId());
        msg.append(", source=0x").append(Integer.toHexString(this.getSource()));
        msg.append(" }");
        return msg.toString();
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    public static String axisToString(int axis) {
        String symbolicName = MotionEvent.nativeAxisToString(axis);
        return symbolicName != null ? LABEL_PREFIX + symbolicName : Integer.toString(axis);
    }

    public static int axisFromString(String symbolicName) {
        int axis;
        if (symbolicName.startsWith(LABEL_PREFIX) && (axis = MotionEvent.nativeAxisFromString(symbolicName = symbolicName.substring(LABEL_PREFIX.length()))) >= 0) {
            return axis;
        }
        try {
            return Integer.parseInt(symbolicName, 10);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String buttonStateToString(int buttonState) {
        if (buttonState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (buttonState != 0) {
            boolean isSet = (buttonState & 1) != 0;
            buttonState >>>= 1;
            if (isSet) {
                String name = BUTTON_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (buttonState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String toolTypeToString(int toolType) {
        String symbolicName = TOOL_TYPE_SYMBOLIC_NAMES.get(toolType);
        return symbolicName != null ? symbolicName : Integer.toString(toolType);
    }

    public boolean isButtonPressed(int button) {
        if (button == 0) {
            return false;
        }
        return (this.getButtonState() & button) == button;
    }

    public static MotionEvent createFromParcelBody(Parcel in) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeReadFromParcel(ev.mNativePtr, in);
        return ev;
    }

    @Override
    public void cancel() {
        this.setAction(3);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        MotionEvent.nativeWriteToParcel(this.mNativePtr, out);
    }

    static {
        SparseArray<String> names = AXIS_SYMBOLIC_NAMES = new SparseArray();
        names.append(0, "AXIS_X");
        names.append(1, "AXIS_Y");
        names.append(2, "AXIS_PRESSURE");
        names.append(3, "AXIS_SIZE");
        names.append(4, "AXIS_TOUCH_MAJOR");
        names.append(5, "AXIS_TOUCH_MINOR");
        names.append(6, "AXIS_TOOL_MAJOR");
        names.append(7, "AXIS_TOOL_MINOR");
        names.append(8, "AXIS_ORIENTATION");
        names.append(9, "AXIS_VSCROLL");
        names.append(10, "AXIS_HSCROLL");
        names.append(11, "AXIS_Z");
        names.append(12, "AXIS_RX");
        names.append(13, "AXIS_RY");
        names.append(14, "AXIS_RZ");
        names.append(15, "AXIS_HAT_X");
        names.append(16, "AXIS_HAT_Y");
        names.append(17, "AXIS_LTRIGGER");
        names.append(18, "AXIS_RTRIGGER");
        names.append(19, "AXIS_THROTTLE");
        names.append(20, "AXIS_RUDDER");
        names.append(21, "AXIS_WHEEL");
        names.append(22, "AXIS_GAS");
        names.append(23, "AXIS_BRAKE");
        names.append(24, "AXIS_DISTANCE");
        names.append(25, "AXIS_TILT");
        names.append(26, "AXIS_SCROLL");
        names.append(27, "AXIS_REALTIVE_X");
        names.append(28, "AXIS_REALTIVE_Y");
        names.append(32, "AXIS_GENERIC_1");
        names.append(33, "AXIS_GENERIC_2");
        names.append(34, "AXIS_GENERIC_3");
        names.append(35, "AXIS_GENERIC_4");
        names.append(36, "AXIS_GENERIC_5");
        names.append(37, "AXIS_GENERIC_6");
        names.append(38, "AXIS_GENERIC_7");
        names.append(39, "AXIS_GENERIC_8");
        names.append(40, "AXIS_GENERIC_9");
        names.append(41, "AXIS_GENERIC_10");
        names.append(42, "AXIS_GENERIC_11");
        names.append(43, "AXIS_GENERIC_12");
        names.append(44, "AXIS_GENERIC_13");
        names.append(45, "AXIS_GENERIC_14");
        names.append(46, "AXIS_GENERIC_15");
        names.append(47, "AXIS_GENERIC_16");
        BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "BUTTON_STYLUS_PRIMARY", "BUTTON_STYLUS_SECONDARY", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
        TOOL_TYPE_SYMBOLIC_NAMES = new SparseArray();
        names = TOOL_TYPE_SYMBOLIC_NAMES;
        names.append(0, "TOOL_TYPE_UNKNOWN");
        names.append(1, "TOOL_TYPE_FINGER");
        names.append(2, "TOOL_TYPE_STYLUS");
        names.append(3, "TOOL_TYPE_MOUSE");
        names.append(4, "TOOL_TYPE_ERASER");
        gRecyclerLock = new Object();
        gSharedTempLock = new Object();
        CREATOR = new Parcelable.Creator<MotionEvent>(){

            @Override
            public MotionEvent createFromParcel(Parcel in) {
                in.readInt();
                return MotionEvent.createFromParcelBody(in);
            }

            public MotionEvent[] newArray(int size) {
                return new MotionEvent[size];
            }
        };
    }

    public static class PointerProperties {
        public int id;
        public int toolType;

        public PointerProperties() {
            this.clear();
        }

        public PointerProperties(PointerProperties other) {
            this.copyFrom(other);
        }

        public static PointerProperties[] createArray(int size) {
            PointerProperties[] array2 = new PointerProperties[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerProperties();
            }
            return array2;
        }

        public void clear() {
            this.id = -1;
            this.toolType = 0;
        }

        public void copyFrom(PointerProperties other) {
            this.id = other.id;
            this.toolType = other.toolType;
        }

        public boolean equals(Object other) {
            if (other instanceof PointerProperties) {
                return this.equals((PointerProperties)other);
            }
            return false;
        }

        private boolean equals(PointerProperties other) {
            return other != null && this.id == other.id && this.toolType == other.toolType;
        }

        public int hashCode() {
            return this.id | this.toolType << 8;
        }
    }

    public static class PointerCoords {
        private static final int INITIAL_PACKED_AXIS_VALUES = 8;
        private long mPackedAxisBits;
        private float[] mPackedAxisValues;
        public float x;
        public float y;
        public float pressure;
        public float size;
        public float touchMajor;
        public float touchMinor;
        public float toolMajor;
        public float toolMinor;
        public float orientation;

        public PointerCoords() {
        }

        public PointerCoords(PointerCoords other) {
            this.copyFrom(other);
        }

        public static PointerCoords[] createArray(int size) {
            PointerCoords[] array2 = new PointerCoords[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerCoords();
            }
            return array2;
        }

        public void clear() {
            this.mPackedAxisBits = 0L;
            this.x = 0.0f;
            this.y = 0.0f;
            this.pressure = 0.0f;
            this.size = 0.0f;
            this.touchMajor = 0.0f;
            this.touchMinor = 0.0f;
            this.toolMajor = 0.0f;
            this.toolMinor = 0.0f;
            this.orientation = 0.0f;
        }

        public void copyFrom(PointerCoords other) {
            long bits;
            this.mPackedAxisBits = bits = other.mPackedAxisBits;
            if (bits != 0L) {
                float[] otherValues = other.mPackedAxisValues;
                int count = Long.bitCount(bits);
                float[] values = this.mPackedAxisValues;
                if (values == null || count > values.length) {
                    this.mPackedAxisValues = values = new float[otherValues.length];
                }
                System.arraycopy(otherValues, 0, values, 0, count);
            }
            this.x = other.x;
            this.y = other.y;
            this.pressure = other.pressure;
            this.size = other.size;
            this.touchMajor = other.touchMajor;
            this.touchMinor = other.touchMinor;
            this.toolMajor = other.toolMajor;
            this.toolMinor = other.toolMinor;
            this.orientation = other.orientation;
        }

        public float getAxisValue(int axis) {
            switch (axis) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.pressure;
                }
                case 3: {
                    return this.size;
                }
                case 4: {
                    return this.touchMajor;
                }
                case 5: {
                    return this.touchMinor;
                }
                case 6: {
                    return this.toolMajor;
                }
                case 7: {
                    return this.toolMinor;
                }
                case 8: {
                    return this.orientation;
                }
            }
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = Long.MIN_VALUE >>> axis;
            if ((bits & axisBit) == 0L) {
                return 0.0f;
            }
            int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
            return this.mPackedAxisValues[index];
        }

        public void setAxisValue(int axis, float value) {
            switch (axis) {
                case 0: {
                    this.x = value;
                    break;
                }
                case 1: {
                    this.y = value;
                    break;
                }
                case 2: {
                    this.pressure = value;
                    break;
                }
                case 3: {
                    this.size = value;
                    break;
                }
                case 4: {
                    this.touchMajor = value;
                    break;
                }
                case 5: {
                    this.touchMinor = value;
                    break;
                }
                case 6: {
                    this.toolMajor = value;
                    break;
                }
                case 7: {
                    this.toolMinor = value;
                    break;
                }
                case 8: {
                    this.orientation = value;
                    break;
                }
                default: {
                    if (axis < 0 || axis > 63) {
                        throw new IllegalArgumentException("Axis out of range.");
                    }
                    long bits = this.mPackedAxisBits;
                    long axisBit = Long.MIN_VALUE >>> axis;
                    int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
                    float[] values = this.mPackedAxisValues;
                    if ((bits & axisBit) == 0L) {
                        if (values == null) {
                            this.mPackedAxisValues = values = new float[8];
                        } else {
                            int count = Long.bitCount(bits);
                            if (count < values.length) {
                                if (index != count) {
                                    System.arraycopy(values, index, values, index + 1, count - index);
                                }
                            } else {
                                float[] newValues = new float[count * 2];
                                System.arraycopy(values, 0, newValues, 0, index);
                                System.arraycopy(values, index, newValues, index + 1, count - index);
                                this.mPackedAxisValues = values = newValues;
                            }
                        }
                        this.mPackedAxisBits = bits | axisBit;
                    }
                    values[index] = value;
                }
            }
        }
    }
}

