/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;

public class SpringBootApplicationPropertiesConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    protected boolean processModelConfigFiles(MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, String prefix, Module module, SpringBootModelConfigFileContributor contributor) {
        if (contributor.getFileType() != PropertiesFileType.INSTANCE) {
            return true;
        }
        for (VirtualFile file : contributor.getConfigurationFiles(module, true)) {
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof PropertiesFile)) continue;
            PropertiesFile propertiesFile = (PropertiesFile)psiFile;
            for (IProperty property : propertiesFile.getProperties()) {
                PropertyImpl element;
                ASTNode keyNode;
                PsiElement keyPsiElement;
                String propertyName = property.getName();
                if (propertyName == null || !StringUtil.charsEqualIgnoreCase((char)propertyName.charAt(0), (char)prefix.charAt(0)) || (keyPsiElement = (keyNode = (element = (PropertyImpl)property.getPsiElement()).getKeyNode()) != null ? keyNode.getPsi() : null) == null || SpringBootApplicationPropertiesConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences((MethodReferencesSearch.SearchParameters)queryParameters, (PsiReference[])keyPsiElement.getReferences())) continue;
                return false;
            }
        }
        return true;
    }
}

