/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @Nullable
    public SpringBootModelConfigFileContributor.ConfigurationValueResult findConfigurationValue(PsiFile configFile, SpringBootApplicationMetaConfigKey key, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles) {
        PropertiesFile propertiesFile = SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantFile(configFile, activeProfiles);
        if (propertiesFile == null) {
            return null;
        }
        String keyName = key.getName();
        IProperty byExactName = propertiesFile.findPropertyByKey(keyName);
        if (byExactName != null) {
            PropertyImpl propertyImpl = (PropertyImpl)byExactName.getPsiElement();
            return new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl), (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl), byExactName.getValue());
        }
        if (!checkRelaxedNames) {
            return null;
        }
        for (IProperty property : propertiesFile.getProperties()) {
            SpringBootApplicationMetaConfigKey resolvedKey;
            PropertyImpl element;
            PropertyKeyImpl keyPsiElement;
            String propertyName = property.getName();
            if (propertyName == null || !StringUtil.charsEqualIgnoreCase((char)propertyName.charAt(0), (char)keyName.charAt(0)) || (keyPsiElement = SpringBootApplicationPropertiesUtil.getPropertyKey(element = (PropertyImpl)property.getPsiElement())) == null || (resolvedKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyPsiElement)) == null || !resolvedKey.getName().equals(keyName)) continue;
            return new SpringBootModelConfigFileContributor.ConfigurationValueResult((PsiElement)keyPsiElement, (PsiElement)SpringBootApplicationPropertiesUtil.getPropertyValue(element), property.getValue());
        }
        return null;
    }

    @Nullable
    private static PropertiesFile isProfileRelevantFile(PsiFile configFile, @Nullable Set<String> activeProfiles) {
        if (!(configFile instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)configFile;
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return propertiesFile;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return null;
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? propertiesFile : null;
    }
}

