/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.banner.SpringBootBannerPropertyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class SpringBootBannerReferenceContributor
extends PsiReferenceContributor {
    private static boolean TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private static final PatternCondition<PsiPlainTextFile> IS_BANNER_FILE_CONDITION = new PatternCondition<PsiPlainTextFile>("isBannerFile"){

        public boolean accepts(@NotNull PsiPlainTextFile file, ProcessingContext context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$1", "accepts"));
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return false;
            }
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (!TEST_MODE && !index.isUnderSourceRootOfType(file.getOriginalFile().getVirtualFile(), JavaModuleSourceRootTypes.RESOURCES)) {
                return false;
            }
            SpringBootApplicationMetaConfigKey bannerLocationKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, "banner.location");
            if (bannerLocationKey == null) {
                return false;
            }
            boolean foundConfigKey = false;
            for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                for (VirtualFile virtualFile : contributor.getConfigurationFiles(module, false)) {
                    SpringBootModelConfigFileContributor.ConfigurationValueResult value;
                    PsiFile configPsiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
                    if (configPsiFile == null || (value = contributor.findConfigurationValue(configPsiFile, bannerLocationKey, true, null)) == null || value.valueElement == null) continue;
                    foundConfigKey = true;
                    for (PsiReference reference : value.valueElement.getReferences()) {
                        if (!file.isEquivalentTo(reference.resolve())) continue;
                        return true;
                    }
                }
            }
            if (foundConfigKey) {
                return false;
            }
            return file.getName().equals("banner.txt");
        }
    };
    public static final PsiElementPattern.Capture<PsiPlainTextFile> PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiPlainTextFile.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).with((PatternCondition)new PatternCondition<PsiPlainTextFile>("springBootLibrary"){

        public boolean accepts(@NotNull PsiPlainTextFile file, ProcessingContext context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "accepts"));
            }
            return SpringBootLibraryUtil.hasSpringBootLibrary((Project)file.getProject());
        }
    })).with(IS_BANNER_FILE_CONDITION);
    static final String PREFIX = "${";
    static final String SUFFIX = "}";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3", "getReferencesByElement"));
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                boolean is13 = SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
                SmartList references = new SmartList();
                String text = element.getText();
                int startOffset = 0;
                while ((startOffset = text.indexOf(SpringBootBannerReferenceContributor.PREFIX, startOffset)) != -1) {
                    int endOffset = text.indexOf(SpringBootBannerReferenceContributor.SUFFIX, startOffset + SpringBootBannerReferenceContributor.PREFIX.length());
                    if (endOffset == -1) {
                        startOffset += SpringBootBannerReferenceContributor.PREFIX.length();
                        continue;
                    }
                    TextRange range = TextRange.create((int)(startOffset + SpringBootBannerReferenceContributor.PREFIX.length()), (int)endOffset);
                    SpringBootBannerPropertyReference reference = new SpringBootBannerPropertyReference(element, range, is13);
                    references.add(reference);
                    startOffset = endOffset + SpringBootBannerReferenceContributor.SUFFIX.length();
                }
                PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

