/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigurationModelBase;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EnableAutoConfigurationModel
extends AutoConfigurationModelBase {
    private final EnableAutoConfiguration myEnableAutoConfiguration;

    EnableAutoConfigurationModel(LocalAnnotationModel localAnnotationModel, EnableAutoConfiguration enableAutoConfiguration, PsiClass enableAnnotationClass) {
        super(localAnnotationModel, enableAnnotationClass);
        this.myEnableAutoConfiguration = enableAutoConfiguration;
    }

    @Override
    @NotNull
    protected List<PsiClass> getAutoConfigClasses() {
        AutoConfigClassCollector collector = new AutoConfigClassCollector(this.getModule(), this.myEnableAutoConfiguration, (PsiClass)this.getLocalAnnotationModel().getConfig());
        List<PsiClass> list = collector.getAllAutoConfigurationClasses();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getAutoConfigClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    protected LocalModelDependencyType getModelDependencyType() {
        LocalModelDependencyType localModelDependencyType = LocalModelDependencyType.ENABLE_ANNO;
        if (localModelDependencyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getModelDependencyType"));
        }
        return localModelDependencyType;
    }
}

