/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;

public class ConfigurationPropertiesImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            return ConfigurationPropertiesImplicitUsageProvider.isGetterOrSetterInConfigurationPropertiesClass((PsiMethod)element);
        }
        return false;
    }

    private static boolean isGetterOrSetterInConfigurationPropertiesClass(PsiMethod psiMethod) {
        Project project = psiMethod.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) || !SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return false;
        }
        if (!PropertyUtil.isSimplePropertyAccessor((PsiMethod)psiMethod)) {
            return false;
        }
        return SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod((PsiMethod)psiMethod, (boolean)false) != null;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

