/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam.custom.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.testing.jam.mock.CustomJamMockBean;
import com.intellij.spring.boot.model.testing.jam.mock.MockBean;
import com.intellij.spring.boot.model.testing.jam.mock.SpringJamMockBean;
import com.intellij.spring.boot.model.testing.jam.mock.SpringJamMockBeans;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootMockBeansProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(@Nullable Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getModels"));
        }
        PsiClass psiClass = configuration.getPsiElement();
        final List beans = ContainerUtil.newSmartList();
        beans.addAll(SpringBootMockBeansProvider.getMockBeanImpliciteBeans(this.getMockBeans(psiClass)));
        SpringJamMockBeans mockBeans = (SpringJamMockBeans)SpringJamMockBeans.META.getJamElement((PsiModifierListOwner)psiClass);
        if (mockBeans != null) {
            beans.addAll(SpringBootMockBeansProvider.getMockBeanImpliciteBeans(mockBeans.getMockBeans()));
        }
        if (!beans.isEmpty()) {
            Set<BeansSpringModel> set = Collections.singleton(new BeansSpringModel(module, (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    Set set = BeanService.getInstance().mapSpringBeans((Collection)beans);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider$1", "compute"));
                    }
                    return set;
                }
            }));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getModels"));
            }
            return set;
        }
        List<CommonSpringModel> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getModels"));
        }
        return list;
    }

    @NotNull
    public List<MockBean> getMockBeans(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getMockBeans"));
        }
        List elements = ContainerUtil.newSmartList();
        SemService service = SemService.getSemService((Project)psiClass.getProject());
        for (PsiAnnotation annotation : AnnotationUtil.findAnnotations((PsiModifierListOwner)psiClass, Collections.singleton("org.springframework.boot.test.mock.mockito.MockBean"))) {
            ContainerUtil.addAllNotNull((Collection)elements, (Iterable)service.getSemElements(SpringJamMockBean.JAM_KEY, (PsiElement)annotation));
        }
        ContainerUtil.addAllNotNull((Collection)elements, (Iterable)service.getSemElements(CustomJamMockBean.JAM_KEY, (PsiElement)psiClass));
        List list = elements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getMockBeans"));
        }
        return list;
    }

    @NotNull
    private static List<CommonSpringBean> getMockBeanImpliciteBeans(@NotNull List<? extends MockBean> mockBeans) {
        if (mockBeans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockBeans", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getMockBeanImpliciteBeans"));
        }
        List beans = ContainerUtil.newSmartList();
        for (MockBean mockBean : mockBeans) {
            for (PsiClass aClass : mockBean.getMockClasses()) {
                beans.add(SpringImplicitBean.create((String)"Mock Beans", (PsiClass)aClass, (String)StringUtil.decapitalize((String)aClass.getName())));
            }
        }
        List list = beans;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringBootMockBeansProvider", "getMockBeanImpliciteBeans"));
        }
        return list;
    }
}

