/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet;

import com.intellij.CommonBundle;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.framework.JavaeeProjectCategory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.intellij.facet.AddTapestrySupportUtil;
import com.intellij.tapestry.intellij.facet.TapestryFacet;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import com.intellij.tapestry.intellij.facet.TapestryFacetType;
import com.intellij.tapestry.intellij.facet.TapestryVersion;
import com.intellij.tapestry.intellij.facet.ui.NewFacetDialog;
import com.intellij.tapestry.intellij.util.Validators;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TapestryFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<TapestryFacet> {
    public TapestryFrameworkSupportProvider() {
        super((FacetType)TapestryFacetType.getInstance());
    }

    protected void setupConfiguration(TapestryFacet tapestryFacet, ModifiableRootModel modifiableRootModel, FrameworkVersion version) {
        TapestryFrameworkSupportProvider.setupConfiguration((TapestryFacetConfiguration)tapestryFacet.getConfiguration(), tapestryFacet.getModule(), TapestryVersion.fromString(version.getVersionName()));
    }

    protected static void setupConfiguration(TapestryFacetConfiguration conf, Module module, TapestryVersion version) {
        conf.setVersion(version);
        if (StringUtil.isEmpty((String)conf.getFilterName())) {
            conf.setFilterName(module.getName().toLowerCase(Locale.US));
        }
        if (StringUtil.isEmpty((String)conf.getApplicationPackage())) {
            conf.setApplicationPackage("com.app");
        }
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (TapestryVersion version : TapestryVersion.values()) {
            String name = version.toString();
            result.add(new FrameworkVersion(name, "tapestry-" + name, TapestryFacetConfiguration.getLibraryInfos(name)));
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/facet/TapestryFrameworkSupportProvider", "getVersions"));
        }
        return arrayList;
    }

    public String getTitle() {
        return "Tapestry";
    }

    protected void onFacetCreated(TapestryFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        Project project = facet.getModule().getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            Runnable action = () -> {
                TapestryFacetConfiguration configuration = (TapestryFacetConfiguration)facet.getConfiguration();
                NewFacetDialog newFacetDialog = new NewFacetDialog(configuration);
                DialogBuilder builder = new DialogBuilder(project);
                builder.removeAllActions();
                builder.addOkAction();
                builder.setCenterPanel((JComponent)newFacetDialog.getMainPanel());
                builder.setTitle("New Tapestry Support");
                builder.setButtonsAlignment(0);
                builder.setOkOperation(() -> {
                    if (!Validators.isValidPackageName(newFacetDialog.getApplicationPackage())) {
                        Messages.showErrorDialog((String)"Invalid package!", (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    configuration.setFilterName(newFacetDialog.getFilterName());
                    configuration.setApplicationPackage(newFacetDialog.getApplicationPackage());
                    builder.getWindow().dispose();
                });
                builder.showModal(true);
                AddTapestrySupportUtil.addSupportInWriteCommandAction(rootModel.getModule(), configuration, newFacetDialog.shouldGenerateStartupApplication(), newFacetDialog.shouldGeneratePom());
            };
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                ApplicationManager.getApplication().invokeLater(action, ModalityState.NON_MODAL);
            } else {
                action.run();
            }
        });
    }

    public FrameworkRole[] getRoles() {
        return new FrameworkRole[]{JavaeeProjectCategory.ROLE};
    }
}

