/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightEmptyImplementsList;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightVariableBase;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryAccessorMethod
extends LightElement
implements PsiMethod {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tapestry.psi.TapestryAccessorMethod");
    private final PsiField myProperty;
    private final boolean myGetterNotSetter;
    private final String myName;
    private LightParameterList myParameterList;
    private final PsiModifierList myModifierList;
    private static final LightParameter[] EMPTY_PARAMETERS_ARRAY = new LightParameter[0];

    protected TapestryAccessorMethod(PsiField property, boolean getterNotSetter, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tapestry/psi/TapestryAccessorMethod", "<init>"));
        }
        super(property.getManager(), StdLanguages.JAVA);
        this.myProperty = property;
        this.myGetterNotSetter = getterNotSetter;
        this.myName = name;
        this.myModifierList = new LightModifierList(this.getManager()){

            public boolean hasModifierProperty(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tapestry/psi/TapestryAccessorMethod$1", "hasModifierProperty"));
                }
                return "public".equals(name);
            }

            public boolean hasExplicitModifier(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tapestry/psi/TapestryAccessorMethod$1", "hasExplicitModifier"));
                }
                return "public".equals(name);
            }

            public String getText() {
                return "public";
            }
        };
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiField psiField = this.getProperty();
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getNavigationElement"));
        }
        return psiField;
    }

    public PsiField getProperty() {
        return this.myProperty;
    }

    public boolean isGetter() {
        return this.myGetterNotSetter;
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getTypeParameters"));
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    public PsiClass getContainingClass() {
        return this.myProperty.getContainingClass();
    }

    public PsiType getReturnType() {
        return this.myGetterNotSetter ? this.myProperty.getType() : PsiType.VOID;
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myProperty.getTypeElement();
    }

    @NotNull
    public PsiParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightParameterList(this.getManager(), (Computable<LightParameter[]>)((Computable)() -> {
                LightParameter[] lightParameterArray;
                if (this.myGetterNotSetter) {
                    lightParameterArray = EMPTY_PARAMETERS_ARRAY;
                } else {
                    LightParameter[] lightParameterArray2 = new LightParameter[1];
                    lightParameterArray = lightParameterArray2;
                    lightParameterArray2[0] = new LightParameter(this.getManager(), this.myProperty.getName(), null, this.myProperty.getType(), (PsiElement)this);
                }
                return lightParameterArray;
            }));
        }
        LightParameterList lightParameterList = this.myParameterList;
        if (lightParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getParameterList"));
        }
        return lightParameterList;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return this.myProperty.getNameIdentifier();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myModifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getModifierList"));
        }
        return psiModifierList;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tapestry/psi/TapestryAccessorMethod", "setName"));
        }
        return null;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public String toString() {
        return "AccessorMethod";
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        LightEmptyImplementsList lightEmptyImplementsList = new LightEmptyImplementsList(this.getManager());
        if (lightEmptyImplementsList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getThrowsList"));
        }
        return lightEmptyImplementsList;
    }

    @Nullable
    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "findDeepestSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    public PsiMethod findDeepestSuperMethod() {
        return null;
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tapestry/psi/TapestryAccessorMethod", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod", "getName"));
        }
        return string;
    }

    public static class LightParameterList
    extends LightElement
    implements PsiParameterList {
        private final Computable<LightParameter[]> myParametersComputation;
        private LightParameter[] myParameters = null;

        protected LightParameterList(PsiManager manager, Computable<LightParameter[]> parametersComputation) {
            super(manager, StdLanguages.JAVA);
            this.myParametersComputation = parametersComputation;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameterList", "accept"));
            }
            if (visitor instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor).visitParameterList((PsiParameterList)this);
            }
        }

        @NotNull
        public PsiParameter[] getParameters() {
            if (this.myParameters == null) {
                this.myParameters = (LightParameter[])this.myParametersComputation.compute();
            }
            if (this.myParameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameterList", "getParameters"));
            }
            return this.myParameters;
        }

        public int getParameterIndex(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameterList", "getParameterIndex"));
            }
            LOG.assertTrue(parameter.getParent() == this);
            return PsiImplUtil.getParameterIndex((PsiParameter)parameter, (PsiParameterList)this);
        }

        public int getParametersCount() {
            return this.getParameters().length;
        }

        public String toString() {
            return "Light Parameter List";
        }
    }

    public static class LightParameter
    extends LightVariableBase
    implements PsiParameter {
        private final String myName;

        public LightParameter(PsiManager manager, String name, PsiIdentifier nameIdentifier, @NotNull PsiType type, PsiElement scope) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameter", "<init>"));
            }
            super(manager, nameIdentifier, type, false, scope);
            this.myName = name;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameter", "accept"));
            }
            if (visitor instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor).visitParameter((PsiParameter)this);
            }
        }

        public String toString() {
            return "Light Parameter";
        }

        public boolean isVarArgs() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TapestryAccessorMethod$LightParameter", "getName"));
            }
            return string;
        }
    }
}

