/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.glassfish.server.GlassfishExtensions;
import com.intellij.javaee.oss.glassfish.server.GlassfishRemoteModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentModelWithContext;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Glassfish3AdminServerBase
extends JavaeeAgentAdminServerBase {
    private static final String SPECIFICS_MODULE_NAME = "idea-glassfish-srv3";
    private static final String SPECIFICS_JAR_PATH = "specifics/glassfish3-specifics.jar";
    private final boolean mySecured;
    private final GlassfishServerModel myServerModel;
    private final boolean mySpecifyName;

    protected Glassfish3AdminServerBase(AgentProxyFactory agentProxyFactory, List<File> libraries, String agentClassName, boolean secured, GlassfishServerModel serverModel, boolean specifyName) throws Exception {
        super(agentProxyFactory, libraries, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, agentClassName);
        this.mySecured = secured;
        this.myServerModel = serverModel;
        this.mySpecifyName = specifyName;
    }

    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        if (this.myServerModel instanceof GlassfishRemoteModel) {
            GlassfishRemoteModel model = (GlassfishRemoteModel)this.myServerModel;
            host = model.getAdminServerHost();
            port = model.getAdminServerPort();
        }
        super.start(host, port, username, password, callback);
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) {
        String appName = JavaeeDeploymentProvider.getFacetDefinedDeploymentName((DeploymentModel)deployment);
        if (appName != null) {
            String string = appName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/admin/Glassfish3AdminServerBase", "getDeploymentName"));
            }
            return string;
        }
        String sourceFilename = source.getName();
        Artifact artifact = deployment.getArtifact();
        if (artifact != null && GlassfishExtensions.getInstance().isValidExtension(artifact.getArtifactType(), FileUtilRt.getExtension((String)sourceFilename))) {
            String string = FileUtil.getNameWithoutExtension((String)sourceFilename);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/admin/Glassfish3AdminServerBase", "getDeploymentName"));
            }
            return string;
        }
        String string = sourceFilename;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/admin/Glassfish3AdminServerBase", "getDeploymentName"));
        }
        return string;
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        boolean isCluster;
        initParameters.put((Object)"is.secured", (Object)Boolean.toString(this.mySecured));
        boolean bl = isCluster = this.myServerModel instanceof GlassfishRemoteModel && ((GlassfishRemoteModel)this.myServerModel).isDeployOnCluster();
        if (!isCluster) {
            initParameters.put((Object)"virtual.server", (Object)this.myServerModel.getVirtualServer());
        }
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
        GlassfishServerModel serverModel = (GlassfishServerModel)deployment.getCommonModel().getServerModel();
        String sourcePath = source.getAbsolutePath();
        boolean useGlassfishUpload = false;
        if (serverModel instanceof GlassfishRemoteModel) {
            GlassfishRemoteModel remoteServerModel = (GlassfishRemoteModel)serverModel;
            if (remoteServerModel.isDeployOnCluster()) {
                deployParameters.put((Object)"deploy.target", (Object)remoteServerModel.CLUSTER_NAME);
            }
            if (remoteServerModel.isUploadWithGlassfish()) {
                useGlassfishUpload = JavaeeServerInstanceImpl.isRemote((DeploymentModel)deployment);
            } else {
                sourcePath = remoteServerModel.prepareDeployment(sourcePath, false);
            }
        }
        deployParameters.put((Object)"use.glassfish.upload", (Object)Boolean.toString(useGlassfishUpload));
        deployParameters.put((Object)"keep.sessions", (Object)Boolean.toString(serverModel.PRESERVE));
        deployParameters.put((Object)"compatibility", (Object)Boolean.toString(serverModel.COMPATIBILITY));
        JavaeeDeploymentModelWithContext glassfishDeployment = (JavaeeDeploymentModelWithContext)deployment;
        deployParameters.put((Object)"is.default.context.root", (Object)Boolean.toString(glassfishDeployment.isDefaultContextRoot()));
        deployParameters.put((Object)"context.root", (Object)glassfishDeployment.getContextRoot());
        deployParameters.put((Object)"source.path", (Object)sourcePath);
        boolean specifyName = this.mySpecifyName || deployment.getArtifact() == null;
        deployParameters.put((Object)"specify.name", (Object)Boolean.toString(specifyName));
    }
}

