/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.google.gson.stream.JsonToken;
import com.jetbrains.firefox.FirefoxArray;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxFunction;
import com.jetbrains.firefox.FirefoxObject;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxValueManager$WhenMappings;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Grip;
import com.jetbrains.firefox.rdp.PropertyDescriptor;
import com.jetbrains.firefox.rdp.SafeGetterValue;
import com.jetbrains.firefox.rdp.ValueHolder;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ObjectPropertyImpl;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016JB\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0013J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J&\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\u00162\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020%J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0016H\u0002J\"\u0010)\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00162\b\u0010*\u001a\u0004\u0018\u00010+J&\u0010,\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u00162\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.J\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lcom/jetbrains/firefox/FirefoxValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "actorsNotYetPromotedToThreadLifetime", "Ljava/util/ArrayList;", "", "refToValue", "Lgnu/trove/THashMap;", "Lorg/jetbrains/debugger/values/Value;", "getVm", "()Lcom/jetbrains/firefox/FirefoxVm;", "clearCaches", "", "createProperties", "", "Lorg/jetbrains/debugger/Variable;", "propertyDescriptors", "", "Lcom/jetbrains/firefox/rdp/PropertyDescriptor;", "prototypeGrip", "Lcom/jetbrains/firefox/rdp/Grip;", "safeGetterValues", "Lcom/jetbrains/firefox/rdp/SafeGetterValue;", "createProperty", "name", "descriptor", "getterValueDescriptor", "createProtoVariable", "Lorg/jetbrains/debugger/VariableImpl;", "createValue", "valueData", "primitiveValue", "primitiveValueType", "Lcom/google/gson/stream/JsonToken;", "valueHolder", "Lcom/jetbrains/firefox/rdp/ValueHolder;", "createValueAccessor", "Lorg/jetbrains/debugger/values/FunctionValue;", "grip", "createVariable", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "doCreateValue", "promoteRecentlyAddedActorsToThreadLifetime", "Lorg/jetbrains/concurrency/Promise;", "", "release", "FirefoxConnector"})
public final class FirefoxValueManager
extends ValueManager {
    private final THashMap<String, Value> refToValue;
    private final ArrayList<String> actorsNotYetPromotedToThreadLifetime;
    @NotNull
    private final FirefoxVm vm;

    @NotNull
    public final List<Variable> createProperties(@Nullable Map<String, ? extends PropertyDescriptor> propertyDescriptors, @Nullable Grip prototypeGrip, @Nullable Map<String, ? extends SafeGetterValue> safeGetterValues) {
        VariableImpl prototype;
        VariableImpl variableImpl = prototype = prototypeGrip == null ? null : this.createProtoVariable(prototypeGrip);
        if (propertyDescriptors == null || propertyDescriptors.isEmpty()) {
            return prototype == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)prototype);
        }
        Variable[] variables = new Variable[propertyDescriptors.size() + (prototype == null ? 0 : 1)];
        int i = 0;
        Map<String, ? extends PropertyDescriptor> map = propertyDescriptors;
        Iterator<Map.Entry<String, ? extends PropertyDescriptor>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends PropertyDescriptor> entry;
            Map.Entry<String, ? extends PropertyDescriptor> entry2 = entry = iterator.next();
            String name = entry2.getKey();
            entry2 = entry;
            PropertyDescriptor value = entry2.getValue();
            int n = i++;
            Map<String, ? extends SafeGetterValue> map2 = safeGetterValues;
            variables[n] = this.createProperty(name, value, map2 != null ? map2.get(name) : null);
        }
        if (prototype != null) {
            variables[((Object[])variables).length - 1] = (Variable)prototype;
        }
        List<Variable> list = Arrays.asList(Arrays.copyOf(variables, variables.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<Variable>(*variables)");
        return list;
    }

    @NotNull
    public final VariableImpl createProtoVariable(@Nullable Grip prototypeGrip) {
        return this.createVariable("__proto__", prototypeGrip, null);
    }

    @NotNull
    public final Variable createProperty(@NotNull String name, @NotNull PropertyDescriptor descriptor, @Nullable SafeGetterValue getterValueDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        int flags = 0;
        if (descriptor.writable()) {
            flags |= ObjectPropertyImpl.Companion.getWRITABLE();
        }
        if (descriptor.configurable()) {
            flags |= ObjectPropertyImpl.Companion.getCONFIGURABLE();
        }
        if (descriptor.enumerable()) {
            flags |= ObjectPropertyImpl.Companion.getENUMERABLE();
        }
        SafeGetterValue safeGetterValue = getterValueDescriptor;
        return (Variable)new ObjectPropertyImpl(name, this.createValue(safeGetterValue != null ? (ValueHolder)safeGetterValue : (ValueHolder)descriptor), getterValueDescriptor == null ? this.createValueAccessor(descriptor.get()) : null, getterValueDescriptor == null ? this.createValueAccessor(descriptor.set()) : null, null, flags);
    }

    private final FunctionValue createValueAccessor(Grip grip) {
        if (grip == null || grip.type() == Grip.Type.UNDEFINED) {
            return null;
        }
        Value value = this.createValue(grip, null, null);
        return value instanceof FunctionValue ? (FunctionValue)value : null;
    }

    @NotNull
    public final VariableImpl createVariable(@NotNull String name, @Nullable Grip valueData, @Nullable ValueModifier valueModifier) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new VariableImpl(name, this.createValue(valueData, null, null), valueModifier);
    }

    @Nullable
    public final Value createValue(@NotNull ValueHolder valueHolder) {
        Intrinsics.checkParameterIsNotNull((Object)valueHolder, (String)"valueHolder");
        return this.createValue(valueHolder.value(), valueHolder.primitiveValue(), valueHolder.primitiveValueType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value createValue(@Nullable Grip valueData, @Nullable String primitiveValue, @Nullable JsonToken primitiveValueType) {
        if (valueData == null && primitiveValue == null) {
            return null;
        }
        Object object = valueData;
        if (object == null || (object = object.actor()) == null) {
            return this.doCreateValue(valueData, primitiveValue, primitiveValueType);
        }
        Object actor = object;
        THashMap<String, Value> tHashMap = this.refToValue;
        synchronized (tHashMap) {
            Value value = (Value)this.refToValue.get(actor);
            if (value == null) {
                value = this.doCreateValue(valueData, primitiveValue, primitiveValueType);
                this.refToValue.put(actor, (Object)value);
                this.actorsNotYetPromotedToThreadLifetime.add((String)actor);
            }
            Value value2 = value;
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> promoteRecentlyAddedActorsToThreadLifetime() {
        THashMap<String, Value> tHashMap = this.refToValue;
        synchronized (tHashMap) {
            void var2_3;
            block5: {
                if (!this.actorsNotYetPromotedToThreadLifetime.isEmpty()) break block5;
                Promise promise = Promises.resolvedPromise();
                return promise;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
            String string = this.vm.getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.pauseLifetimeGripsToThreadLifetime(string, (List<String>)this.actorsNotYetPromotedToThreadLifetime));
            this.actorsNotYetPromotedToThreadLifetime.clear();
            void var4_4 = var2_3;
            return var4_4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Value doCreateValue(Grip valueData, String primitiveValue, JsonToken primitiveValueType) {
        boolean valueType2;
        if (primitiveValue != null) {
            boolean bl;
            boolean bl2 = bl = primitiveValueType != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            JsonToken jsonToken = primitiveValueType;
            if (jsonToken != null) {
                switch (FirefoxValueManager$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                    case 1: {
                        ValueType valueType2 = ValueType.STRING;
                        return (Value)new PrimitiveValue(valueType2, primitiveValue);
                    }
                    case 2: {
                        ValueType valueType2 = ValueType.NUMBER;
                        return (Value)new PrimitiveValue(valueType2, primitiveValue);
                    }
                    case 3: {
                        return (Value)PrimitiveValue.Companion.bool(primitiveValue);
                    }
                    case 4: {
                        return (Value)PrimitiveValue.NULL;
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported type ");
            JsonToken jsonToken2 = primitiveValueType;
            if (jsonToken2 != null) throw (Throwable)new UnsupportedOperationException(stringBuilder.append(jsonToken2).toString());
            Intrinsics.throwNpe();
            throw (Throwable)new UnsupportedOperationException(stringBuilder.append(jsonToken2).toString());
        }
        boolean bl = valueType2 = valueData != null;
        if (_Assertions.ENABLED && !valueType2) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Grip grip = valueData;
        if (grip == null) {
            Intrinsics.throwNpe();
        }
        switch (FirefoxValueManager$WhenMappings.$EnumSwitchMapping$1[grip.type().ordinal()]) {
            case 1: {
                ValueType valueType3 = null;
                Grip.Preview preview = valueData.preview();
                if (preview != null) {
                    if (preview.kind() == Grip.Preview.Kind.DOM_NODE) {
                        valueType3 = ValueType.NODE;
                    } else if (preview.kind() == Grip.Preview.Kind.ARRAY_LIKE) {
                        if (preview.length() != -1) return (Value)new FirefoxArray(preview.length(), valueData, this);
                        valueType3 = ValueType.ARRAY;
                    }
                }
                if (valueType3 != null) return (Value)new FirefoxObject(valueType3, valueData, this);
                if (Intrinsics.areEqual((Object)"Array", (Object)valueData.className())) {
                    valueType3 = ValueType.ARRAY;
                    return (Value)new FirefoxObject(valueType3, valueData, this);
                }
                if (Intrinsics.areEqual((Object)"Function", (Object)valueData.className())) {
                    return (Value)new FirefoxFunction(valueData, this);
                }
                valueType3 = ValueType.OBJECT;
                return (Value)new FirefoxObject(valueType3, valueData, this);
            }
            case 2: {
                return (Value)PrimitiveValue.Companion.getNAN();
            }
            case 3: {
                return (Value)PrimitiveValue.Companion.getINFINITY();
            }
            case 4: {
                return (Value)PrimitiveValue.UNDEFINED;
            }
            case 5: {
                return (Value)PrimitiveValue.NULL;
            }
        }
        throw (Throwable)new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> release() {
        this.markObsolete();
        THashMap<String, Value> tHashMap = this.refToValue;
        synchronized (tHashMap) {
            void var2_3;
            block5: {
                this.actorsNotYetPromotedToThreadLifetime.clear();
                if (!this.refToValue.isEmpty()) break block5;
                Promise promise = Promises.resolvedPromise();
                return promise;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
            String string = this.vm.getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Set set = this.refToValue.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"refToValue.keys");
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.release(string, set));
            this.refToValue.clear();
            void var4_4 = var2_3;
            return var4_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        THashMap<String, Value> tHashMap = this.refToValue;
        synchronized (tHashMap) {
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final FirefoxVm getVm() {
        return this.vm;
    }

    public FirefoxValueManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.refToValue = new THashMap();
        this.actorsNotYetPromotedToThreadLifetime = new ArrayList();
    }
}

