/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtilRt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitAction;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends GitAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/actions/GitResolveConflictsAction", "actionPerformed"));
        }
        Project project = (Project)ObjectUtils.assertNotNull((Object)event.getProject());
        GitVcs vcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        TreeSet<VirtualFile> conflictedFiles = new TreeSet<VirtualFile>((f1, f2) -> f1.getPresentableUrl().compareTo(f2.getPresentableUrl()));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file = before.getFile().getVirtualFile()) != null) {
                conflictedFiles.add(file);
            }
            if (after == null || (file = after.getFile().getVirtualFile()) == null) continue;
            conflictedFiles.add(file);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog((List)ContainerUtilRt.newArrayList(conflictedFiles), vcs.getMergeProvider());
        for (GitRepository repository : GitUtil.getRepositoriesForFiles(project, conflictedFiles)) {
            repository.update();
        }
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/actions/GitResolveConflictsAction", "isEnabled"));
        }
        Collection changes = ChangeListManager.getInstance((Project)event.getProject()).getAllChanges();
        if (changes.size() > 1000) {
            return true;
        }
        for (Change change : changes) {
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/GitResolveConflictsAction", "update"));
        }
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(e.getPresentation().isEnabled());
        }
    }
}

