/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    public static final GitBranchesCollection EMPTY = new GitBranchesCollection(Collections.emptyMap(), Collections.emptyMap());
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches) {
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/branch/GitBranchesCollection", "<init>"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranches", "git4idea/branch/GitBranchesCollection", "<init>"));
        }
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Collection<GitLocalBranch> collection = Collections.unmodifiableCollection(this.myLocalBranches.keySet());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchesCollection", "getLocalBranches"));
        }
        return collection;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Collection<GitRemoteBranch> collection = Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchesCollection", "getRemoteBranches"));
        }
        return collection;
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/branch/GitBranchesCollection", "getHash"));
        }
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findLocalBranch"));
        }
        return GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findBranchByName"));
        }
        GitLocalBranch branch = GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name);
        return branch != null ? branch : GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    private static <T extends GitBranch> T findByName(Collection<T> branches, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "findByName"));
        }
        return (T)((GitBranch)ContainerUtil.find(branches, branch -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBranchesCollection", "lambda$findByName$0"));
            }
            return GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)name, (Object)branch.getName());
        }));
    }
}

