/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitUtil;
import git4idea.rebase.GitCommitEditingAction;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends GitCommitEditingAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);
    private static final String FAILURE_TITLE = "Can't Undo Commit";

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/reset/GitUncommitAction", "update"));
        }
        super.update(e);
        if (e.getPresentation().isEnabledAndVisible()) {
            DataPackBase dataPackBase = ((VisiblePack)this.getUi(e).getDataPack()).getDataPack();
            if (!(dataPackBase instanceof DataPack)) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                return;
            }
            DataPack dataPack = (DataPack)dataPackBase;
            VcsShortCommitDetails commit = (VcsShortCommitDetails)((VcsLog)ObjectUtils.notNull((Object)this.getLog(e))).getSelectedShortDetails().get(0);
            int commitIndex = this.getLogData(e).getCommitIndex((Hash)commit.getId(), commit.getRoot());
            List children = dataPack.getPermanentGraph().getChildren((Object)commitIndex);
            if (!children.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/reset/GitUncommitAction", "actionPerformed"));
        }
        super.actionPerformed(e);
        Project project = (Project)ObjectUtils.notNull((Object)e.getProject());
        VcsShortCommitDetails commit = this.getSelectedCommit(e);
        ChangeListChooser chooser = new ChangeListChooser(project, (Collection)ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", commit.getSubject());
        chooser.show();
        LocalChangeList selectedList = chooser.getSelectedList();
        if (selectedList != null) {
            GitUncommitAction.resetInBackground(this.getLogData(e), this.getRepository(e), commit, selectedList);
        }
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        if (FAILURE_TITLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "getFailureTitle"));
        }
        return FAILURE_TITLE;
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit, final @NotNull LocalChangeList changeList) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        final Project project = repository.getProject();
        new Task.Backgroundable(project, "Undoing Last Commit...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection changesInCommit;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitUncommitAction$1", "run"));
                }
                try {
                    changesInCommit = GitUncommitAction.getChangesInCommit(data, commit);
                }
                catch (VcsException e) {
                    String message = "Couldn't load changes of " + ((Hash)commit.getId()).asString();
                    LOG.warn(message, (Throwable)e);
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.ERROR, null);
                    VcsNotifier.getInstance((Project)project).notify(notification);
                    return;
                }
                new GitResetOperation(project, Collections.singletonMap(repository, commit.getParents().get(0)), GitResetMode.SOFT, indicator).execute();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)project);
                changeListManager.invokeAfterUpdate(() -> {
                    if (changeList == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "git4idea/reset/GitUncommitAction$1", "lambda$run$0"));
                    }
                    Collection<Change> changes = GitUtil.findCorrespondentLocalChanges((ChangeListManager)changeListManager, changesInCommit);
                    changeListManager.moveChangesTo(changeList, (Change[])ArrayUtil.toObjectArray(changes, Change.class));
                }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing Changes...", ModalityState.defaultModalityState());
            }
        }.queue();
    }

    @NotNull
    private static Collection<Change> getChangesInCommit(@NotNull VcsLogData data, @NotNull VcsShortCommitDetails commit) throws VcsException {
        VirtualFile root;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        Hash hash = (Hash)commit.getId();
        VcsFullCommitDetails details = GitUncommitAction.getChangesFromCache(data, hash, root = commit.getRoot());
        if (details == null) {
            details = VcsLogUtil.getDetails((VcsLogData)data, (VirtualFile)root, (Hash)hash);
        }
        Collection collection = details.getChanges();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        return collection;
    }

    @Nullable
    private static VcsFullCommitDetails getChangesFromCache(@NotNull VcsLogData data, @NotNull Hash hash, @NotNull VirtualFile root) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        Ref details = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$0"));
            }
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$0"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$0"));
            }
            details.set((Object)data.getCommitDetailsGetter().getCommitDataIfAvailable(data.getCommitIndex(hash, root)));
        });
        if (details.isNull() || details.get() instanceof LoadingDetails) {
            return null;
        }
        return (VcsFullCommitDetails)details.get();
    }
}

