/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.model.xml.components.SeamEvent;
import com.intellij.seam.model.xml.components.SeamImport;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.model.impl.DomModelImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SeamDomModelImpl
extends DomModelImpl<SeamComponents>
implements SeamDomModel {
    private final Module myModule;
    private final NotNullLazyValue<List<SeamDomComponent>> myDomComponents;
    private final NotNullLazyValue<List<SeamImport>> myImports;
    private final NotNullLazyValue<List<SeamEvent>> myEventTypes;
    private final NotNullLazyValue<List<SeamDomFactory>> myFactories;
    private final ConcurrentFactoryMap<PsiType, List<SeamDomComponent>> myComponentsByClass;
    private final ConcurrentFactoryMap<String, List<SeamDomComponent>> myComponentsByName;

    public SeamDomModelImpl(@NotNull Module module, @NotNull DomFileElement<SeamComponents> mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "<init>"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "<init>"));
        }
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "<init>"));
        }
        super(mergedModel, configFiles);
        this.myDomComponents = new NotNullLazyValue<List<SeamDomComponent>>(){

            @NotNull
            protected List<SeamDomComponent> compute() {
                ArrayList<SeamDomComponent> seamDomComponents = new ArrayList<SeamDomComponent>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamDomComponent domComponent : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamDomComponent.class)) {
                        seamDomComponents.add(domComponent);
                    }
                }
                ArrayList<SeamDomComponent> arrayList = seamDomComponents;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$1", "compute"));
                }
                return arrayList;
            }
        };
        this.myImports = new NotNullLazyValue<List<SeamImport>>(){

            @NotNull
            protected List<SeamImport> compute() {
                ArrayList<SeamImport> seamImports = new ArrayList<SeamImport>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamImport seamImport : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamImport.class)) {
                        seamImports.add(seamImport);
                    }
                }
                ArrayList<SeamImport> arrayList = seamImports;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$2", "compute"));
                }
                return arrayList;
            }
        };
        this.myEventTypes = new NotNullLazyValue<List<SeamEvent>>(){

            @NotNull
            protected List<SeamEvent> compute() {
                ArrayList<SeamEvent> seamEventTypes = new ArrayList<SeamEvent>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamEvent seamEventType : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamEvent.class)) {
                        seamEventTypes.add(seamEventType);
                    }
                }
                ArrayList<SeamEvent> arrayList = seamEventTypes;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$3", "compute"));
                }
                return arrayList;
            }
        };
        this.myFactories = new NotNullLazyValue<List<SeamDomFactory>>(){

            @NotNull
            protected List<SeamDomFactory> compute() {
                ArrayList<SeamDomFactory> factories = new ArrayList<SeamDomFactory>();
                for (DomFileElement element : SeamDomModelImpl.this.getRoots()) {
                    for (SeamDomFactory domFactory : DomUtil.getDefinedChildrenOfType((DomElement)element.getRootElement(), SeamDomFactory.class)) {
                        factories.add(domFactory);
                    }
                }
                ArrayList<SeamDomFactory> arrayList = factories;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl$4", "compute"));
                }
                return arrayList;
            }
        };
        this.myComponentsByClass = new ConcurrentFactoryMap<PsiType, List<SeamDomComponent>>(){

            protected List<SeamDomComponent> create(PsiType key) {
                return SeamDomModelImpl.this.computeSeamComponentsByPsiType(key);
            }
        };
        this.myComponentsByName = new ConcurrentFactoryMap<String, List<SeamDomComponent>>(){

            protected List<SeamDomComponent> create(String key) {
                return SeamDomModelImpl.this.computeSeamComponentsByName(key);
            }
        };
        this.myModule = module;
    }

    private List<SeamDomComponent> computeSeamComponentsByName(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "computeSeamComponentsByName"));
        }
        ArrayList<SeamDomComponent> components = new ArrayList<SeamDomComponent>();
        for (SeamDomComponent domComponent : this.getSeamComponents()) {
            if (!componentName.equals(domComponent.getComponentName())) continue;
            components.add(domComponent);
        }
        return components;
    }

    private List<SeamDomComponent> computeSeamComponentsByPsiType(PsiType PsiType2) {
        ArrayList<SeamDomComponent> components = new ArrayList<SeamDomComponent>();
        for (SeamDomComponent domComponent : this.getSeamComponents()) {
            PsiType componentClass = domComponent.getComponentType();
            if (!PsiType2.equals(componentClass)) continue;
            components.add(domComponent);
        }
        return components;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents() {
        List list = (List)this.myDomComponents.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getSeamComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getSeamComponents"));
        }
        List list = (List)this.myComponentsByClass.get((Object)psiType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getSeamComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomComponent> getSeamComponents(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getSeamComponents"));
        }
        List list = (List)this.myComponentsByName.get((Object)componentName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getSeamComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamImport> getImports() {
        List list = (List)this.myImports.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getImports"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamDomFactory> getFactories() {
        List list = (List)this.myFactories.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getFactories"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SeamEvent> getEvents() {
        List list = (List)this.myEventTypes.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/impl/model/xml/SeamDomModelImpl", "getEvents"));
        }
        return list;
    }

    public Module getModule() {
        return this.myModule;
    }
}

