/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.context;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.application.JavaeeModule;
import com.intellij.javaee.model.xml.application.Web;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultWebModuleContextProvider
implements WebModuleContextProvider {
    public static final DefaultWebModuleContextProvider INSTANCE = new DefaultWebModuleContextProvider();

    private DefaultWebModuleContextProvider() {
    }

    @Override
    @Nullable
    public String getContext(@NotNull JavaeeApplicationFacet earFacet, @Nullable String moduleWebUri) {
        if (earFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earFacet", "com/intellij/javaee/context/DefaultWebModuleContextProvider", "getContext"));
        }
        JavaeeApplication javaeeApplication = earFacet.getRoot();
        return javaeeApplication == null ? null : DefaultWebModuleContextProvider.getContext(javaeeApplication, moduleWebUri);
    }

    @Nullable
    public static String getContext(@NotNull JavaeeApplication javaeeApplication, @Nullable String moduleWebUri) {
        if (javaeeApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeApplication", "com/intellij/javaee/context/DefaultWebModuleContextProvider", "getContext"));
        }
        List<JavaeeModule> modules = javaeeApplication.getModules();
        for (JavaeeModule module : modules) {
            String contextRoot;
            Web web = module.getWeb();
            String webUri = (String)web.getWebUri().getValue();
            if (moduleWebUri != null && !moduleWebUri.equals(webUri) || (contextRoot = (String)web.getContextRoot().getValue()) == null) continue;
            return contextRoot;
        }
        return null;
    }
}

