/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TRootElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowElementConverter
extends ResolvingConverter<TBaseElement> {
    public TBaseElement fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        BpmnDomModel domModel = FlowElementConverter.getDomModel(context);
        if (domModel == null) {
            return null;
        }
        TDefinitions definitions = domModel.getDefinitions();
        List<TBaseElement> identifiedList = FlowElementConverter.getAllFlowElements(definitions);
        for (TBaseElement identified : identifiedList) {
            if (!s.equals(identified.getId().getStringValue())) continue;
            return identified;
        }
        return null;
    }

    public LookupElement createLookupElement(TBaseElement identified) {
        return FlowElementConverter.createLookupElementImpl(identified);
    }

    public static LookupElement createLookupElementImpl(TBaseElement identified) {
        ElementPresentation elementPresentation = identified.getPresentation();
        String id = (String)identified.getId().getValue();
        LookupElementBuilder builder = LookupElementBuilder.create((Object)identified.getXmlTag(), (String)StringUtil.notNullize((String)id)).withIcon(elementPresentation.getIcon());
        String name = elementPresentation.getElementName();
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            return builder.withTailText(" " + name + " (" + identified.getXmlTag().getContainingFile().getName() + ")", true);
        }
        return builder.withTailText(" (" + identified.getXmlTag().getContainingFile().getName() + ")", true);
    }

    @Nullable
    public static BpmnDomModel getDomModel(ConvertContext context) {
        XmlFile xmlFile = context.getFile();
        return BpmnDomModelManager.getInstance(xmlFile.getProject()).getModel(xmlFile);
    }

    public String toString(@Nullable TBaseElement identified, ConvertContext context) {
        if (identified == null) {
            return null;
        }
        return identified.getId().getStringValue();
    }

    @NotNull
    public Collection<TBaseElement> getVariants(ConvertContext context) {
        BpmnDomModel model = FlowElementConverter.getDomModel(context);
        List<TBaseElement> list = model == null ? Collections.emptyList() : FlowElementConverter.getAllFlowElements(model.getDefinitions());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/converters/FlowElementConverter", "getVariants"));
        }
        return list;
    }

    @NotNull
    private static List<TBaseElement> getAllFlowElements(@Nullable TDefinitions definitions) {
        if (definitions == null) {
            List<TBaseElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/converters/FlowElementConverter", "getAllFlowElements"));
            }
            return list;
        }
        ArrayList<TBaseElement> identifiedList = new ArrayList<TBaseElement>();
        FlowElementConverter.addFlowElement(definitions, identifiedList);
        ArrayList<TBaseElement> arrayList = identifiedList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/converters/FlowElementConverter", "getAllFlowElements"));
        }
        return arrayList;
    }

    private static void addFlowElement(TDefinitions definitions, List<TBaseElement> identifiedList) {
        List<TRootElement> elements = definitions.getRootElements();
        BpmnUtils.processAllElements(elements, node -> {
            identifiedList.add((TBaseElement)node);
            return true;
        }, TFlowNode.class);
    }
}

