/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.graph.dnd;

import com.intellij.jboss.jpdl.graph.JpdlDataModel;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.graph.JpdlNodeType;
import com.intellij.jboss.jpdl.graph.nodes.CustomNode;
import com.intellij.jboss.jpdl.graph.nodes.DecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.EndActivityNode;
import com.intellij.jboss.jpdl.graph.nodes.ForkNode;
import com.intellij.jboss.jpdl.graph.nodes.GroupNode;
import com.intellij.jboss.jpdl.graph.nodes.HqlNode;
import com.intellij.jboss.jpdl.graph.nodes.JavaNode;
import com.intellij.jboss.jpdl.graph.nodes.JoinNode;
import com.intellij.jboss.jpdl.graph.nodes.MailNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesDecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesNode;
import com.intellij.jboss.jpdl.graph.nodes.ScriptNode;
import com.intellij.jboss.jpdl.graph.nodes.SqlNode;
import com.intellij.jboss.jpdl.graph.nodes.StartNode;
import com.intellij.jboss.jpdl.graph.nodes.StateNode;
import com.intellij.jboss.jpdl.graph.nodes.SubProcessNode;
import com.intellij.jboss.jpdl.graph.nodes.TaskNode;
import com.intellij.jboss.jpdl.model.xml.Custom;
import com.intellij.jboss.jpdl.model.xml.Decision;
import com.intellij.jboss.jpdl.model.xml.End;
import com.intellij.jboss.jpdl.model.xml.EndCancel;
import com.intellij.jboss.jpdl.model.xml.EndError;
import com.intellij.jboss.jpdl.model.xml.Fork;
import com.intellij.jboss.jpdl.model.xml.Group;
import com.intellij.jboss.jpdl.model.xml.Hql;
import com.intellij.jboss.jpdl.model.xml.Join;
import com.intellij.jboss.jpdl.model.xml.Mail;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.jboss.jpdl.model.xml.Rules;
import com.intellij.jboss.jpdl.model.xml.RulesDecision;
import com.intellij.jboss.jpdl.model.xml.Script;
import com.intellij.jboss.jpdl.model.xml.Sql;
import com.intellij.jboss.jpdl.model.xml.Start;
import com.intellij.jboss.jpdl.model.xml.State;
import com.intellij.jboss.jpdl.model.xml.SubProcess;
import com.intellij.jboss.jpdl.model.xml.Task;
import com.intellij.jboss.jpdl.model.xml.wireObjectGroup.JavaActivity;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import icons.JbpmIcons;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JpdlDnDSupport
implements GraphDnDSupport<JpdlNode, JpdlNodeType> {
    private final JpdlDataModel myDataModel;
    private static final String UNKNOWN = "unknown";

    public JpdlDnDSupport(JpdlDataModel dataModel) {
        this.myDataModel = dataModel;
    }

    public Map<JpdlNodeType, Pair<String, Icon>> getDnDActions() {
        LinkedHashMap<JpdlNodeType, Pair<String, Icon>> nodes = new LinkedHashMap<JpdlNodeType, Pair<String, Icon>>();
        nodes.put(JpdlNodeType.START, Pair.create((Object)"Start", (Object)JbpmIcons.Jpdl.Start));
        nodes.put(JpdlNodeType.STATE, Pair.create((Object)"State", (Object)JbpmIcons.Jpdl.Page));
        nodes.put(JpdlNodeType.TASK, Pair.create((Object)"Task", (Object)JbpmIcons.Jpdl.Task));
        nodes.put(JpdlNodeType.JAVA, Pair.create((Object)"Java", (Object)PlatformIcons.CLASS_ICON));
        nodes.put(JpdlNodeType.DECISIION, Pair.create((Object)"Decision", (Object)JbpmIcons.Jpdl.Decision));
        nodes.put(JpdlNodeType.FORK, Pair.create((Object)"Fork", (Object)JbpmIcons.Jpdl.Fork));
        nodes.put(JpdlNodeType.JOIN, Pair.create((Object)"Join", (Object)JbpmIcons.Jpdl.Join));
        nodes.put(JpdlNodeType.SUBPROCESS, Pair.create((Object)"Sub Process", (Object)JbpmIcons.Jpdl.SubProcess));
        nodes.put(JpdlNodeType.CUSTOM, Pair.create((Object)"Custom", (Object)JbpmIcons.Jpdl.Custom));
        nodes.put(JpdlNodeType.SCRIPT, Pair.create((Object)"Script", (Object)JbpmIcons.Jpdl.Script));
        nodes.put(JpdlNodeType.SQL, Pair.create((Object)"Sql", (Object)JbpmIcons.Jpdl.Sql));
        nodes.put(JpdlNodeType.HQL, Pair.create((Object)"Hql", (Object)JbpmIcons.Jpdl.Hql));
        nodes.put(JpdlNodeType.RULES, Pair.create((Object)"Rules", (Object)JbpmIcons.Jpdl.Rule));
        nodes.put(JpdlNodeType.RULES_DECISION, Pair.create((Object)"Rules Decision", (Object)JbpmIcons.Jpdl.Rule_decision));
        nodes.put(JpdlNodeType.MAIL, Pair.create((Object)"Mail", (Object)JbpmIcons.Jpdl.Mail));
        nodes.put(JpdlNodeType.GROUP, Pair.create((Object)"Group", (Object)JbpmIcons.Jpdl.Process));
        nodes.put(JpdlNodeType.END, Pair.create((Object)"End", (Object)JbpmIcons.Jpdl.End));
        nodes.put(JpdlNodeType.END_CANCEL, Pair.create((Object)"End Cancel", (Object)JbpmIcons.Jpdl.End_cancel));
        nodes.put(JpdlNodeType.END_ERROR, Pair.create((Object)"End Error", (Object)JbpmIcons.Jpdl.End_error));
        return nodes;
    }

    public boolean canStartDragging(JpdlNodeType jpdlNodeType) {
        ProcessDefinition processDefinition = this.getDataModel().getProcessDefinition();
        if (processDefinition != null && jpdlNodeType == JpdlNodeType.START) {
            return processDefinition.getStarts().size() == 0;
        }
        return true;
    }

    public JpdlNode drop(JpdlNodeType jpdlNodeType) {
        ProcessDefinition processDefinition = this.getDataModel().getProcessDefinition();
        if (processDefinition == null) {
            return null;
        }
        Project project = this.getDataModel().getProject();
        switch (jpdlNodeType) {
            case STATE: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropStateFunction());
            }
            case TASK: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropTaskFunction());
            }
            case FORK: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropForkFunction());
            }
            case JOIN: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropJoinFunction());
            }
            case JAVA: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropJavaFunction());
            }
            case CUSTOM: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropCustomFunction());
            }
            case DECISIION: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropDecisionFunction());
            }
            case START: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropStartFunction());
            }
            case SUBPROCESS: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropSubProcessFunction());
            }
            case END: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropEndFunction());
            }
            case MAIL: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropMailFunction());
            }
            case END_CANCEL: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropEndCancelFunction());
            }
            case END_ERROR: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, JpdlDnDSupport.getDropEndErrorFunction());
            }
            case SCRIPT: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropScriptFunction());
            }
            case RULES: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropRuleFunction());
            }
            case RULES_DECISION: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropRulesDecisionFunction());
            }
            case SQL: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropSqlFunction());
            }
            case HQL: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropHqlFunction());
            }
            case GROUP: {
                return JpdlDnDSupport.startInWCA(project, processDefinition, this.getDropGroupFunction());
            }
        }
        return null;
    }

    private Function<ProcessDefinition, JpdlNode> getDropForkFunction() {
        return processDefinition -> {
            Fork fork = processDefinition.addFork();
            fork.getName().setStringValue(UNKNOWN);
            return new ForkNode((Fork)fork.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropJoinFunction() {
        return processDefinition -> {
            Join join = processDefinition.addJoin();
            join.getName().setStringValue(UNKNOWN);
            return new JoinNode((Join)join.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropJavaFunction() {
        return processDefinition -> {
            JavaActivity javaActivity = processDefinition.addJava();
            javaActivity.getName().setStringValue(UNKNOWN);
            return new JavaNode((JavaActivity)javaActivity.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropCustomFunction() {
        return processDefinition -> {
            Custom custom = processDefinition.addCustom();
            custom.getName().setStringValue(UNKNOWN);
            return new CustomNode((Custom)custom.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropScriptFunction() {
        return processDefinition -> {
            Script script = processDefinition.addScript();
            script.getName().setStringValue(UNKNOWN);
            return new ScriptNode((Script)script.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropSqlFunction() {
        return processDefinition -> {
            Sql sql = processDefinition.addSql();
            sql.getName().setStringValue(UNKNOWN);
            return new SqlNode((Sql)sql.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropHqlFunction() {
        return processDefinition -> {
            Hql hql = processDefinition.addHql();
            hql.getName().setStringValue(UNKNOWN);
            return new HqlNode((Hql)hql.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropGroupFunction() {
        return processDefinition -> {
            Group group = processDefinition.addGroup();
            group.getName().setStringValue(UNKNOWN);
            return new GroupNode((Group)group.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropRuleFunction() {
        return processDefinition -> {
            Rules rules = processDefinition.addRules();
            rules.getName().setStringValue(UNKNOWN);
            return new RulesNode((Rules)rules.createStableCopy());
        };
    }

    private Function<ProcessDefinition, JpdlNode> getDropRulesDecisionFunction() {
        return processDefinition -> {
            RulesDecision rulesDecision = processDefinition.addRulesDecision();
            rulesDecision.getName().setStringValue(UNKNOWN);
            return new RulesDecisionNode((RulesDecision)rulesDecision.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropEndFunction() {
        return processDefinition -> {
            End end = processDefinition.addEnd();
            end.getName().setStringValue(UNKNOWN);
            return new EndActivityNode.EndNode((End)end.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropEndCancelFunction() {
        return processDefinition -> {
            EndCancel endCancel = processDefinition.addEndCancel();
            endCancel.getName().setStringValue(UNKNOWN);
            return new EndActivityNode.EndCancelNode((EndCancel)endCancel.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropEndErrorFunction() {
        return processDefinition -> {
            EndError endError = processDefinition.addEndError();
            endError.getName().setStringValue(UNKNOWN);
            return new EndActivityNode.EndErrorNode((EndError)endError.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropStartFunction() {
        return processDefinition -> {
            Start start = processDefinition.addStart();
            start.getName().setStringValue(UNKNOWN);
            return new StartNode((Start)start.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropTaskFunction() {
        return processDefinition -> {
            Task task = processDefinition.addTask();
            task.getName().setStringValue(UNKNOWN);
            return new TaskNode((Task)task.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropSubProcessFunction() {
        return processDefinition -> {
            SubProcess processState = processDefinition.addSubProcess();
            processState.getName().setStringValue(UNKNOWN);
            return new SubProcessNode((SubProcess)processState.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropStateFunction() {
        return processDefinition -> {
            State state = processDefinition.addState();
            state.getName().setStringValue(UNKNOWN);
            return new StateNode((State)state.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropMailFunction() {
        return processDefinition -> {
            Mail mail = processDefinition.addMail();
            mail.getName().setStringValue(UNKNOWN);
            return new MailNode((Mail)mail.createStableCopy());
        };
    }

    private static Function<ProcessDefinition, JpdlNode> getDropDecisionFunction() {
        return processDefinition -> {
            Decision decision = processDefinition.addDecision();
            decision.getName().setStringValue(UNKNOWN);
            return new DecisionNode((Decision)decision.createStableCopy());
        };
    }

    private static JpdlNode startInWCA(Project project, final ProcessDefinition processDefinition, final Function<ProcessDefinition, JpdlNode> function) {
        return (JpdlNode)new WriteCommandAction<JpdlNode>(project, new PsiFile[]{DomUtil.getFile((DomElement)processDefinition)}){

            protected void run(@NotNull Result<JpdlNode> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jpdl/graph/dnd/JpdlDnDSupport$1", "run"));
                }
                result.setResult(function.fun((Object)processDefinition));
            }
        }.execute().getResultObject();
    }

    public JpdlDataModel getDataModel() {
        return this.myDataModel;
    }
}

